/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class RiteCrater
extends Rite {
    private final int radius;
    private final int height;

    public RiteCrater(int radius, int height) {
        this.radius = radius;
        this.height = height;
    }

    @Override
    public void addSteps(ArrayList<RitualStep> steps, int intialStage) {
        steps.add(new StepCrater(this, intialStage));
    }

    private static class StepCrater
    extends RitualStep {
        private final RiteCrater rite;
        private int stage = 0;

        public StepCrater(RiteCrater rite, int initialStage) {
            super(true);
            this.rite = rite;
            this.stage = initialStage;
        }

        @Override
        public int getCurrentStage() {
            return (byte)this.stage;
        }

        @Override
        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            if (ticks % 10L != 0L) {
                return RitualStep.Result.STARTING;
            }
            if (!world.isRemote) {
                if (++this.stage == 1) {
                    ParticleEffect.PORTAL.send(SoundEffect.RANDOM_FIZZ, world, posX, posY, posZ, 0.5, 1.0, 16);
                }
                int height = this.rite.height;
                float radius = this.rite.radius;
                if (this.stage <= height) {
                    for (int y = 1; y <= this.stage; ++y) {
                        float r = radius - (float)(height - this.stage - 1 + y) * radius / (float)height;
                        Log.instance().debug(String.format("Stage: %d, r=%f y=%d", this.stage, Float.valueOf(r), y));
                        this.drawFilledCircle(world, posX, posZ, posY - y, Math.max((int)Math.ceil(r), 1), posY);
                    }
                } else {
                    return RitualStep.Result.COMPLETED;
                }
                return RitualStep.Result.UPKEEP;
            }
            return RitualStep.Result.COMPLETED;
        }

        protected void drawFilledCircle(World world, int x0, int z0, int y, int radius, int height) {
            int x = radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawLine(world, -x + x0, x + x0, z + z0, y, x0, z0, radius, height);
                this.drawLine(world, -z + x0, z + x0, x + z0, y, x0, z0, radius, height);
                this.drawLine(world, -x + x0, x + x0, -z + z0, y, x0, z0, radius, height);
                this.drawLine(world, -z + x0, z + x0, -x + z0, y, x0, z0, radius, height);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }

        protected void drawLine(World world, int x1, int x2, int z, int y, int midX, int midZ, int radius, int midY) {
            int modX1 = radius > 1 && world.rand.nextInt(5) == 0 ? x1 + 1 : x1;
            int modX2 = radius > 1 && world.rand.nextInt(5) == 0 ? x2 - 1 : x2;
            boolean edgeZ = midZ + radius == z || midZ - radius == z;
            for (int x = modX1; x <= modX2; ++x) {
                this.drawPixel(world, x, z, y, midX, midY, midZ);
            }
            boolean done = true;
        }

        protected void drawPixel(World world, int x, int z, int y, int midX, int midY, int midZ) {
            if (!(world.isRemote || x == midX && z == midZ || y >= midY - 3 && !(Coord.distance(x, midY, z, midX, midY, midZ) > (double)(this.rite.radius - 3 - (midY - y))))) {
                Block blockID = world.getBlock(x, y, z);
                int blockMetadata = world.getBlockMetadata(x, y, z);
                if (BlockProtect.canBreak(x, y, z, world)) {
                    world.setBlockToAir(x, y, z);
                    if (blockID != Blocks.air && blockID != Blocks.stone && blockID != Blocks.dirt && blockID != Blocks.grass && blockID != Blocks.sand && blockID != Blocks.sandstone && blockID != Blocks.gravel) {
                        ItemStack stack = new ItemStack(blockID, 1, blockMetadata);
                        EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
                        world.spawnEntityInWorld((Entity)entity);
                    }
                }
            }
        }
    }
}

