/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockCircle;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;

public class RiteClimateChange
extends Rite {
    protected final int radius;

    public RiteClimateChange(int radius) {
        this.radius = radius;
    }

    @Override
    public void addSteps(ArrayList<RitualStep> steps, int intialStage) {
        steps.add(new StepClimateChange(this, intialStage));
    }

    private static class StepClimateChange
    extends RitualStep {
        private final RiteClimateChange rite;
        private int stage = 0;
        private boolean activated;

        public StepClimateChange(RiteClimateChange rite, int initialStage) {
            super(false);
            this.rite = rite;
            this.stage = initialStage;
        }

        @Override
        public int getCurrentStage() {
            return (byte)this.stage;
        }

        @Override
        public RitualStep.Result process(World world, int posX, int posY, int posZ, long ticks, BlockCircle.TileEntityCircle.ActivatedRitual ritual) {
            block54: {
                EntityPlayer player;
                block56: {
                    block55: {
                        if (!this.activated) {
                            if (ticks % 20L != 0L) {
                                return RitualStep.Result.STARTING;
                            }
                            this.activated = true;
                            SoundEffect.RANDOM_FIZZ.playAt(world, posX, posY, posZ);
                        }
                        if (world.isRemote) break block54;
                        player = ritual.getInitiatingPlayer(world);
                        if (!Config.instance().allowBiomeChanging) {
                            SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
                            if (player != null) {
                                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.disabled", new Object[0]);
                            }
                            return RitualStep.Result.ABORTED_REFUND;
                        }
                        BiomeGenBase biome = world.getBiomeGenForCoords(posX, posZ);
                        if (world.provider.dimensionId == 1 || world.provider.dimensionId == -1) break block55;
                        if (biome == BiomeGenBase.sky) break block55;
                        if (biome != BiomeGenBase.hell) break block56;
                    }
                    SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
                    if (player != null) {
                        ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.wrongdimension", new Object[0]);
                    }
                    return RitualStep.Result.ABORTED_REFUND;
                }
                if (ritual.covenSize < 4) {
                    SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
                    if (player != null) {
                        ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.coventoosmall", new Object[0]);
                    }
                    return RitualStep.Result.ABORTED_REFUND;
                }
                if (ticks % 20L == 0L) {
                    ++this.stage;
                    if (this.stage < 5) {
                        ParticleEffect.INSTANT_SPELL.send(SoundEffect.NONE, world, 0.5 + (double)posX, 1.0 + (double)posY, 0.5 + (double)posZ, (float)this.stage * 1.5f, (float)this.stage * 1.1f, 16);
                    } else if (this.stage == 5) {
                        ParticleEffect.HUGE_EXPLOSION.send(SoundEffect.NONE, world, 0.5 + (double)posX, 1.0 + (double)posY, 0.5 + (double)posZ, (float)this.stage * 2.0f, (float)this.stage * 1.5f, 16);
                        double RADIUS = 8.0;
                        List items = world.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)((double)posX - 8.0), (double)(posY - 2), (double)((double)posZ - 8.0), (double)((double)posX + 8.0), (double)(posY + 2), (double)((double)posZ + 8.0)));
                        BiomeDictionary.Type biomeType = BiomeDictionary.Type.END;
                        WeatherChange weather = WeatherChange.NONE;
                        int glowstone = 0;
                        for (Object obj : items) {
                            EntityItem item = (EntityItem)obj;
                            ItemStack stack = item.getEntityItem();
                            if (stack.isItemEqual(new ItemStack(Blocks.sapling, 1, 0))) {
                                biomeType = BiomeDictionary.Type.FOREST;
                            } else if (stack.isItemEqual(new ItemStack((Block)Blocks.tallgrass, 1, 1))) {
                                biomeType = BiomeDictionary.Type.PLAINS;
                            } else if (stack.isItemEqual(new ItemStack(Blocks.obsidian))) {
                                biomeType = BiomeDictionary.Type.MOUNTAIN;
                            } else if (stack.isItemEqual(new ItemStack(Blocks.stone))) {
                                biomeType = BiomeDictionary.Type.HILLS;
                            } else if (stack.isItemEqual(new ItemStack(Items.slime_ball))) {
                                biomeType = BiomeDictionary.Type.SWAMP;
                            } else if (stack.isItemEqual(new ItemStack(Items.water_bucket))) {
                                biomeType = BiomeDictionary.Type.WATER;
                            } else if (stack.isItemEqual(new ItemStack(Blocks.cactus))) {
                                biomeType = BiomeDictionary.Type.DESERT;
                                weather = WeatherChange.SUN;
                            } else if (stack.isItemEqual(Witchery.Items.GENERIC.itemIcyNeedle.createStack())) {
                                biomeType = BiomeDictionary.Type.FROZEN;
                                weather = WeatherChange.RAIN;
                            } else if (stack.isItemEqual(new ItemStack(Blocks.sapling, 1, 3))) {
                                biomeType = BiomeDictionary.Type.JUNGLE;
                            } else if (stack.isItemEqual(new ItemStack(Blocks.netherrack))) {
                                biomeType = BiomeDictionary.Type.WASTELAND;
                            } else if (stack.isItemEqual(new ItemStack((Block)Blocks.sand))) {
                                biomeType = BiomeDictionary.Type.BEACH;
                            } else if (stack.isItemEqual(new ItemStack((Block)Blocks.red_mushroom))) {
                                biomeType = BiomeDictionary.Type.MUSHROOM;
                            } else if (stack.isItemEqual(new ItemStack(Items.skull))) {
                                biomeType = BiomeDictionary.Type.MAGICAL;
                            } else {
                                if (stack.getItem() != Items.glowstone_dust) continue;
                                glowstone += stack.stackSize;
                            }
                            world.removeEntity((Entity)item);
                            ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_POP, (Entity)item, 0.5, 1.0, 16);
                        }
                        if (biomeType == BiomeDictionary.Type.END) {
                            SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
                            if (player != null) {
                                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.missingbiomefoci", new Object[0]);
                            }
                            return RitualStep.Result.ABORTED_REFUND;
                        }
                        BiomeGenBase[] biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType);
                        if (biomes == null || biomes.length == 0) {
                            SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
                            if (player != null) {
                                ChatUtil.sendTranslated(EnumChatFormatting.DARK_RED, (ICommandSender)player, "witchery.rite.missingbiomefoci", new Object[0]);
                            }
                            return RitualStep.Result.ABORTED_REFUND;
                        }
                        int biomeID = biomes[glowstone > 0 ? Math.min((int)glowstone, (int)biomes.length) - 1 : (biomes.length >= 3 ? world.rand.nextInt((int)3) : 0)].biomeID;
                        int maxRadius = this.rite.radius * (ritual.covenSize - 3);
                        HashMap<ChunkCoord, byte[]> chunkMap = new HashMap<ChunkCoord, byte[]>();
                        this.drawFilledCircle(world, posX, posZ, maxRadius, chunkMap, weather, biomeID);
                        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
                        for (Map.Entry<ChunkCoord, byte[]> entry : chunkMap.entrySet()) {
                            Chunk chunk = entry.getKey().getChunk(world);
                            chunk.setBiomeArray(entry.getValue());
                            chunks.add(chunk);
                        }
                        S26PacketMapChunkBulk packet = new S26PacketMapChunkBulk(chunks);
                        Witchery.packetPipeline.sendToDimension((Packet)packet, world);
                        for (Object e : chunks) {
                            Chunk chunk = (Chunk)e;
                            for (Object tileObj : chunk.chunkTileEntityMap.values()) {
                                TileEntity tile = (TileEntity)tileObj;
                                Packet packet2 = tile.getDescriptionPacket();
                                if (packet2 == null) continue;
                                world.markBlockForUpdate(tile.xCoord, tile.yCoord, tile.zCoord);
                            }
                        }
                        if (world instanceof WorldServer) {
                            WorldInfo worldinfo = ((WorldServer)world).getWorldInfo();
                            int n = (300 + world.rand.nextInt(600)) * 20;
                            switch (weather) {
                                case SUN: {
                                    if (!world.isRaining() && !world.isThundering()) break;
                                    worldinfo.setRainTime(0);
                                    worldinfo.setThunderTime(0);
                                    worldinfo.setRaining(false);
                                    worldinfo.setThundering(false);
                                    break;
                                }
                                case RAIN: {
                                    if (world.isRaining() || world.isThundering()) break;
                                    worldinfo.setRainTime(n);
                                    worldinfo.setThunderTime(n);
                                    worldinfo.setRaining(true);
                                    worldinfo.setThundering(false);
                                    break;
                                }
                                case THUNDER: {
                                    if (world.isThundering()) break;
                                    worldinfo.setRainTime(n);
                                    worldinfo.setThunderTime(n);
                                    worldinfo.setRaining(true);
                                    worldinfo.setThundering(true);
                                    break;
                                }
                            }
                        }
                        return RitualStep.Result.COMPLETED;
                    }
                    return RitualStep.Result.UPKEEP;
                }
                return RitualStep.Result.UPKEEP;
            }
            return RitualStep.Result.COMPLETED;
        }

        private static byte[] rotateMatrix(byte[] matrix, int n) {
            byte[] ret = new byte[matrix.length];
            for (int i = 0; i < matrix.length / n; ++i) {
                for (int j = 0; j < n; ++j) {
                    ret[j * n + i] = matrix[i * n + n - j];
                }
            }
            return ret;
        }

        protected void drawFilledCircle(World world, int x0, int z0, int radius, HashMap<ChunkCoord, byte[]> chunkMap, WeatherChange weather, int biomeID) {
            int x = radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawLine(world, -x + x0, x + x0, z + z0, chunkMap, weather, biomeID);
                this.drawLine(world, -z + x0, z + x0, x + z0, chunkMap, weather, biomeID);
                this.drawLine(world, -x + x0, x + x0, -z + z0, chunkMap, weather, biomeID);
                this.drawLine(world, -z + x0, z + x0, -x + z0, chunkMap, weather, biomeID);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }

        protected void drawLine(World world, int x1, int x2, int z, HashMap<ChunkCoord, byte[]> chunkMap, WeatherChange weather, int biomeID) {
            for (int x = x1; x <= x2; ++x) {
                int y;
                ChunkCoord coord = new ChunkCoord(x >> 4, z >> 4);
                byte[] map = chunkMap.get(coord);
                if (map == null) {
                    Chunk chunk = world.getChunkFromBlockCoords(x, z);
                    map = (byte[])chunk.getBiomeArray().clone();
                    chunkMap.put(coord, map);
                }
                map[(z & 0xF) << 4 | x & 0xF] = (byte)biomeID;
                if (weather != WeatherChange.SUN || world.getBlock(x, y = world.getTopSolidOrLiquidBlock(x, z), z) != Blocks.snow) continue;
                world.setBlockToAir(x, y, z);
            }
        }

        private static class ChunkCoord {
            public final int X;
            public final int Z;

            public ChunkCoord(int x, int z) {
                this.X = x;
                this.Z = z;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                ChunkCoord other = (ChunkCoord)obj;
                return this.X == other.X && this.Z == other.Z;
            }

            public int hashCode() {
                int result = this.X ^ this.X >>> 32;
                result = 31 * result + (this.Z ^ this.Z >>> 32);
                return result;
            }

            public Chunk getChunk(World world) {
                return world.getChunkFromChunkCoords(this.X, this.Z);
            }
        }
    }

    public static enum WeatherChange {
        NONE,
        SUN,
        RAIN,
        THUNDER;

    }
}

