/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.ritual.rites;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.ritual.rites.RiteExpandingEffect;
import com.emoniph.witchery.util.Log;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class RiteBlight
extends RiteExpandingEffect {
    public RiteBlight(int radius, int height) {
        super(radius, height, true);
    }

    @Override
    public boolean doRadiusAction(World world, int posX, int posY, int posZ, int radius, EntityPlayer player, boolean enhanced) {
        EntityZombie entityzombie;
        double radiusSq = radius * radius;
        double minSq = Math.max(0, (radius - 1) * (radius - 1));
        for (Object obj : world.playerEntities) {
            EntityPlayer victim = (EntityPlayer)obj;
            double distanceSq = victim.getDistanceSq(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ);
            if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
            if (Witchery.Items.POPPET.voodooProtectionActivated(player, null, (EntityLivingBase)victim, 6)) {
                return false;
            }
            if (victim.isPotionActive(Potion.confusion)) continue;
            victim.addPotionEffect(new PotionEffect(Potion.confusion.id, 2400, 1));
        }
        ArrayList<EntityVillager> villagersToZombify = new ArrayList<EntityVillager>();
        ArrayList<EntityVillager> cowsToSchroom = new ArrayList<EntityVillager>();
        ArrayList<EntityVillager> animalsToSlay = new ArrayList<EntityVillager>();
        for (Object e : world.loadedEntityList) {
            double distanceSq;
            EntityVillager victim;
            if (e instanceof EntityVillager) {
                victim = (EntityVillager)e;
                distanceSq = victim.getDistanceSq(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ);
                if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
                Log.instance().debug(String.format("Try Adding zombie %f %f %f", distanceSq, minSq, radiusSq));
                if (world.rand.nextInt(10) != 0) continue;
                Log.instance().debug("Added zombie");
                villagersToZombify.add(victim);
                continue;
            }
            if (e instanceof EntityCow) {
                victim = (EntityCow)e;
                distanceSq = victim.getDistanceSq(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ);
                if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
                Log.instance().debug(String.format("Try Adding mooschroom %f %f %f", distanceSq, minSq, radiusSq));
                if (world.rand.nextInt(20) == 0) {
                    Log.instance().debug("Added mooschroom");
                    cowsToSchroom.add(victim);
                    continue;
                }
                if (world.rand.nextInt(3) != 0) continue;
                animalsToSlay.add(victim);
                continue;
            }
            if (!(e instanceof EntityAnimal) || !((distanceSq = (victim = (EntityAnimal)e).getDistanceSq(0.5 + (double)posX, 0.5 + (double)posY, 0.5 + (double)posZ)) > minSq) || !(distanceSq <= radiusSq) || world.rand.nextInt(3) != 0) continue;
            animalsToSlay.add(victim);
        }
        for (EntityVillager entityVillager : villagersToZombify) {
            entityzombie = new EntityZombie(world);
            entityzombie.copyLocationAndAnglesFrom((Entity)entityVillager);
            world.removeEntity((Entity)entityVillager);
            entityzombie.onSpawnWithEgg((IEntityLivingData)null);
            entityzombie.setVillager(true);
            if (entityVillager.isChild()) {
                entityzombie.setChild(true);
            }
            world.spawnEntityInWorld((Entity)entityzombie);
            world.playAuxSFXAtEntity((EntityPlayer)null, 1016, (int)entityzombie.posX, (int)entityzombie.posY, (int)entityzombie.posZ, 0);
        }
        for (EntityCow entityCow : cowsToSchroom) {
            entityzombie = new EntityMooshroom(world);
            entityzombie.copyLocationAndAnglesFrom((Entity)entityCow);
            world.removeEntity((Entity)entityCow);
            entityzombie.onSpawnWithEgg((IEntityLivingData)null);
            world.spawnEntityInWorld((Entity)entityzombie);
            world.playAuxSFXAtEntity((EntityPlayer)null, 1016, (int)entityzombie.posX, (int)entityzombie.posY, (int)entityzombie.posZ, 0);
        }
        for (EntityAnimal entityAnimal : animalsToSlay) {
            entityAnimal.attackEntityFrom(DamageSource.magic, 20.0f);
        }
        return true;
    }

    @Override
    public void doBlockAction(World world, int posX, int posY, int posZ, int currentRadius, EntityPlayer player, boolean enhanced) {
        if (!world.isRemote) {
            Block blockID = world.getBlock(posX, posY, posZ);
            Block blockBelowID = world.getBlock(posX, posY - 1, posZ);
            if (blockID == Blocks.tallgrass) {
                world.setBlockToAir(posX, posY, posZ);
                this.blightGround(world, posX, posY - 1, posZ, blockBelowID, enhanced);
            } else if (blockID == Blocks.red_flower || blockID == Blocks.yellow_flower || blockID == Blocks.carrots || blockID == Blocks.wheat || blockID == Blocks.potatoes || blockID == Blocks.pumpkin_stem || blockID == Blocks.melon_stem || blockID == Blocks.melon_block || blockID == Blocks.pumpkin) {
                world.setBlock(posX, posY, posZ, (Block)Blocks.deadbush);
                this.blightGround(world, posX, posY - 1, posZ, blockBelowID, enhanced);
            } else if (blockID == Blocks.farmland) {
                world.setBlock(posX, posY, posZ, (Block)Blocks.sand);
            } else if (blockID.getMaterial().isSolid()) {
                this.blightGround(world, posX, posY, posZ, blockID, enhanced);
            } else if (blockBelowID.getMaterial().isSolid()) {
                this.blightGround(world, posX, posY - 1, posZ, blockBelowID, enhanced);
            }
        }
    }

    public void blightGround(World world, int posX, int posY, int posZ, Block blockBelowID, boolean enhanced) {
        if (blockBelowID == Blocks.dirt || blockBelowID == Blocks.grass || blockBelowID == Blocks.mycelium || blockBelowID == Blocks.farmland) {
            int rand = world.rand.nextInt(enhanced ? 4 : 5);
            if (rand == 0) {
                world.setBlock(posX, posY, posZ, (Block)Blocks.sand);
            } else if (rand == 1) {
                world.setBlock(posX, posY, posZ, Blocks.dirt);
            }
        }
    }
}

