/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.predictions;

import com.emoniph.witchery.predictions.Prediction;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.Log;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PredictionFall
extends Prediction {
    public PredictionFall(int id, int itemWeight, double selfFulfillmentProbabilityPerSec, String translationKey) {
        super(id, itemWeight, selfFulfillmentProbabilityPerSec, translationKey);
    }

    @Override
    public boolean doSelfFulfillment(World world, EntityPlayer player) {
        int FALL_DISTANCE = 6;
        boolean RADIUS = true;
        int x0 = MathHelper.floor_double((double)player.posX);
        int y0 = MathHelper.floor_double((double)player.posY) - 1;
        int z0 = MathHelper.floor_double((double)player.posZ);
        if (!world.isRemote && y0 > 8) {
            int z;
            int x;
            int dirtCount = 0;
            for (x = x0 - 1; x <= x0 + 1; ++x) {
                for (z = z0 - 1; z <= z0 + 1; ++z) {
                    Material material = world.getBlock(x, y0, z).getMaterial();
                    if (material != Material.ground && material != Material.grass) continue;
                    ++dirtCount;
                }
            }
            if ((double)dirtCount == Math.pow(3.0, 2.0)) {
                for (x = x0 - 1; x <= x0 + 1; ++x) {
                    for (z = z0 - 1; z <= z0 + 1; ++z) {
                        for (int y = y0; y > y0 - 6; --y) {
                            if (y == y0) {
                                world.setBlock(x, y, z, Blocks.gravel);
                                continue;
                            }
                            if (!BlockProtect.canBreak(world.getBlock(x, y, z), world)) continue;
                            world.setBlockToAir(x, y, z);
                        }
                    }
                }
                Log.instance().debug(String.format("Prediction for falling has been forced", new Object[0]));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkIfFulfilled(World world, EntityPlayer player, LivingHurtEvent event, boolean isPastDue, boolean veryOld) {
        if (!event.isCanceled()) {
            boolean fallen;
            boolean bl = fallen = event.source == DamageSource.fall;
            if (fallen) {
                Log.instance().debug(String.format("Prediction for FALL fulfilled as predicted", new Object[0]));
            }
            return fallen;
        }
        return false;
    }
}

