/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item.brew;

import com.emoniph.witchery.item.ItemGeneral;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BrewFluid
extends ItemGeneral.Brew {
    protected final Fluid fluid;

    public BrewFluid(int damageValue, String unlocalisedName, Fluid fluid) {
        super(damageValue, unlocalisedName);
        this.fluid = fluid;
    }

    @Override
    public ItemGeneral.Brew.BrewResult onImpact(World world, EntityLivingBase thrower, MovingObjectPosition mop, boolean enhanced, double brewX, double brewY, double brewZ, AxisAlignedBB brewBounds) {
        switch (mop.typeOfHit) {
            case BLOCK: {
                this.depositLiquid(world, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit, enhanced);
                break;
            }
            case ENTITY: {
                int x = MathHelper.floor_double((double)mop.entityHit.posX);
                int y = MathHelper.floor_double((double)mop.entityHit.posY);
                int z = MathHelper.floor_double((double)mop.entityHit.posZ);
                this.depositLiquid(world, x, y, z, -1, enhanced);
                break;
            }
        }
        return ItemGeneral.Brew.BrewResult.SHOW_EFFECT;
    }

    public void depositLiquid(World world, int posX, int posY, int posZ, int side, boolean enhanced) {
        int x = posX + (side == 4 ? -1 : (side == 5 ? 1 : 0));
        int z = posZ + (side == 2 ? -1 : (side == 3 ? 1 : 0));
        int y = posY + (side == 0 ? -1 : (side == 1 ? 1 : 0));
        if (side == 1 && !world.getBlock(x, posY, z).getMaterial().isSolid()) {
            --y;
        }
        BrewFluid.setBlockIfNotSolid(world, x, y, z, this.fluid.getBlock());
    }
}

