/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.blocks.BlockVoidBramble;
import com.emoniph.witchery.client.model.ModelWitchesClothes;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemWitchesClothes
extends ItemArmor {
    private static final int CHARGE_PER_PIECE = 2;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelNecroChest;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelClothesLegs;
    private static final String BIBLIOCRAFT_ARMOR_STAND_ENTITY_NAME = "AbstractSteve";
    private static String noPlaceLikeHome = null;
    private static final double WILD_EFFECT_CHANCE = 0.01;

    public ItemWitchesClothes(int armorSlot) {
        super(ItemArmor.ArmorMaterial.CLOTH, 1, armorSlot);
        this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
    }

    public Item setUnlocalizedName(String itemName) {
        ItemUtil.registerItem((Item)this, itemName);
        return super.setUnlocalizedName(itemName);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack != null && (stack.getItem() == Witchery.Items.WITCH_HAT || stack.getItem() == Witchery.Items.WITCH_ROBES || stack.getItem() == Witchery.Items.NECROMANCERS_ROBES || stack.getItem() == Witchery.Items.ICY_SLIPPERS || stack.getItem() == Witchery.Items.RUBY_SLIPPERS || stack.getItem() == Witchery.Items.SEEPING_SHOES || stack.getItem() == Witchery.Items.BABAS_HAT)) {
            return "witchery:textures/entities/witchclothes" + (type == null ? "" : "_overlay") + ".png";
        }
        if (stack != null && stack.getItem() == Witchery.Items.BITING_BELT) {
            return "witchery:textures/entities/witchclothes_legs" + (type == null ? "" : "_overlay") + ".png";
        }
        if (stack != null && stack.getItem() == Witchery.Items.BARK_BELT) {
            return "witchery:textures/entities/witchclothes" + (type == null ? "2_legs" : "_legs_overlay") + ".png";
        }
        return null;
    }

    public int getMaxChargeLevel(EntityLivingBase entity) {
        int level = 0;
        for (int i = 1; i <= 4; ++i) {
            ItemStack stack = entity.getEquipmentInSlot(i);
            if (stack == null || !(stack.getItem() instanceof ItemWitchesClothes)) continue;
            level += 2;
        }
        return level;
    }

    public void setChargeLevel(ItemStack stack, int level) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        nbtRoot.setInteger("WITCBarkPieces", level);
    }

    public int getChargeLevel(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (stack.hasTagCompound() && (nbtRoot = stack.getTagCompound()).hasKey("WITCBarkPieces")) {
            return nbtRoot.getInteger("WITCBarkPieces");
        }
        return 0;
    }

    public boolean hasColor(ItemStack stack) {
        return stack == null || stack.getItem() != Witchery.Items.BABAS_HAT;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return super.getColor(stack);
        }
        if (stack.getItem() == Witchery.Items.RUBY_SLIPPERS) {
            return 0xDD0000;
        }
        int color = super.getColor(stack);
        if (color == 10511680) {
            color = this == Witchery.Items.ICY_SLIPPERS ? 7842303 : (this == Witchery.Items.SEEPING_SHOES ? 0x226633 : (this == Witchery.Items.BARK_BELT ? 6968628 : 2628115));
        }
        return color;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int par2) {
        return super.getColorFromItemStack(stack, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int par1, int par2) {
        return this.getIconFromDamage(par1);
    }

    public boolean isHatWorn(EntityPlayer player) {
        return player.inventory.armorItemInSlot(3) != null && player.inventory.armorItemInSlot(3).getItem() == this;
    }

    public boolean isRobeWorn(EntityPlayer player) {
        return player.inventory.armorItemInSlot(2) != null && player.inventory.armorItemInSlot(2).getItem() == this;
    }

    public boolean isBeltWorn(EntityPlayer player) {
        return player.inventory.armorItemInSlot(1) != null && player.inventory.armorItemInSlot(1).getItem() == this;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        int type;
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelWitchesClothes(0.61f, false);
        }
        if (this.modelNecroChest == null) {
            this.modelNecroChest = new ModelWitchesClothes(0.61f, true);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelWitchesClothes(0.45f, false);
        }
        ModelWitchesClothes armorModel = null;
        if (stack != null && stack.getItem() instanceof ItemWitchesClothes && (armorModel = (type = ((ItemArmor)stack.getItem()).armorType) == 1 || type == 3 ? (stack.getItem() == Witchery.Items.NECROMANCERS_ROBES ? this.modelNecroChest : this.modelClothesChest) : this.modelClothesLegs) != null) {
            boolean isVisible = true;
            if (entityLiving != null && entityLiving.isInvisible()) {
                String entityTypeName = entityLiving.getClass().getSimpleName();
                isVisible = entityTypeName == null || entityTypeName.isEmpty() || entityTypeName.equals(BIBLIOCRAFT_ARMOR_STAND_ENTITY_NAME);
            }
            armorModel.bipedHead.showModel = isVisible && armorSlot == 0;
            armorModel.bipedHeadwear.showModel = isVisible && armorSlot == 0;
            armorModel.bipedBody.showModel = isVisible && (armorSlot == 1 || armorSlot == 2);
            armorModel.bipedRightArm.showModel = isVisible && armorSlot == 1;
            armorModel.bipedLeftArm.showModel = isVisible && armorSlot == 1;
            armorModel.bipedRightLeg.showModel = isVisible && armorSlot == 3;
            armorModel.bipedLeftLeg.showModel = isVisible && armorSlot == 3;
            armorModel.isSneak = entityLiving.isSneaking();
            armorModel.isRiding = entityLiving.isRiding();
            armorModel.isChild = entityLiving.isChild();
            ItemStack heldStack = entityLiving.getEquipmentInSlot(0);
            armorModel.heldItemRight = heldStack != null ? 1 : 0;
            armorModel.aimedBow = false;
            if (entityLiving instanceof EntityPlayer && heldStack != null && ((EntityPlayer)entityLiving).getItemInUseDuration() > 0) {
                EnumAction enumaction = heldStack.getItemUseAction();
                if (enumaction == EnumAction.block) {
                    armorModel.heldItemRight = 3;
                }
                armorModel.aimedBow = enumaction == EnumAction.bow;
            }
            return armorModel;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        if (stack == null) {
            return EnumRarity.common;
        }
        if (stack.getItem() == Witchery.Items.BABAS_HAT) {
            return EnumRarity.epic;
        }
        if (stack.getItem() == Witchery.Items.BARK_BELT) {
            return EnumRarity.rare;
        }
        return EnumRarity.uncommon;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String baseName = super.getItemStackDisplayName(stack);
        return baseName;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        String s2;
        String s1;
        int potion;
        List effects;
        String localText = Witchery.resource(this.getUnlocalizedName() + ".tip");
        if (localText != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
        if (stack != null && stack.hasTagCompound() && stack.getTagCompound().hasKey("WITCPotion") && (effects = Items.potionitem.getEffects(potion = stack.getTagCompound().getInteger("WITCPotion"))) != null && !effects.isEmpty()) {
            PotionEffect effect = (PotionEffect)effects.get(0);
            s1 = effect.getEffectName();
            s1 = s1 + ".postfix";
            s2 = "\u00a76" + StatCollector.translateToLocal((String)s1).trim() + "\u00a7r";
            if (effect.getAmplifier() > 0) {
                s2 = s2 + " " + StatCollector.translateToLocal((String)("potion.potency." + effect.getAmplifier())).trim();
            }
            if (effect.getDuration() > 20) {
                s2 = s2 + " [" + Potion.getDurationString((PotionEffect)effect) + "]";
            }
            list.add(s2);
        }
        if (stack != null && stack.hasTagCompound() && stack.getTagCompound().hasKey("WITCPotion2") && (effects = Items.potionitem.getEffects(potion = stack.getTagCompound().getInteger("WITCPotion2"))) != null && !effects.isEmpty()) {
            PotionEffect effect = (PotionEffect)effects.get(0);
            s1 = effect.getEffectName();
            s1 = s1 + ".postfix";
            s2 = "\u00a76" + StatCollector.translateToLocal((String)s1).trim() + "\u00a7r";
            if (effect.getAmplifier() > 0) {
                s2 = s2 + " " + StatCollector.translateToLocal((String)("potion.potency." + effect.getAmplifier())).trim();
            }
            if (effect.getDuration() > 20) {
                s2 = s2 + " [" + Potion.getDurationString((PotionEffect)effect) + "]";
            }
            list.add(s2);
        }
    }

    public boolean trySayTheresNoPlaceLikeHome(EntityPlayer player, String message) {
        NBTTagCompound nbtPlayer;
        ItemStack stack;
        if (player == null || player.worldObj.isRemote) {
            return false;
        }
        if (noPlaceLikeHome == null) {
            noPlaceLikeHome = Witchery.resource("witchery.rite.noplacelikehome").toLowerCase().replace("'", "");
        }
        if (message.toLowerCase().replace("'", "").startsWith(noPlaceLikeHome) && (stack = player.getEquipmentInSlot(1)) != null && stack.getItem() == Witchery.Items.RUBY_SLIPPERS && player.dimension != Config.instance().dimensionDreamID && (nbtPlayer = Infusion.getNBT((Entity)player)) != null) {
            int R = 3;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 3.0), (double)(player.posY - 3.0), (double)(player.posZ - 3.0), (double)(player.posX + 3.0), (double)(player.posY + 3.0), (double)(player.posZ + 3.0));
            List list = player.worldObj.getEntitiesWithinAABB(EntityItem.class, bounds);
            for (Object obj : list) {
                int waystoneDimension;
                EntityItem waystoneEntity = (EntityItem)obj;
                ItemStack waystoneStack = waystoneEntity.getEntityItem();
                if (waystoneStack == null || !Witchery.Items.GENERIC.itemWaystoneBound.isMatch(waystoneStack)) continue;
                if (nbtPlayer.hasKey("WITCLastRubySlipperWayTime")) {
                    long lastTime = nbtPlayer.getLong("WITCLastRubySlipperWayTime");
                    long currentTime = MinecraftServer.getSystemTimeMillis();
                    long timeSince = currentTime - lastTime;
                    long COOLDOWN = 60000L;
                    if (timeSince < 60000L) {
                        int cooldownRemaining = Math.max(1, (int)(60000L - timeSince) / 60000);
                        ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.slippersoncooldown", Integer.valueOf(cooldownRemaining).toString());
                        return true;
                    }
                }
                if (Infusion.aquireEnergy(player.worldObj, player, nbtPlayer, (waystoneDimension = ItemGeneral.getWaystoneDimension(waystoneStack)) != player.dimension ? 80 : 40, true)) {
                    waystoneEntity.setDead();
                    nbtPlayer.setLong("WITCLastRubySlipperWayTime", MinecraftServer.getSystemTimeMillis());
                    if (player.worldObj.rand.nextDouble() < 0.01) {
                        BlockVoidBramble.teleportRandomly(player.worldObj, MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), (Entity)player, 500);
                    } else {
                        Witchery.Items.GENERIC.teleportToLocation(player.worldObj, waystoneStack, (Entity)player, 2, true);
                    }
                }
                return true;
            }
            if (nbtPlayer.hasKey("WITCLastRubySlipperTime")) {
                long lastTime = nbtPlayer.getLong("WITCLastRubySlipperTime");
                long currentTime = MinecraftServer.getSystemTimeMillis();
                long timeSince = currentTime - lastTime;
                long COOLDOWN = 1800000L;
                if (timeSince < 1800000L && !player.capabilities.isCreativeMode) {
                    int cooldownRemaining = Math.max(1, (int)(1800000L - timeSince) / 60000);
                    ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.slippersoncooldown", Integer.valueOf(cooldownRemaining).toString());
                    return true;
                }
            }
            ChunkCoordinates coords = player.getBedLocation(player.dimension);
            int dimension = player.dimension;
            World world = player.worldObj;
            if (coords == null) {
                coords = player.getBedLocation(0);
                dimension = 0;
                world = MinecraftServer.getServer().worldServerForDimension(0);
                if (coords == null) {
                    coords = world.getSpawnPoint();
                    while (world.getBlock(coords.posX, coords.posY, coords.posZ).isNormalCube() && coords.posY < 255) {
                        ++coords.posY;
                    }
                }
            }
            if (coords != null) {
                nbtPlayer.setLong("WITCLastRubySlipperTime", MinecraftServer.getSystemTimeMillis());
                coords = Blocks.bed.getBedSpawnPosition((IBlockAccess)world, coords.posX, coords.posY, coords.posZ, null);
                if (coords != null) {
                    if (Infusion.aquireEnergy(player.worldObj, player, nbtPlayer, dimension != player.dimension ? 120 : 80, true)) {
                        ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                        ItemGeneral.teleportToLocation(player.worldObj, coords.posX, coords.posY + 1, coords.posZ, dimension, (Entity)player, true);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

