/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBloodRose;
import com.emoniph.witchery.blocks.BlockCrystalBall;
import com.emoniph.witchery.blocks.BlockLeechChest;
import com.emoniph.witchery.entity.EntityEye;
import com.emoniph.witchery.entity.EntityImp;
import com.emoniph.witchery.entity.EntityTreefyd;
import com.emoniph.witchery.entity.EntityWingedMonkey;
import com.emoniph.witchery.item.ItemBase;
import com.emoniph.witchery.network.PacketCamPos;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemTaglockKit
extends ItemBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon emptyIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon fullIcon;
    static final String KEY_PLAYER_NAME = "WITCPlayer";
    static final String KEY_DISPLAY_NAME = "WITCDisplayName";
    static final String KEY_ENTITY_ID_MOST = "WITCEntityIDm";
    static final String KEY_ENTITY_ID_LEAST = "WITCEntityIDl";

    public ItemTaglockKit() {
        this.setMaxStackSize(16);
        this.setMaxDamage(0);
    }

    public String getItemStackDisplayName(ItemStack itemStack) {
        String entityID = this.getBoundEntityDisplayName(itemStack, 1);
        String localizedName = super.getItemStackDisplayName(itemStack);
        return !entityID.isEmpty() ? String.format("%s (%s)", localizedName, entityID) : localizedName;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advTooltips) {
        super.addInformation(stack, player, list, advTooltips);
        String entityID = this.getBoundEntityDisplayName(stack, 1);
        if (entityID != null && !entityID.isEmpty()) {
            list.add(String.format(Witchery.resource("item.witcheryTaglockKit.boundto"), entityID));
        } else {
            list.add(Witchery.resource("item.witcheryTaglockKit.unbound"));
        }
    }

    public void registerIcons(IIconRegister par1IconRegister) {
        this.emptyIcon = par1IconRegister.registerIcon(this.getIconString());
        this.fullIcon = par1IconRegister.registerIcon(this.getIconString() + ".full");
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 1200;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int countdown) {
        World world = player.worldObj;
        int elapsedTicks = this.getMaxItemUseDuration(stack) - countdown;
        if (!world.isRemote && elapsedTicks % 20 == 0) {
            EntityLivingBase entity = this.getBoundEntity(world, (Entity)player, stack, 1);
            if (entity != null && entity.dimension == player.dimension) {
                if (entity == player) {
                    if (elapsedTicks == 0) {
                        EntityEye eye = new EntityEye(world);
                        eye.setLocationAndAngles(player.posX, player.posY, player.posZ, player.rotationYaw, 90.0f);
                        world.spawnEntityInWorld((Entity)eye);
                        Witchery.packetPipeline.sendTo((IMessage)new PacketCamPos(true, elapsedTicks == 0, (Entity)eye), player);
                    } else {
                        Witchery.packetPipeline.sendTo((IMessage)new PacketCamPos(true, false, null), player);
                    }
                } else {
                    Witchery.packetPipeline.sendTo((IMessage)new PacketCamPos(true, elapsedTicks == 0, (Entity)entity), player);
                }
            } else {
                Witchery.packetPipeline.sendTo((IMessage)new PacketCamPos(false, false, null), player);
            }
        }
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.none;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            Witchery.packetPipeline.sendTo((IMessage)new PacketCamPos(false, false, null), player);
        }
        return stack;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int countdown) {
        if (!world.isRemote) {
            Witchery.packetPipeline.sendTo((IMessage)new PacketCamPos(false, false, null), player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damageValue) {
        return damageValue == 1 ? this.fullIcon : this.emptyIcon;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.getBlock(x, y, z);
        if (block == Blocks.bed || block == Witchery.Blocks.COFFIN || block.getUnlocalizedName().equals("tile.blockCarpentersBed") || block.isBed((IBlockAccess)world, x, y, z, (EntityLivingBase)player)) {
            int j1;
            int i1 = world.getBlockMetadata(x, y, z);
            Log.instance().debug(String.format("Using taglock on bed [%s] meta %d", block.getUnlocalizedName(), i1));
            if (block == Blocks.bed && !BlockBed.isBlockHeadOfBed((int)i1) && world.getBlock(x += BlockBed.field_149981_a[j1 = BlockBed.getDirection((int)i1)][0], y, z += BlockBed.field_149981_a[j1][1]) != Blocks.bed) {
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
                return !world.isRemote;
            }
            ChunkCoordinates clickedBedLocation = new ChunkCoordinates(x, y, z);
            if (player.isSneaking()) {
                if (!world.isRemote) {
                    this.setTaglockForEntity(world, player, itemstack, player);
                }
                return !world.isRemote;
            }
            if (!world.isRemote) {
                boolean taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, clickedBedLocation);
                if (!taglockSaved && block != Blocks.bed) {
                    if (world.getBlock(x + 1, y, z) == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, new ChunkCoordinates(x + 1, y, z));
                    }
                    if (!taglockSaved && world.getBlock(x, y, z + 1) == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, new ChunkCoordinates(x, y, z + 1));
                    }
                    if (!taglockSaved && world.getBlock(x - 1, y, z) == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, new ChunkCoordinates(x - 1, y, z));
                    }
                    if (!taglockSaved && world.getBlock(x, y, z - 1) == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, new ChunkCoordinates(x, y, z - 1));
                    }
                }
                if (taglockSaved) {
                    return !world.isRemote;
                }
            }
            if (!world.isRemote) {
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
            return !world.isRemote;
        }
        if (block == Witchery.Blocks.LEECH_CHEST) {
            if (!world.isRemote) {
                BlockLeechChest.TileEntityLeechChest chest;
                String username;
                TileEntity tile = world.getTileEntity(x, y, z);
                if (tile != null && tile instanceof BlockLeechChest.TileEntityLeechChest && (username = (chest = (BlockLeechChest.TileEntityLeechChest)tile).popUserExcept(player)) != null && !username.isEmpty()) {
                    this.setTaglockForEntity(world, player, itemstack, username);
                    return !world.isRemote;
                }
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
            return !world.isRemote;
        }
        if (block == Witchery.Blocks.BLOOD_ROSE) {
            if (!world.isRemote) {
                BlockBloodRose.TileEntityBloodRose chest;
                String username;
                TileEntity tile = world.getTileEntity(x, y, z);
                if (tile != null && tile instanceof BlockBloodRose.TileEntityBloodRose && (username = (chest = (BlockBloodRose.TileEntityBloodRose)tile).popUserExcept(player, false)) != null && !username.isEmpty()) {
                    this.setTaglockForEntity(world, player, itemstack, username);
                    return !world.isRemote;
                }
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
            return !world.isRemote;
        }
        if (block == Witchery.Blocks.CRYSTAL_BALL) {
            if (itemstack.getItemDamage() > 0) {
                if (!world.isRemote && BlockCrystalBall.tryConsumePower(world, player, x, y, z)) {
                    player.setItemInUse(itemstack, this.getMaxItemUseDuration(itemstack));
                } else if (world.isRemote) {
                    player.setItemInUse(itemstack, this.getMaxItemUseDuration(itemstack));
                }
            } else {
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
            return !world.isRemote;
        }
        return super.onItemUseFirst(itemstack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    private boolean tryBindTaglockFromBed(ItemStack itemstack, EntityPlayer player, World world, ChunkCoordinates clickedBedLocation) {
        String boundName = "";
        EntityLivingBase boundEntity = this.getBoundEntity(world, (Entity)player, itemstack, 1);
        if (boundEntity != null && boundEntity instanceof EntityPlayer) {
            boundName = ((EntityPlayer)boundEntity).getCommandSenderName();
        }
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (Object obj : world.playerEntities) {
            EntityPlayer worldPlayer = (EntityPlayer)obj;
            ChunkCoordinates playerBedLocation = worldPlayer.getBedLocation(player.dimension);
            if (playerBedLocation == null || !playerBedLocation.equals((Object)clickedBedLocation)) continue;
            players.add(worldPlayer);
        }
        Collections.sort(players, new PlayerComparitor());
        boolean taglockSaved = false;
        if (players.size() > 0) {
            if (boundName.isEmpty()) {
                taglockSaved = this.setTaglockForEntity(world, player, itemstack, (EntityPlayer)players.get(0));
            } else {
                boolean found = false;
                for (int i = 0; i < players.size() && !found; ++i) {
                    if (!((EntityPlayer)players.get(i)).getCommandSenderName().equals(boundName)) continue;
                    taglockSaved = i == players.size() - 1 ? this.setTaglockForEntity(world, player, itemstack, (EntityPlayer)players.get(0)) : this.setTaglockForEntity(world, player, itemstack, (EntityPlayer)players.get(i + 1));
                    found = true;
                }
                if (!found) {
                    taglockSaved = this.setTaglockForEntity(world, player, itemstack, (EntityPlayer)players.get(0));
                }
            }
        }
        return taglockSaved;
    }

    public static boolean isTaglockRestricted(EntityPlayer collector, EntityLivingBase target) {
        if (!(target instanceof EntityPlayer) || collector.equals((Object)target)) {
            return false;
        }
        if (Config.instance().restrictTaglockCollectionOnNonPVPServers && !MinecraftServer.getServer().isPVPEnabled()) {
            return true;
        }
        EntityPlayer targetPlayer = (EntityPlayer)target;
        return Config.instance().restrictTaglockCollectionForStaffMembers && MinecraftServer.getServer().getConfigurationManager().func_152596_g(targetPlayer.getGameProfile());
    }

    private boolean setTaglockForEntity(World world, EntityPlayer player, ItemStack itemstack, EntityPlayer victim) {
        if (!ItemTaglockKit.isTaglockRestricted(player, (EntityLivingBase)victim)) {
            this.setTaglockForEntity(world, player, itemstack, victim.getCommandSenderName());
            return true;
        }
        return false;
    }

    private void setTaglockForEntity(World world, EntityPlayer player, ItemStack itemstack, String victimUsername) {
        if (!world.isRemote) {
            if (itemstack.stackSize > 1) {
                ItemStack newStack = new ItemStack((Item)this, 1, 1);
                this.setTaglockForEntity(newStack, player, victimUsername, true, (Integer)1);
                --itemstack.stackSize;
                if (itemstack.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
                if (!player.inventory.addItemStackToInventory(newStack)) {
                    world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX + 0.5, player.posY + 1.5, player.posZ + 0.5, newStack));
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
            } else {
                this.setTaglockForEntity(itemstack, player, victimUsername, true, (Integer)1);
                itemstack.setItemDamage(1);
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEntityInteract(World world, EntityPlayer player, ItemStack stack, EntityInteractEvent event) {
        if (world.isRemote || stack == null || stack.getItem() != Witchery.Items.TAGLOCK_KIT || event.target == null || !(event.target instanceof EntityLivingBase)) return;
        EntityLivingBase target = (EntityLivingBase)event.target;
        if (!(target instanceof EntityPlayer) || this.isSneakSuccessful(player, target)) {
            if (target instanceof EntityTreefyd || target instanceof EntityImp || target instanceof EntityWingedMonkey && !player.isSneaking()) return;
            if (stack.stackSize > 1) {
                ItemStack newStack = new ItemStack((Item)Witchery.Items.TAGLOCK_KIT, 1, 1);
                Witchery.Items.TAGLOCK_KIT.setTaglockForEntity(newStack, player, (Entity)target, true, (Integer)1);
                --stack.stackSize;
                if (stack.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
                if (!player.inventory.addItemStackToInventory(newStack)) {
                    world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX + 0.5, player.posY + 1.5, player.posZ + 0.5, newStack));
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
            } else {
                Witchery.Items.TAGLOCK_KIT.setTaglockForEntity(stack, player, (Entity)target, true, (Integer)1);
                stack.setItemDamage(1);
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
            }
        } else {
            ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)event.entityPlayer, "witchery.taglockkit.taglockfailed", new Object[0]);
            if (target instanceof EntityPlayer) {
                ChatUtil.sendTranslated(EnumChatFormatting.GREEN, (ICommandSender)((EntityPlayer)target), "witchery.taglockkit.taglockdiscovered", new Object[0]);
            }
        }
        event.setCanceled(true);
    }

    private boolean isSneakSuccessful(EntityPlayer sneaker, EntityLivingBase target) {
        double targetFacing;
        if (ItemTaglockKit.isTaglockRestricted(sneaker, target)) {
            return false;
        }
        double sneakerFacing = (sneaker.rotationYawHead + 90.0f) % 360.0f;
        if (sneakerFacing < 0.0) {
            sneakerFacing += 360.0;
        }
        if ((targetFacing = (double)((target.rotationYawHead + 90.0f) % 360.0f)) < 0.0) {
            targetFacing += 360.0;
        }
        double ARC = 45.0;
        double diff = Math.abs(targetFacing - sneakerFacing);
        double chance = 0.0;
        if (360.0 - diff % 360.0 < 45.0 || diff % 360.0 < 45.0) {
            chance = sneaker.isSneaking() ? 0.6 : 0.3;
        } else {
            double d = chance = sneaker.isSneaking() ? 0.1 : 0.01;
            if (sneaker.isInvisible()) {
                chance += 0.1;
            }
        }
        return sneaker.worldObj.rand.nextDouble() < chance;
    }

    public void setTaglockForEntity(ItemStack stack, EntityPlayer player, Entity entity, boolean playSoundAtPlayer, Integer index) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer hitPlayer = (EntityPlayer)entity;
            stack.getTagCompound().setString(KEY_PLAYER_NAME + index.toString(), hitPlayer.getCommandSenderName());
            stack.getTagCompound().removeTag(KEY_ENTITY_ID_MOST + index.toString());
            stack.getTagCompound().removeTag(KEY_ENTITY_ID_LEAST + index.toString());
        } else if (entity instanceof EntityLiving) {
            stack.getTagCompound().removeTag(KEY_PLAYER_NAME + index.toString());
            UUID id = entity.getPersistentID();
            ((EntityLiving)entity).func_110163_bv();
            stack.getTagCompound().setLong(KEY_ENTITY_ID_MOST + index.toString(), id.getMostSignificantBits());
            stack.getTagCompound().setLong(KEY_ENTITY_ID_LEAST + index.toString(), id.getLeastSignificantBits());
            stack.getTagCompound().setString(KEY_DISPLAY_NAME + index.toString(), entity.getCommandSenderName());
        } else {
            return;
        }
        if (playSoundAtPlayer) {
            player.worldObj.playSoundAtEntity((Entity)player, "random.orb", 0.5f, 0.4f / ((float)player.worldObj.rand.nextDouble() * 0.4f + 0.8f));
        }
    }

    public void clearTaglock(ItemStack stack, Integer index) {
        if (stack != null) {
            stack.getTagCompound().removeTag(KEY_ENTITY_ID_MOST + index.toString());
            stack.getTagCompound().removeTag(KEY_ENTITY_ID_LEAST + index.toString());
            stack.getTagCompound().removeTag(KEY_PLAYER_NAME + index.toString());
            stack.getTagCompound().removeTag(KEY_DISPLAY_NAME + index.toString());
        }
    }

    public void setTaglockForEntity(ItemStack stack, EntityPlayer player, String username, boolean playSoundAtPlayer, Integer index) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (username == null || username.isEmpty()) {
            return;
        }
        stack.getTagCompound().setString(KEY_PLAYER_NAME + index.toString(), username);
        stack.getTagCompound().removeTag(KEY_ENTITY_ID_MOST + index.toString());
        stack.getTagCompound().removeTag(KEY_ENTITY_ID_LEAST + index.toString());
        if (playSoundAtPlayer) {
            player.worldObj.playSoundAtEntity((Entity)player, "random.orb", 0.5f, 0.4f / ((float)player.worldObj.rand.nextDouble() * 0.4f + 0.8f));
        }
    }

    public boolean isTaglockPresent(ItemStack itemStack, Integer index) {
        if (itemStack.hasTagCompound()) {
            String playerName;
            if (itemStack.getTagCompound().hasKey(KEY_PLAYER_NAME + index.toString()) && (playerName = itemStack.getTagCompound().getString(KEY_PLAYER_NAME + index.toString())) != null && !playerName.isEmpty()) {
                return true;
            }
            if (itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + index.toString())) {
                return true;
            }
        }
        return false;
    }

    public String getBoundEntityDisplayName(ItemStack itemStack, Integer index) {
        if (itemStack.hasTagCompound()) {
            if (itemStack.getTagCompound().hasKey(KEY_PLAYER_NAME + index.toString())) {
                String playerName = itemStack.getTagCompound().getString(KEY_PLAYER_NAME + index.toString());
                return playerName;
            }
            if (itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_DISPLAY_NAME + index.toString())) {
                String displayName = itemStack.getTagCompound().getString(KEY_DISPLAY_NAME + index.toString());
                return displayName;
            }
        }
        return "";
    }

    public BoundType getBoundEntityType(ItemStack itemStack, Integer index) {
        if (itemStack.hasTagCompound()) {
            if (itemStack.getTagCompound().hasKey(KEY_PLAYER_NAME + index.toString())) {
                return BoundType.PLAYER;
            }
            if (itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_DISPLAY_NAME + index.toString())) {
                return BoundType.CREATURE;
            }
        }
        return BoundType.NONE;
    }

    public String getBoundUsername(ItemStack itemStack, Integer index) {
        if (itemStack.hasTagCompound() && itemStack.getTagCompound().hasKey(KEY_PLAYER_NAME + index.toString())) {
            String playerName = itemStack.getTagCompound().getString(KEY_PLAYER_NAME + index.toString());
            return playerName;
        }
        return "";
    }

    public UUID getBoundCreatureID(ItemStack itemStack, Integer index) {
        if (itemStack.hasTagCompound() && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_DISPLAY_NAME + index.toString())) {
            String displayName = itemStack.getTagCompound().getString(KEY_DISPLAY_NAME + index.toString());
            UUID entityID = new UUID(itemStack.getTagCompound().getLong(KEY_ENTITY_ID_MOST + index.toString()), itemStack.getTagCompound().getLong(KEY_ENTITY_ID_LEAST + index.toString()));
            return entityID;
        }
        return new UUID(0L, 0L);
    }

    public void addTagLockToPoppet(ItemStack stackTaglockKit, ItemStack stackPoppet, Integer index) {
        assert (stackTaglockKit != null) : "stack of taglock kit cannot be null";
        assert (stackPoppet != null) : "stack poppet cannot be null";
        Integer tagLockIndex = 1;
        if (!stackPoppet.hasTagCompound()) {
            stackPoppet.setTagCompound(new NBTTagCompound());
        }
        if (stackTaglockKit.hasTagCompound()) {
            if (stackTaglockKit.getTagCompound().hasKey(KEY_PLAYER_NAME + tagLockIndex.toString())) {
                String playerName = stackTaglockKit.getTagCompound().getString(KEY_PLAYER_NAME + tagLockIndex.toString());
                if (playerName != null) {
                    stackPoppet.getTagCompound().setString(KEY_PLAYER_NAME + index.toString(), playerName);
                }
            } else if (stackTaglockKit.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + tagLockIndex.toString()) && stackTaglockKit.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + tagLockIndex.toString()) && stackTaglockKit.getTagCompound().hasKey(KEY_DISPLAY_NAME + tagLockIndex.toString())) {
                stackPoppet.getTagCompound().setLong(KEY_ENTITY_ID_MOST + index.toString(), stackTaglockKit.getTagCompound().getLong(KEY_ENTITY_ID_MOST + tagLockIndex.toString()));
                stackPoppet.getTagCompound().setLong(KEY_ENTITY_ID_LEAST + index.toString(), stackTaglockKit.getTagCompound().getLong(KEY_ENTITY_ID_LEAST + tagLockIndex.toString()));
                stackPoppet.getTagCompound().setString(KEY_DISPLAY_NAME + index.toString(), stackTaglockKit.getTagCompound().getString(KEY_DISPLAY_NAME + tagLockIndex.toString()));
            }
        }
    }

    public boolean containsTaglockForEntity(ItemStack itemStack, Entity entity, Integer index) {
        if (itemStack.hasTagCompound()) {
            UUID entityID;
            if (entity instanceof EntityPlayer) {
                String playerName;
                EntityPlayer player = (EntityPlayer)entity;
                if (itemStack.getTagCompound().hasKey(KEY_PLAYER_NAME + index.toString()) && (playerName = itemStack.getTagCompound().getString(KEY_PLAYER_NAME + index.toString())) != null && playerName.equals(player.getCommandSenderName())) {
                    return true;
                }
            } else if (entity instanceof EntityLiving && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + index.toString()) && itemStack.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + index.toString()) && (entityID = new UUID(itemStack.getTagCompound().getLong(KEY_ENTITY_ID_MOST + index.toString()), itemStack.getTagCompound().getLong(KEY_ENTITY_ID_LEAST + index.toString()))).equals(entity.getPersistentID())) {
                return true;
            }
        }
        return false;
    }

    public EntityLivingBase getBoundEntity(World world, Entity entity, ItemStack stack, Integer index) {
        if (stack.hasTagCompound()) {
            String playerName;
            if (stack.getTagCompound().hasKey(KEY_PLAYER_NAME + index.toString()) && (playerName = stack.getTagCompound().getString(KEY_PLAYER_NAME + index.toString())) != null && !playerName.isEmpty()) {
                if (!world.isRemote) {
                    MinecraftServer server = MinecraftServer.getServer();
                    for (WorldServer worldServer : server.worldServers) {
                        for (Object obj : worldServer.playerEntities) {
                            EntityPlayer player = (EntityPlayer)obj;
                            if (!player.getCommandSenderName().equalsIgnoreCase(playerName)) continue;
                            return player;
                        }
                    }
                } else {
                    for (Object obj : world.playerEntities) {
                        EntityPlayer player = (EntityPlayer)obj;
                        if (!player.getCommandSenderName().equalsIgnoreCase(playerName)) continue;
                        return player;
                    }
                }
                return null;
            }
            if (stack.getTagCompound().hasKey(KEY_ENTITY_ID_MOST + index.toString()) && stack.getTagCompound().hasKey(KEY_ENTITY_ID_LEAST + index.toString())) {
                UUID entityID = new UUID(stack.getTagCompound().getLong(KEY_ENTITY_ID_MOST + index.toString()), stack.getTagCompound().getLong(KEY_ENTITY_ID_LEAST + index.toString()));
                if (!world.isRemote) {
                    MinecraftServer server = MinecraftServer.getServer();
                    for (WorldServer worldServer : server.worldServers) {
                        for (Object obj : worldServer.loadedEntityList) {
                            EntityLivingBase living;
                            UUID livingID;
                            if (!(obj instanceof EntityLivingBase) || !entityID.equals(livingID = (living = (EntityLivingBase)obj).getPersistentID()) || !living.isEntityAlive()) continue;
                            return living;
                        }
                    }
                } else {
                    for (Object obj : world.loadedEntityList) {
                        EntityLivingBase living;
                        UUID livingID;
                        if (!(obj instanceof EntityLivingBase) || !entityID.equals(livingID = (living = (EntityLivingBase)obj).getPersistentID()) || !living.isEntityAlive()) continue;
                        return living;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static enum BoundType {
        NONE,
        PLAYER,
        CREATURE;

    }

    public static class PlayerComparitor
    implements Comparator<EntityPlayer> {
        @Override
        public int compare(EntityPlayer p1, EntityPlayer p2) {
            return p1.getCommandSenderName().compareTo(p2.getCommandSenderName());
        }
    }
}

