/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityGrenade;
import com.emoniph.witchery.item.ItemBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemSunGrenade
extends ItemBase {
    private final int mode;
    @SideOnly(value=Side.CLIENT)
    protected IIcon itemIconOverlay;

    public ItemSunGrenade(int mode) {
        this.mode = mode;
        this.setMaxStackSize(16);
        this.setMaxDamage(0);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean moreTips) {
        super.addInformation(stack, player, list, moreTips);
        if (this.mode == 1) {
            list.add(String.format(Witchery.resource("item.witchery:dupgrenade.tip"), ItemSunGrenade.getOwnerName(stack)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.itemIconOverlay;
        }
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        super.registerIcons(iconRegister);
        this.itemIconOverlay = iconRegister.registerIcon("witchery:ingredient.quartzSphere");
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isRemote) {
            EntityGrenade grenade = new EntityGrenade(world, (EntityLivingBase)player, stack);
            grenade.setMode(this.mode);
            if (this.mode == 1) {
                grenade.setOwner(ItemSunGrenade.getOwnerName(stack));
            }
            world.spawnEntityInWorld((Entity)grenade);
        }
        return stack;
    }

    public static String getOwnerName(ItemStack stack) {
        if (stack.hasTagCompound()) {
            NBTTagCompound nbtRoot = stack.getTagCompound();
            return nbtRoot.getString("Owner");
        }
        return null;
    }

    public static void setOwnerName(ItemStack stack, String name) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        nbtRoot.setString("Owner", name);
    }
}

