/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.entity.EntityParasyticLouse;
import com.emoniph.witchery.item.ItemBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemParasyticLouse
extends ItemBase {
    public ItemParasyticLouse() {
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
    }

    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        Entity entity;
        if (par3World.isRemote) {
            return true;
        }
        Block i1 = par3World.getBlock(par4, par5, par6);
        par4 += Facing.offsetsXForSide[par7];
        par5 += Facing.offsetsYForSide[par7];
        par6 += Facing.offsetsZForSide[par7];
        double d0 = 0.0;
        if (par7 == 1 && i1.getRenderType() == 11) {
            d0 = 0.5;
        }
        if ((entity = this.spawnCreature(par1ItemStack, par3World, (double)par4 + 0.5, (double)par5 + d0, (double)par6 + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && par1ItemStack.hasDisplayName()) {
                ((EntityLiving)entity).setCustomNameTag(par1ItemStack.getDisplayName());
            }
            if (!par2EntityPlayer.capabilities.isCreativeMode) {
                --par1ItemStack.stackSize;
            }
        }
        return true;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return super.getItemStackDisplayName(stack);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        List effects = Items.potionitem.getEffects(stack.getItemDamage());
        if (effects != null && !effects.isEmpty()) {
            PotionEffect effect = (PotionEffect)effects.get(0);
            String s1 = effect.getEffectName();
            s1 = s1 + ".postfix";
            String s2 = "\u00a76" + StatCollector.translateToLocal((String)s1).trim() + "\u00a7r";
            if (effect.getAmplifier() > 0) {
                s2 = s2 + " " + StatCollector.translateToLocal((String)("potion.potency." + effect.getAmplifier())).trim();
            }
            if (effect.getDuration() > 20) {
                s2 = s2 + " [" + Potion.getDurationString((PotionEffect)effect) + "]";
            }
            list.add(s2);
        }
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par2World.isRemote) {
            return par1ItemStack;
        }
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(par2World, par3EntityPlayer, true);
        if (movingobjectposition == null) {
            return par1ItemStack;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!par2World.canMineBlock(par3EntityPlayer, i, j, k)) {
                return par1ItemStack;
            }
            if (!par3EntityPlayer.canPlayerEdit(i, j, k, movingobjectposition.sideHit, par1ItemStack)) {
                return par1ItemStack;
            }
            if (par2World.getBlock(i, j, k).getMaterial() == Material.water && (entity = this.spawnCreature(par1ItemStack, par2World, i, j, k)) != null) {
                if (entity instanceof EntityLivingBase && par1ItemStack.hasDisplayName()) {
                    ((EntityLiving)entity).setCustomNameTag(par1ItemStack.getDisplayName());
                }
                if (!par3EntityPlayer.capabilities.isCreativeMode) {
                    --par1ItemStack.stackSize;
                }
            }
        }
        return par1ItemStack;
    }

    private Entity spawnCreature(ItemStack stack, World par0World, double par2, double par4, double par6) {
        EntityParasyticLouse entity = new EntityParasyticLouse(par0World);
        int damage = stack.getItemDamage();
        if (damage > 0) {
            entity.setBitePotionEffect(damage);
        }
        if (entity != null && entity instanceof EntityLivingBase) {
            EntityParasyticLouse entityliving = entity;
            entity.setLocationAndAngles(par2, par4, par6, MathHelper.wrapAngleTo180_float((float)(par0World.rand.nextFloat() * 360.0f)), 0.0f);
            entity.func_110163_bv();
            ((EntityLiving)entityliving).rotationYawHead = ((EntityLiving)entityliving).rotationYaw;
            ((EntityLiving)entityliving).renderYawOffset = ((EntityLiving)entityliving).rotationYaw;
            entityliving.onSpawnWithEgg(null);
            par0World.spawnEntityInWorld((Entity)entity);
            entityliving.playLivingSound();
        }
        return entity;
    }
}

