/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityBolt;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.item.ItemHunterClothes;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.InvUtil;
import com.emoniph.witchery.util.ItemUtil;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import com.emoniph.witchery.util.TransformCreature;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemHandBow
extends ItemBow {
    private static final int TICKS_TO_LOAD = 10;
    private static final String BOLT_TYPE_CURRENT = "WITCBoltTypeCurrent";
    private static final String BOLT_TYPE_PREFERRED = "WITCBoltTypePreferred";
    private static ItemGeneral.SubItem[] BOLT_TYPES = null;

    public ItemHandBow() {
        this.setMaxDamage(768);
        this.setFull3D();
        this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
    }

    public Item setUnlocalizedName(String itemName) {
        ItemUtil.registerItem((Item)this, itemName);
        return super.setUnlocalizedName(itemName);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        ItemGeneral.SubItem loadedBoltType = ItemHandBow.getBoltType(BOLT_TYPE_CURRENT, stack);
        ExtendedPlayer playerEx = ExtendedPlayer.get(player);
        if ((loadedBoltType != null || player.isSneaking()) && playerEx.getCreatureType() == TransformCreature.NONE) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int boltTypesCount;
        int elapsed = this.getMaxItemUseDuration(stack) - count;
        ItemGeneral.SubItem loadedBoltType = ItemHandBow.getBoltType(BOLT_TYPE_CURRENT, stack);
        if (player.isSneaking() && (elapsed == 5 || elapsed == 10 || elapsed == 15) && (boltTypesCount = this.getBoltTypesInInventory((IInventory)player.inventory, loadedBoltType)) > 0) {
            SoundEffect.WITCHERY_RANDOM_CLICK.playOnlyTo(player, 1.0f, 1.0f);
        }
        super.onUsingTick(stack, player, count);
    }

    private int getBoltTypesInInventory(IInventory inventory, ItemGeneral.SubItem typeToIgnore) {
        HashSet<ItemGeneral.BoltType> typesFound = new HashSet<ItemGeneral.BoltType>();
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            ItemGeneral.BoltType boltType = ItemGeneral.BoltType.getBolt(stack);
            if (boltType == null || boltType == typeToIgnore) continue;
            typesFound.add(boltType);
        }
        return typesFound.size();
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int count) {
        int elapsed = this.getMaxItemUseDuration(stack) - count;
        ItemGeneral.SubItem loadedBoltType = ItemHandBow.getBoltType(BOLT_TYPE_CURRENT, stack);
        if (!(loadedBoltType == null || player.isSneaking() && elapsed >= 10)) {
            if (this.launchBolt(stack, world, player, elapsed >= TimeUtil.secsToTicks(1) ? 20 : 19)) {
                this.setBoltType(BOLT_TYPE_CURRENT, stack, null);
            }
        } else if (player.isSneaking() && elapsed >= 10) {
            int boltTypesCount = this.getBoltTypesInInventory((IInventory)player.inventory, loadedBoltType);
            if (loadedBoltType != null && boltTypesCount > 0) {
                ItemGeneral.SubItem boltTypeToUse = this.getNextBoltType(loadedBoltType);
                if (!InvUtil.hasItem(player.inventory, Witchery.Items.GENERIC, boltTypeToUse.damageValue)) {
                    boltTypeToUse = null;
                    ItemGeneral.SubItem currentBoltType = loadedBoltType;
                    while ((currentBoltType = this.getNextBoltType(currentBoltType)) != loadedBoltType) {
                        if (!InvUtil.hasItem(player.inventory, Witchery.Items.GENERIC, currentBoltType.damageValue)) continue;
                        boltTypeToUse = currentBoltType;
                        break;
                    }
                }
                if (boltTypeToUse != null) {
                    this.setBoltType(BOLT_TYPE_CURRENT, stack, boltTypeToUse);
                    this.setBoltType(BOLT_TYPE_PREFERRED, stack, boltTypeToUse);
                    SoundEffect.WITCHERY_RANDOM_WINDUP.playOnlyTo(player, 1.0f, 1.0f);
                    if (!player.capabilities.isCreativeMode) {
                        InvUtil.consumeItem(player.inventory, Witchery.Items.GENERIC, boltTypeToUse.damageValue);
                        ItemStack unloadedBolt = loadedBoltType.createStack();
                        if (!player.inventory.addItemStackToInventory(unloadedBolt)) {
                            EntityUtil.spawnEntityInWorld(world, (Entity)new EntityItem(world, player.posX, player.posY, player.posZ, unloadedBolt));
                        }
                    }
                }
            } else if (loadedBoltType == null && boltTypesCount > 0) {
                ItemGeneral.SubItem preferredBoltType = ItemHandBow.getBoltType(BOLT_TYPE_PREFERRED, stack);
                if (preferredBoltType == null) {
                    preferredBoltType = Witchery.Items.GENERIC.itemBoltStake;
                }
                ItemGeneral.SubItem boltTypeToUse = preferredBoltType;
                if (!InvUtil.hasItem(player.inventory, Witchery.Items.GENERIC, boltTypeToUse.damageValue)) {
                    boltTypeToUse = null;
                    ItemGeneral.SubItem currentBoltType = preferredBoltType;
                    while ((currentBoltType = this.getNextBoltType(currentBoltType)) != preferredBoltType) {
                        if (!InvUtil.hasItem(player.inventory, Witchery.Items.GENERIC, currentBoltType.damageValue)) continue;
                        boltTypeToUse = currentBoltType;
                        break;
                    }
                }
                if (boltTypeToUse != null) {
                    SoundEffect.WITCHERY_RANDOM_WINDUP.playOnlyTo(player, 1.0f, 1.0f);
                    this.setBoltType(BOLT_TYPE_CURRENT, stack, boltTypeToUse);
                    if (!player.capabilities.isCreativeMode) {
                        InvUtil.consumeItem(player.inventory, Witchery.Items.GENERIC, boltTypeToUse.damageValue);
                    }
                }
            }
        }
    }

    private boolean launchBolt(ItemStack stack, World world, EntityPlayer player, int ticks) {
        boolean isInfinite = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)stack) > 0 && world.rand.nextDouble() < 0.25;
        ItemGeneral.SubItem boltType = ItemHandBow.getBoltType(BOLT_TYPE_CURRENT, stack);
        if (boltType != null) {
            float f = (float)ticks / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return true;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            int boltID = 0;
            int boltCount = 1;
            float arcStart = 0.0f;
            float arcInc = 0.0f;
            float damage = 2.0f;
            if (boltType == Witchery.Items.GENERIC.itemBoltSilver) {
                boltID = 4;
            } else if (boltType == Witchery.Items.GENERIC.itemBoltHoly) {
                boltID = 3;
            } else if (boltType == Witchery.Items.GENERIC.itemBoltAntiMagic) {
                if (ItemHunterClothes.isFullSetWorn((EntityLivingBase)player, false)) {
                    boltID = 2;
                    Witchery.modHooks.reducePowerLevels((EntityLivingBase)player, 1.0f);
                } else {
                    boltID = 1;
                }
            } else if (boltType == Witchery.Items.GENERIC.itemBoltSplitting) {
                boltCount = 3;
                arcStart = -20.0f;
                arcInc = 20.0f;
                damage = 1.0f;
            }
            for (int i = 0; i < boltCount; ++i) {
                EntityBolt bolt = new EntityBolt(world, (EntityLivingBase)player, f * 2.0f, arcStart + (float)i * arcInc);
                bolt.setShooter((EntityLivingBase)player);
                bolt.setBoltType(boltID);
                bolt.setDamage(damage);
                int n = bolt.canBePickedUp = isInfinite || player.capabilities.isCreativeMode ? 0 : 1;
                if (f == 1.0f) {
                    bolt.setIsCritical(true);
                }
                if (boltType != Witchery.Items.GENERIC.itemBoltAntiMagic) {
                    int knockbackBonus;
                    int powerBonus = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)stack);
                    if (powerBonus > 0) {
                        bolt.setDamage(bolt.getDamage() + (double)powerBonus * 0.5 + 0.5);
                    }
                    if ((knockbackBonus = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)stack)) > 0) {
                        bolt.setKnockbackStrength(knockbackBonus);
                    }
                    if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)stack) > 0) {
                        bolt.setFire(100);
                    }
                }
                EntityUtil.spawnEntityInWorld(world, bolt);
                EntityUtil.correctProjectileTrackerSync(world, bolt);
            }
            stack.damageItem(2, (EntityLivingBase)player);
            world.playSoundAtEntity((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (isInfinite && !world.isRemote) {
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                }
                return false;
            }
        }
        return true;
    }

    public ItemStack onEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int getItemEnchantability() {
        return 1;
    }

    public static ItemGeneral.BoltType getLoadedBoltType(ItemStack stack) {
        ItemGeneral.SubItem boltType = ItemHandBow.getBoltType(BOLT_TYPE_CURRENT, stack);
        if (boltType != null) {
            return (ItemGeneral.BoltType)boltType;
        }
        return null;
    }

    private static ItemGeneral.SubItem getBoltType(String key, ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return null;
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        int boltID = nbtRoot.getInteger(key);
        return ItemHandBow.intToBoltType(boltID);
    }

    private void setBoltType(String key, ItemStack stack, ItemGeneral.SubItem boltType) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        int boltID = this.boltTypeToInt(boltType);
        nbtRoot.setInteger(key, boltID);
    }

    private static ItemGeneral.SubItem[] getBoltTypes() {
        if (BOLT_TYPES == null) {
            BOLT_TYPES = new ItemGeneral.SubItem[]{Witchery.Items.GENERIC.itemBoltStake, Witchery.Items.GENERIC.itemBoltAntiMagic, Witchery.Items.GENERIC.itemBoltHoly, Witchery.Items.GENERIC.itemBoltSplitting, Witchery.Items.GENERIC.itemBoltSilver};
        }
        return BOLT_TYPES;
    }

    private static ItemGeneral.SubItem intToBoltType(int boltID) {
        if (boltID > 0 && boltID <= ItemHandBow.getBoltTypes().length) {
            return BOLT_TYPES[boltID - 1];
        }
        return null;
    }

    private int boltTypeToInt(ItemGeneral.SubItem boltType) {
        for (int i = 0; i < ItemHandBow.getBoltTypes().length; ++i) {
            if (ItemHandBow.getBoltTypes()[i] != boltType) continue;
            return i + 1;
        }
        return 0;
    }

    private ItemGeneral.SubItem getNextBoltType(ItemGeneral.SubItem boltType) {
        return ItemHandBow.intToBoltType(this.getNextBoltTypeID(this.boltTypeToInt(boltType)));
    }

    private int getNextBoltTypeID(int boltID) {
        if (++boltID > ItemHandBow.getBoltTypes().length) {
            boltID = 1;
        }
        return boltID;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon(this.getIconString());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int par1) {
        return this.itemIcon;
    }
}

