/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.item.ItemBase;
import com.emoniph.witchery.util.Config;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemEntityLocator
extends ItemBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemEntityLocator() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[33];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon(this.getIconString() + i);
        }
        this.itemIcon = this.icons[0];
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advTooltips) {
        super.addInformation(stack, player, list, advTooltips);
        String entityID = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 1);
        if (entityID != null && !entityID.isEmpty()) {
            list.add(String.format(Witchery.resource("item.witcheryTaglockKit.boundto"), entityID));
        } else {
            list.add(Witchery.resource("item.witcheryTaglockKit.unbound"));
        }
    }

    public IIcon getIconFromDamage(int damageValue) {
        if (damageValue > 0 && damageValue < this.icons.length) {
            return this.icons[damageValue];
        }
        return this.icons[0];
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        item.setItemDamage(0);
        return super.onDroppedByPlayer(item, player);
    }

    public void onUpdate(ItemStack stack, World world, Entity player, int inventorySlot, boolean isHeldItem) {
        if (world != null && world.isRemote && world.getWorldTime() % 10L == 2L) {
            if (Witchery.Items.TAGLOCK_KIT.isTaglockPresent(stack, 1)) {
                double d3 = 0.0;
                EntityLivingBase target = Witchery.Items.TAGLOCK_KIT.getBoundEntity(world, null, stack, 1);
                if (target != null && (target.dimension == player.dimension || target.dimension == 0 && player.dimension == Config.instance().dimensionDreamID)) {
                    double playerX = player.posX;
                    double playerZ = player.posZ;
                    double d4 = target.posX - playerX;
                    double d5 = target.posZ - playerZ;
                    double playerYaw = player.rotationYaw;
                    d3 = -(((playerYaw %= 360.0) - 90.0) * Math.PI / 180.0 - Math.atan2(d5, d4));
                } else {
                    d3 = Math.random() * Math.PI * 2.0;
                }
                int SIZE = this.icons.length - 1;
                int i = (int)((d3 / (Math.PI * 2) + 1.0) * (double)SIZE) % SIZE;
                while (i < 0) {
                    i = (i + SIZE) % SIZE;
                }
                stack.setItemDamage(i + 1);
            } else {
                stack.setItemDamage(0);
            }
        }
    }
}

