/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.item.ItemBase;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBrewEndlessWater
extends ItemBase {
    @SideOnly(value=Side.CLIENT)
    protected IIcon itemIconOverlay;

    public ItemBrewEndlessWater() {
        this.setMaxStackSize(1);
        this.setMaxDamage(99);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.itemIconOverlay;
        }
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        super.registerIcons(iconRegister);
        this.itemIconOverlay = iconRegister.registerIcon("witchery:brew_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (pass == 0) {
            int color = 255;
            return 255;
        }
        return super.getColorFromItemStack(stack, pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean expanded) {
        String localText = String.format(Witchery.resource("item.witchery:brew.water.tip"), Integer.valueOf(stack.getMaxDamage() - stack.getItemDamage() + 1).toString(), Integer.valueOf(stack.getMaxDamage() + 1).toString());
        if (localText != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote && stack.getItemDamage() <= stack.getMaxDamage()) {
            Block block = world.getBlock(x, y, z);
            if (block == Blocks.cauldron) {
                int meta = world.getBlockMetadata(x, y, z);
                if (meta < 3) {
                    stack.damageItem(1, (EntityLivingBase)player);
                    Blocks.cauldron.func_150024_a(world, x, y, z, 3);
                    SoundEffect.WATER_SPLASH.playAtPlayer(world, player);
                }
            } else {
                ForgeDirection face = ForgeDirection.getOrientation((int)side);
                if (block != null && BlockUtil.isReplaceableBlock(world, x += face.offsetX, y += face.offsetY, z += face.offsetZ, (EntityLivingBase)player)) {
                    stack.damageItem(1, (EntityLivingBase)player);
                    world.setBlock(x, y, z, (Block)Blocks.flowing_water);
                    world.markBlockForUpdate(x, y, z);
                    SoundEffect.WATER_SPLASH.playAtPlayer(world, player);
                }
            }
        }
        return false;
    }
}

