/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.EntityBrew;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.StrokeSet;
import com.emoniph.witchery.item.ItemBase;
import com.emoniph.witchery.network.PacketBrewPrepared;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Dye;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemBrewBag
extends ItemBase {
    private static final float THRESHOLD_ORTHOGONAL = 7.0f;
    private static final float THRESHOLD_DIAGONAL = 3.5f;

    public ItemBrewBag() {
        this.setMaxStackSize(1);
        this.setFull3D();
    }

    public int getColorFromItemStack(ItemStack stack, int parse) {
        return ItemBrewBag.getColor(stack);
    }

    public static void setColor(ItemStack stack, Dye color) {
        ItemBrewBag.setColor(stack, color.rgb);
    }

    public static void setColor(ItemStack stack, int rgb) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        nbtRoot.setInteger("WITCColor", rgb);
    }

    public static int getColor(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (stack.hasTagCompound() && (nbtRoot = stack.getTagCompound()).hasKey("WITCColor")) {
            return nbtRoot.getInteger("WITCColor");
        }
        return Dye.COCOA_BEANS.rgb;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 36000;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!player.isSneaking()) {
            NBTTagCompound nbtTag = player.getEntityData();
            nbtTag.setByteArray("Strokes", new byte[0]);
            nbtTag.setFloat("startPitch", player.rotationPitch);
            nbtTag.setFloat("startYaw", player.rotationYawHead);
            nbtTag.removeTag("WITCLastBrewIndex");
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        } else if (!world.isRemote && player.isSneaking()) {
            player.openGui((Object)Witchery.instance, 5, world, 0, 0, 0);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int countdown) {
        NBTTagCompound nbtTag;
        if (player.worldObj.isRemote) {
            NBTTagCompound nbtTag2 = player.getEntityData();
            if (nbtTag2 == null) {
                return;
            }
            if (player.isSneaking()) {
                nbtTag2.removeTag("Strokes");
                nbtTag2.setFloat("startPitch", player.rotationPitch);
                nbtTag2.setFloat("startYaw", player.rotationYawHead);
                return;
            }
            float yawDiff = nbtTag2.getFloat("startYaw") - player.rotationYawHead;
            float pitchDiff = nbtTag2.getFloat("startPitch") - player.rotationPitch;
            byte[] oldStrokes = nbtTag2.getByteArray("Strokes");
            byte[] strokes = oldStrokes;
            int strokesStart = strokes.length;
            if (strokesStart == 0) {
                if (pitchDiff >= 3.5f && yawDiff <= -3.5f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)4);
                } else if (pitchDiff >= 3.5f && yawDiff >= 3.5f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)6);
                } else if (pitchDiff <= -3.5f && yawDiff <= -3.5f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)7);
                } else if (pitchDiff <= -3.5f && yawDiff >= 3.5f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)5);
                } else if (pitchDiff >= 7.0f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)0);
                } else if (pitchDiff <= -7.0f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)1);
                } else if (yawDiff <= -7.0f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)2);
                } else if (yawDiff >= 7.0f) {
                    strokes = this.addNewStroke(nbtTag2, strokes, (byte)3);
                }
                if (strokes.length > strokesStart) {
                    nbtTag2.setFloat("startPitch", player.rotationPitch);
                    nbtTag2.setFloat("startYaw", player.rotationYawHead);
                }
                if (oldStrokes != strokes && strokes.length > 0) {
                    InventoryBrewBag inv = new InventoryBrewBag(player);
                    int brewIndex = StrokeSet.Stroke.STROKE_TO_INDEX[strokes[0]];
                    ItemStack brew = inv.getStackInSlot(brewIndex);
                    if (brew != null) {
                        Witchery.packetPipeline.sendToServer(new PacketBrewPrepared(brewIndex));
                    } else {
                        nbtTag2.removeTag("Strokes");
                    }
                }
            }
        } else if (player.isSneaking() && (nbtTag = player.getEntityData()).hasKey("WITCLastBrewIndex")) {
            nbtTag.removeTag("WITCLastBrewIndex");
        }
    }

    public byte[] addNewStroke(NBTTagCompound nbtTag, byte[] strokes, byte stroke) {
        byte[] newStrokes = new byte[1];
        newStrokes[newStrokes.length - 1] = stroke;
        nbtTag.setByteArray("Strokes", newStrokes);
        return newStrokes;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int countdown) {
        NBTTagCompound nbtTag = player.getEntityData();
        if (nbtTag != null) {
            if (!world.isRemote && nbtTag.hasKey("WITCLastBrewIndex")) {
                int brewIndex = nbtTag.getInteger("WITCLastBrewIndex");
                nbtTag.removeTag("WITCLastBrewIndex");
                if (!player.isSneaking()) {
                    if (brewIndex > -1) {
                        InventoryBrewBag inv = new InventoryBrewBag(player);
                        ItemStack brew = inv.getStackInSlot(brewIndex);
                        if (brew != null) {
                            if (brew.getItem() == Witchery.Items.BREW) {
                                if (!player.capabilities.isCreativeMode) {
                                    --brew.stackSize;
                                }
                                world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
                                if (!world.isRemote) {
                                    world.spawnEntityInWorld((Entity)new EntityBrew(world, (EntityLivingBase)player, brew, false));
                                }
                            } else {
                                Witchery.Items.GENERIC.throwBrew(brew, world, player);
                            }
                            if (brew.stackSize == 0) {
                                inv.setInventorySlotContents(brewIndex, null);
                            }
                            inv.writeToNBT();
                        }
                    } else {
                        ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.infuse.branch.unknownsymbol", new Object[0]);
                        SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
                    }
                }
            } else {
                nbtTag.removeTag("Strokes");
                nbtTag.removeTag("startYaw");
                nbtTag.removeTag("startPitch");
            }
        }
    }

    private static class SlotBrewBag
    extends Slot {
        public SlotBrewBag(IInventory inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        public boolean isItemValid(ItemStack stack) {
            return SlotBrewBag.isBrew(stack);
        }

        public static boolean isBrew(ItemStack stack) {
            return stack != null && (Witchery.Items.GENERIC.isBrew(stack) || Witchery.Items.BREW == stack.getItem() && WitcheryBrewRegistry.INSTANCE.isSplash(stack.getTagCompound()));
        }
    }

    public static class ContainerBrewBag
    extends Container {
        private int numRows;
        private ItemStack bag;

        public ContainerBrewBag(IInventory playerInventory, IInventory bagInventory, ItemStack bag) {
            int col;
            int row;
            this.numRows = bagInventory.getSizeInventory() / 8;
            bagInventory.openInventory();
            int offset = (this.numRows - 4) * 18;
            for (row = 0; row < this.numRows; ++row) {
                for (col = 0; col < 8; ++col) {
                    this.addSlotToContainer(new SlotBrewBag(bagInventory, col + row * 8, 16 + col * 18, 18 + row * 18));
                }
            }
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 9; ++col) {
                    this.addSlotToContainer(new Slot(playerInventory, col + row * 9 + 9, 8 + col * 18, 103 + row * 18 + offset));
                }
            }
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlotToContainer(new Slot(playerInventory, col2, 8 + col2 * 18, 161 + offset));
            }
            this.bag = bag;
        }

        public boolean canInteractWith(EntityPlayer player) {
            ItemStack itemStack = null;
            if (player.getCurrentEquippedItem() != null) {
                itemStack = player.getCurrentEquippedItem();
            }
            return itemStack != null && itemStack.getItem() == Witchery.Items.BREW_BAG;
        }

        public ItemStack transferStackInSlot(EntityPlayer player, int index) {
            ItemStack returnStack = null;
            Slot slot = (Slot)this.inventorySlots.get(index);
            if (slot != null && slot.getHasStack()) {
                ItemStack itemStack = slot.getStack();
                if (!SlotBrewBag.isBrew(itemStack)) {
                    return returnStack;
                }
                returnStack = itemStack.copy();
                if (index < this.numRows * 9 ? !this.mergeItemStack(itemStack, this.numRows * 9, this.inventorySlots.size(), true) : !this.mergeItemStack(itemStack, 0, this.numRows * 9, false)) {
                    return null;
                }
                if (itemStack.stackSize == 0) {
                    slot.putStack((ItemStack)null);
                } else {
                    slot.onSlotChanged();
                }
            }
            return returnStack;
        }
    }

    public static class InventoryBrewBag
    extends InventoryBasic {
        protected String title;
        protected EntityPlayer player;
        protected boolean locked = false;

        public InventoryBrewBag(EntityPlayer player) {
            super("", false, 8);
            this.player = player;
            if (!this.hasInventory()) {
                this.createInventory();
            }
            this.readFromNBT();
        }

        public void markDirty() {
            super.markDirty();
            if (!this.locked) {
                this.writeToNBT();
            }
        }

        public void openInventory() {
            this.readFromNBT();
        }

        public void closeInventory() {
            this.writeToNBT();
        }

        public String getInventoryName() {
            return this.title;
        }

        protected boolean hasInventory() {
            ItemStack bag = this.player.getHeldItem();
            return bag != null && bag.hasTagCompound() && bag.getTagCompound().hasKey("Inventory");
        }

        protected void createInventory() {
            ItemStack bag = this.player.getHeldItem();
            this.title = new String(bag.getDisplayName());
            this.writeToNBT();
        }

        protected void writeToNBT() {
            ItemStack bag = this.player.getHeldItem();
            if (bag == null || bag.getItem() != Witchery.Items.BREW_BAG) {
                return;
            }
            if (!bag.hasTagCompound()) {
                bag.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = bag.getTagCompound();
            NBTTagCompound name = new NBTTagCompound();
            name.setString("Name", this.getInventoryName());
            nbtRoot.setTag("display", (NBTBase)name);
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.getSizeInventory(); ++i) {
                if (this.getStackInSlot(i) == null) continue;
                NBTTagCompound slotEntry = new NBTTagCompound();
                slotEntry.setByte("Slot", (byte)i);
                this.getStackInSlot(i).writeToNBT(slotEntry);
                itemList.appendTag((NBTBase)slotEntry);
            }
            NBTTagCompound inventory = new NBTTagCompound();
            inventory.setTag("Items", (NBTBase)itemList);
            nbtRoot.setTag("Inventory", (NBTBase)inventory);
        }

        protected void readFromNBT() {
            this.locked = true;
            ItemStack bag = this.player.getHeldItem();
            if (bag != null && bag.getItem() == Witchery.Items.BREW_BAG && bag.hasTagCompound()) {
                NBTTagCompound nbtRoot = bag.getTagCompound();
                this.title = nbtRoot.getCompoundTag("display").getString("Name");
                NBTTagList itemList = nbtRoot.getCompoundTag("Inventory").getTagList("Items", 10);
                for (int i = 0; i < itemList.tagCount(); ++i) {
                    NBTTagCompound slotEntry = itemList.getCompoundTagAt(i);
                    int j = slotEntry.getByte("Slot") & 0xFF;
                    if (j < 0 || j >= this.getSizeInventory()) continue;
                    this.setInventorySlotContents(j, ItemStack.loadItemStackFromNBT((NBTTagCompound)slotEntry));
                }
            }
            this.locked = false;
        }
    }
}

