/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.item.ItemBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class ItemBook
extends ItemBase {
    static final String CURRENT_PAGE_KEY = "CurrentPage";
    public static final BiomeDictionary.Type[] BIOME_TYPES = new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL};

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        int posX = MathHelper.floor_double((double)player.posX);
        int posY = MathHelper.floor_double((double)player.posY);
        int posZ = MathHelper.floor_double((double)player.posZ);
        player.openGui((Object)Witchery.instance, 6, world, posX, posY, posZ);
        return stack;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean expandedTooltip) {
        list.add(String.format(Witchery.resource("witchery.biomebook.currentpage"), ItemBook.getSelectedBiome((int)ItemBook.getSelectedBiome((ItemStack)stack, (int)1000)).biomeName));
        list.add("");
        for (String s : Witchery.resource("item.witchery:biomebook2.tip").split("\n")) {
            if (s.isEmpty()) continue;
            list.add(s);
        }
    }

    public static int getSelectedBiome(ItemStack stack, int maxPages) {
        NBTTagCompound stackCompound = stack.getTagCompound();
        if (stackCompound != null && stackCompound.hasKey(CURRENT_PAGE_KEY)) {
            return Math.min(Math.max(stackCompound.getInteger(CURRENT_PAGE_KEY), 0), Math.max(maxPages, 1) - 1);
        }
        return 0;
    }

    public static BiomeGenBase getSelectedBiome(int page) {
        ArrayList biomes = new ArrayList();
        int i = 0;
        for (BiomeDictionary.Type biomeType : BIOME_TYPES) {
            BiomeGenBase[] biomesInType = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType);
            for (int j = 0; j < biomesInType.length; ++j) {
                if (i++ != page) continue;
                return biomesInType[j];
            }
        }
        return BiomeGenBase.plains;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!this.hasContainerItem(stack)) {
            return null;
        }
        return stack.copy();
    }

    public static void setSelectedBiome(ItemStack itemstack, int pageIndex) {
        if (itemstack.getTagCompound() == null) {
            itemstack.setTagCompound(new NBTTagCompound());
        }
        itemstack.getTagCompound().setInteger(CURRENT_PAGE_KEY, pageIndex);
    }
}

