/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.item;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ItemUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ItemBoline
extends ItemSword {
    public static final Block[] blocksEffectiveAgainst = new Block[]{Blocks.planks, Blocks.bookshelf, Blocks.planks, Blocks.chest, Blocks.stone_slab, Blocks.pumpkin, Blocks.lit_pumpkin};
    private float effectiveWeaponDamage = 4.0f + Item.ToolMaterial.WOOD.getDamageVsEntity();

    public ItemBoline() {
        super(Item.ToolMaterial.IRON);
        this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
    }

    public Item setUnlocalizedName(String itemName) {
        ItemUtil.registerItem((Item)this, itemName);
        return super.setUnlocalizedName(itemName);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean moreTips) {
        String localText = Witchery.resource("item.witchery:boline.tip");
        if (localText != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
    }

    public Multimap getItemAttributeModifiers() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.effectiveWeaponDamage, 0));
        return multimap;
    }

    public float func_150931_i() {
        return Item.ToolMaterial.WOOD.getDamageVsEntity();
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int posX, int posY, int posZ, EntityLivingBase entity) {
        if (block != null && block != Blocks.leaves && block != Blocks.web && block != Blocks.tallgrass && block != Blocks.vine && block != Blocks.tripwire && !(block instanceof IShearable) && block.getBlockHardness(world, posX, posY, posZ) != 0.0f) {
            stack.damageItem(2, entity);
        }
        return true;
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack stack) {
        return par1Block == Witchery.Blocks.WEB || par1Block == Blocks.web || par1Block == Blocks.redstone_wire || par1Block == Blocks.tripwire;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (block == Witchery.Blocks.WEB || block == Blocks.web || block == Blocks.leaves) {
            return 15.0f;
        }
        if (block == Blocks.wool || block == Witchery.Blocks.TRAPPED_PLANT) {
            return 5.0f;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean itemInteractionForEntity(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity) {
        if (entity.worldObj.isRemote) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(itemstack, (IBlockAccess)entity.worldObj, (int)entity.posX, (int)entity.posY, (int)entity.posZ)) {
                ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.worldObj, (int)entity.posX, (int)entity.posY, (int)entity.posZ, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)itemstack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.entityDropItem(stack, 1.0f);
                    ent.motionY += (double)(rand.nextFloat() * 0.05f);
                    ent.motionX += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.motionZ += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                itemstack.damageItem(1, entity);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (player.worldObj.isRemote) {
            return false;
        }
        World world = player.worldObj;
        Block block = BlockUtil.getBlock(world, x, y, z);
        if (block == null) {
            return false;
        }
        if (block == Blocks.web) {
            world.setBlockToAir(x, y, z);
            world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, new ItemStack(block)));
            this.onBlockDestroyed(itemstack, world, block, x, y, z, (EntityLivingBase)player);
            if (itemstack.stackSize == 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (block == Witchery.Blocks.TRAPPED_PLANT) {
            int meta = world.getBlockMetadata(x, y, z);
            world.setBlockToAir(x, y, z);
            world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, new ItemStack(block, 1, meta)));
            this.onBlockDestroyed(itemstack, world, block, x, y, z, (EntityLivingBase)player);
            if (itemstack.stackSize == 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (block == Witchery.Blocks.BLOOD_ROSE) {
            int meta = world.getBlockMetadata(x, y, z);
            world.setBlockToAir(x, y, z);
            world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, new ItemStack(block, 1, meta)));
            this.onBlockDestroyed(itemstack, world, block, x, y, z, (EntityLivingBase)player);
            if (itemstack.stackSize == 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.worldObj, x, y, z)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)player.worldObj, x, y, z, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.worldObj, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.delayBeforeCanPickup = 10;
                player.worldObj.spawnEntityInWorld((Entity)entityitem);
            }
            itemstack.damageItem(1, (EntityLivingBase)player);
        }
        return false;
    }
}

