/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions.symbols;

import com.emoniph.witchery.entity.EntitySpellEffect;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class SymbolEffectProjectile
extends SymbolEffect {
    private float size = 1.0f;
    private int color = 0xFF0000;
    private int timetolive = -1;

    public SymbolEffectProjectile(int effectID, String unlocalisedName) {
        super(effectID, unlocalisedName);
    }

    public SymbolEffectProjectile(int effectID, String unlocalisedName, int spellCost, boolean curse, boolean fallsToEarth, String knowledgeKey, int cooldown) {
        super(effectID, unlocalisedName, spellCost, curse, fallsToEarth, knowledgeKey, cooldown);
    }

    public SymbolEffectProjectile(int effectID, String unlocalisedName, int spellCost, boolean curse, boolean fallsToEarth, String knowledgeKey, int cooldown, boolean isVisible) {
        super(effectID, unlocalisedName, spellCost, curse, fallsToEarth, knowledgeKey, cooldown, isVisible);
    }

    public SymbolEffectProjectile setColor(int color) {
        this.color = color;
        return this;
    }

    public SymbolEffectProjectile setSize(float size) {
        this.size = size;
        return this;
    }

    public SymbolEffectProjectile setTimeToLive(int ticks) {
        this.timetolive = ticks;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public float getSize() {
        return this.size;
    }

    @Override
    public void perform(World world, EntityPlayer player, int effectLevel) {
        world.playAuxSFXAtEntity((EntityPlayer)null, 1008, (int)player.posX, (int)player.posY, (int)player.posZ, 0);
        float f = 1.0f;
        double motionX = -MathHelper.sin((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * f;
        double motionZ = MathHelper.cos((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * f;
        double motionY = -MathHelper.sin((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * f;
        EntitySpellEffect entity = new EntitySpellEffect(world, (EntityLivingBase)player, motionX, motionY, motionZ, this, effectLevel);
        if (this.timetolive > 0) {
            entity.setLifeTime(this.timetolive);
        }
        entity.setLocationAndAngles(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, entity.rotationYaw, entity.rotationPitch);
        entity.setPosition(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ);
        double d6 = MathHelper.sqrt_double((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        entity.accelerationX = motionX / d6 * 0.3;
        entity.accelerationY = motionY / d6 * 0.3;
        entity.accelerationZ = motionZ / d6 * 0.3;
        double d8 = 1.5;
        Vec3 vec3 = player.getLook(1.0f);
        entity.posX = player.posX + vec3.xCoord * 1.5;
        entity.posY = player.posY + (double)player.eyeHeight - (double)0.1f + vec3.yCoord * 1.5;
        entity.posZ = player.posZ + vec3.zCoord * 1.5;
        world.spawnEntityInWorld((Entity)entity);
    }

    public abstract void onCollision(World var1, EntityLivingBase var2, MovingObjectPosition var3, EntitySpellEffect var4);
}

