/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions.spirit;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.infusion.infusions.spirit.InfusedSpiritEffect;
import com.emoniph.witchery.util.EntityUtil;
import java.util.ArrayList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S08PacketPlayerPosLook;
import net.minecraft.tileentity.TileEntity;

public class InfusedSpiritTwisterEffect
extends InfusedSpiritEffect {
    private static final double RANDOM_SPIN_RADIUS = 3.0;
    private static final double RANDOM_SPIN_RADIUS_SQ = 9.0;

    public InfusedSpiritTwisterEffect(int id, int spirits, int spectres, int banshees, int poltergeists) {
        super(id, "twister", spirits, spectres, banshees, poltergeists);
    }

    @Override
    public int getCooldownTicks() {
        return 10;
    }

    @Override
    public double getRadius() {
        return 8.0;
    }

    @Override
    public boolean doUpdateEffect(TileEntity tile, boolean triggered, ArrayList<EntityLivingBase> foundEntities) {
        if (triggered) {
            for (EntityLivingBase entity : foundEntities) {
                EntityLiving creature;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (player.inventory.armorItemInSlot(0) == null && player.inventory.armorItemInSlot(1) == null && player.inventory.armorItemInSlot(2) == null && player.inventory.armorItemInSlot(3) == null && player.getHeldItem() == null) continue;
                    double yawRadians = Math.atan2(player.posZ - (0.5 + (double)tile.zCoord), player.posX - (0.5 + (double)tile.xCoord));
                    double yaw = Math.toDegrees(yawRadians) + 180.0;
                    double playerYaw = (player.rotationYaw + 90.0f) % 360.0f;
                    if (playerYaw < 0.0) {
                        playerYaw += 360.0;
                    }
                    float rev = ((float)yaw + 90.0f) % 360.0f;
                    double ARC = 45.0;
                    double diff = Math.abs(yaw - playerYaw);
                    if (!(360.0 - diff % 360.0 < 45.0) && !(diff % 360.0 < 45.0) || !(player instanceof EntityPlayerMP)) continue;
                    S08PacketPlayerPosLook packet = new S08PacketPlayerPosLook(player.posX, player.posY, player.posZ, rev, player.rotationPitch, false);
                    Witchery.packetPipeline.sendTo((Packet)packet, player);
                    continue;
                }
                if (!(entity instanceof EntityLiving) || !((creature = (EntityLiving)entity).getMaxHealth() < 50.0f)) continue;
                EntityUtil.dropAttackTarget(creature);
                if (foundEntities.size() <= 1) continue;
                EntityUtil.setTarget(creature, foundEntities.get(tile.getWorldObj().rand.nextInt(foundEntities.size())));
            }
        }
        return triggered;
    }
}

