/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions.creature;

import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import com.emoniph.witchery.util.KeyBindHelper;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class CreaturePowerSquid
extends CreaturePower {
    public CreaturePowerSquid(int powerID) {
        super(powerID, EntitySquid.class);
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, MovingObjectPosition mop) {
        if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null && mop.entityHit instanceof EntityLivingBase) {
            EntityLivingBase targetPlayer = (EntityLivingBase)mop.entityHit;
            world.playSoundAtEntity((Entity)player, "random.fizz", 1.0f, 1.0f / (world.rand.nextFloat() * 0.4f + 1.2f) + 0.5f);
            targetPlayer.addPotionEffect(new PotionEffect(Potion.blindness.id, 200));
        }
    }

    @Override
    public void onUpdate(World world, EntityPlayer player) {
        if (player.isInWater()) {
            Minecraft minecraft = Minecraft.getMinecraft();
            if (KeyBindHelper.isKeyBindDown(Minecraft.getMinecraft().gameSettings.keyBindForward)) {
                player.motionX *= (double)1.15f;
                player.motionZ *= (double)1.15f;
            }
        }
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        int currentEnergy;
        if (event.source == DamageSource.drown && (currentEnergy = Infusion.getCurrentEnergy(player)) >= 1) {
            Infusion.setCurrentEnergy(player, currentEnergy - 1);
            SoundEffect.RANDOM_FIZZ.playAtPlayer(world, player);
            player.addPotionEffect(new PotionEffect(Potion.waterBreathing.id, 1200, 1));
            player.setAir(300);
            event.setCanceled(true);
        }
        super.onDamage(world, player, event);
    }
}

