/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions.creature;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityWitchProjectile;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class CreaturePowerSpider
extends CreaturePower {
    public CreaturePowerSpider(int powerID, Class<? extends EntitySpider> creatureType) {
        super(powerID, creatureType);
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, MovingObjectPosition mop) {
        if (!world.isRemote) {
            world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            world.spawnEntityInWorld((Entity)new EntityWitchProjectile(world, (EntityLivingBase)player, Witchery.Items.GENERIC.itemWeb));
        }
    }

    @Override
    public void onUpdate(World world, EntityPlayer player) {
        int blockZ;
        int blockY;
        int blockX = MathHelper.floor_double((double)player.posX);
        if (world.getBlock(blockX, blockY = MathHelper.floor_double((double)(player.posY + 1.0)), blockZ = MathHelper.floor_double((double)player.posZ)).getMaterial().isSolid()) {
            player.motionY *= 0.6;
        }
        if (player.isCollidedHorizontally) {
            player.motionY = 0.3;
        }
        if (player.isSneaking() && player instanceof EntityPlayer && player.isCollidedHorizontally) {
            player.motionY = 0.0;
        }
    }
}

