/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions.creature;

import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.creature.CreaturePower;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class CreaturePowerGhast
extends CreaturePower {
    public CreaturePowerGhast(int powerID) {
        super(powerID, EntityGhast.class);
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, MovingObjectPosition mop) {
        if (!world.isRemote) {
            world.playAuxSFXAtEntity((EntityPlayer)null, 1008, (int)player.posX, (int)player.posY, (int)player.posZ, 0);
            float f = 1.0f;
            double motionX = -MathHelper.sin((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * f;
            double motionZ = MathHelper.cos((float)(player.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * f;
            double motionY = -MathHelper.sin((float)(player.rotationPitch / 180.0f * (float)Math.PI)) * f;
            EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLivingBase)player, motionX, motionY, motionZ);
            entitylargefireball.setLocationAndAngles(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, entitylargefireball.rotationYaw, entitylargefireball.rotationPitch);
            entitylargefireball.setPosition(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ);
            double d6 = MathHelper.sqrt_double((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            entitylargefireball.accelerationX = motionX / d6 * 0.1;
            entitylargefireball.accelerationY = motionY / d6 * 0.1;
            entitylargefireball.accelerationZ = motionZ / d6 * 0.1;
            double d8 = 1.0;
            Vec3 vec3 = player.getLook(1.0f);
            entitylargefireball.posX = player.posX + vec3.xCoord * d8;
            entitylargefireball.posY = player.posY + (double)(player.height / 2.0f) + 0.5;
            entitylargefireball.posZ = player.posZ + vec3.zCoord * d8;
            world.spawnEntityInWorld((Entity)entitylargefireball);
        }
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        int currentEnergy;
        if (event.source.isFireDamage() && event.isCancelable() && (currentEnergy = Infusion.getCurrentEnergy(player)) >= 3 && !player.isPotionActive(Potion.fireResistance.id)) {
            Infusion.setCurrentEnergy(player, currentEnergy - 3);
            player.addPotionEffect(new PotionEffect(Potion.fireResistance.id, 200, 0));
            SoundEffect.RANDOM_FIZZ.playAtPlayer(world, player);
        }
    }
}

