/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ServerTickEvents;
import com.emoniph.witchery.entity.EntityWitchProjectile;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.InfusionOtherwhere;
import com.emoniph.witchery.network.PacketPushTarget;
import com.emoniph.witchery.ritual.rites.RiteProtectionCircleRepulsive;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.BlockSide;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.EarthItems;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class InfusionOverworld
extends Infusion {
    public InfusionOverworld(int infusionID) {
        super(infusionID);
    }

    @Override
    public IIcon getPowerBarIcon(EntityPlayer player, int index) {
        return Blocks.dirt.getIcon(0, 0);
    }

    @Override
    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
        int blockZ;
        int blockY;
        int blockX;
        Block blockID;
        if (event.distance > 3.0f && ((blockID = world.getBlock(blockX = MathHelper.floor_double((double)player.posX), blockY = MathHelper.floor_double((double)player.posY) - 1, blockZ = MathHelper.floor_double((double)player.posZ))) == Blocks.grass || blockID == Blocks.grass || blockID == Blocks.mycelium || blockID == Blocks.gravel || blockID == Blocks.sand || blockID == Blocks.snow)) {
            if (player.isSneaking()) {
                if (this.consumeCharges(world, player, 10, true)) {
                    event.distance = 0.0f;
                    int EXPLOSION_STRENGTH = 3;
                    world.createExplosion((Entity)player, player.posX, (double)blockY + 0.5, player.posZ, 3.0f, true);
                }
            } else if (this.consumeCharges(world, player, 5, true)) {
                event.distance = 0.0f;
                world.setBlockToAir(blockX, blockY, blockZ);
                ItemStack itemstack = new ItemStack(blockID, 1, 0);
                EntityItem blockEntity = new EntityItem(world, (double)blockX, (double)blockY, (double)blockZ, itemstack);
                world.spawnEntityInWorld((Entity)blockEntity);
            }
        }
    }

    @Override
    public void onLeftClickEntity(ItemStack itemstack, World world, EntityPlayer player, Entity otherEntity) {
        if (world.isRemote) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            int posX = MathHelper.floor_double((double)player.posX);
            int posY = MathHelper.floor_double((double)player.posY);
            int posZ = MathHelper.floor_double((double)player.posZ);
            boolean isWearingMetalArmour = false;
            for (int i = 0; i < 5; ++i) {
                ItemStack heldStack = otherLivingEntity.getEquipmentInSlot(i);
                if (!EarthItems.instance().isMatch(heldStack)) continue;
                isWearingMetalArmour = true;
                break;
            }
            if (isWearingMetalArmour) {
                double ACCELERATION = 3.0;
                if (player.isSneaking()) {
                    if (this.consumeCharges(world, player, 4, true)) {
                        Vec3 look = player.getLookVec();
                        double motionX = look.xCoord * 0.8 * 3.0;
                        double motionY = 1.5;
                        double motionZ = look.zCoord * 0.8 * 3.0;
                        if (otherLivingEntity instanceof EntityPlayer) {
                            EntityPlayer targetPlayer = (EntityPlayer)otherLivingEntity;
                            Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(motionX, 1.5, motionZ), targetPlayer);
                        } else {
                            otherLivingEntity.motionX = motionX;
                            otherLivingEntity.motionY = 1.5;
                            otherLivingEntity.motionZ = motionZ;
                        }
                    }
                } else if (this.consumeCharges(world, player, 2, true)) {
                    Vec3 look = player.getLookVec();
                    double motionX = look.xCoord * 0.8 * 3.0;
                    double motionY = 0.30000000000000004;
                    double motionZ = look.zCoord * 0.8 * 3.0;
                    if (otherLivingEntity instanceof EntityPlayer) {
                        EntityPlayer targetPlayer = (EntityPlayer)otherLivingEntity;
                        Witchery.packetPipeline.sendTo((IMessage)new PacketPushTarget(motionX, 0.30000000000000004, motionZ), targetPlayer);
                    } else {
                        otherLivingEntity.motionX = motionX;
                        otherLivingEntity.motionY = 0.30000000000000004;
                        otherLivingEntity.motionZ = motionZ;
                    }
                }
            }
        }
    }

    @Override
    public void onUsingItemTick(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (!world.isRemote) {
            int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
            int seconds = elapsedTicks / 20;
            if (player.isSneaking()) {
                if (seconds >= 2 && elapsedTicks % 4 == 0 && this.consumeCharges(world, player, 1, true)) {
                    int AreaOfEffect = 6;
                    List entities = world.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(player.posX - 6.0), (double)(player.posY - 6.0), (double)(player.posZ - 6.0), (double)(player.posX + 6.0), (double)(player.posY + 6.0), (double)(player.posZ + 6.0)));
                    for (int i = 0; i < entities.size(); ++i) {
                        EntityItem entity = (EntityItem)entities.get(i);
                        if (!EarthItems.instance().isMatch(entity.getEntityItem())) continue;
                        double d0 = 8.0;
                        double motionX = 0.0;
                        double motionY = 0.0;
                        double motionZ = 0.0;
                        double d1 = (player.posX - entity.posX) / d0;
                        double d2 = (player.posY + (double)player.getEyeHeight() - entity.posY) / d0;
                        double d3 = (player.posZ - entity.posZ) / d0;
                        double d4 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
                        double d5 = 2.0;
                        if (d5 > 0.0) {
                            d5 *= d5;
                            motionX += d1 / Math.max(Math.abs(d1), 0.0) * 1.0;
                            motionY += d2 / Math.max(Math.abs(d1), 0.0) * 1.0;
                            motionZ += d3 / Math.max(Math.abs(d1), 0.0) * 1.0;
                        }
                        boolean oldClip = entity.noClip;
                        entity.noClip = true;
                        entity.moveEntity(motionX, motionY, motionZ);
                        entity.noClip = oldClip;
                    }
                    int AreaOfEffect2 = 6;
                    for (int x = (int)player.posX - 6; x <= (int)player.posX + 6; ++x) {
                        for (int y = (int)player.posY - 3; y <= (int)player.posY + 3; ++y) {
                            for (int z = (int)player.posZ - 6; z <= (int)player.posZ + 6; ++z) {
                                Item ingot;
                                Block id = world.getBlock(x, y, z);
                                if (id == Blocks.air || (ingot = EarthItems.instance().oreToIngot(id)) == null || world.isRemote || !this.consumeCharges(world, player, 2, true)) continue;
                                world.setBlock(x, y, z, Blocks.stone, 0, 3);
                                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x, (double)y, (double)z, new ItemStack(ingot)));
                            }
                        }
                    }
                }
            } else if (seconds >= 2 && elapsedTicks % 20 == 0) {
                this.playSound(world, player, "random.orb");
            }
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        int seconds;
        if (world.isRemote) {
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
        MovingObjectPosition hit = InfusionOtherwhere.doCustomRayTrace(world, player, true, 4.0);
        if (hit != null) {
            switch (hit.typeOfHit) {
                case ENTITY: {
                    if (player.isSneaking() || !(hit.entityHit instanceof EntityLiving) || !this.consumeCharges(world, player, 2, true)) break;
                    EntityLiving entity = (EntityLiving)hit.entityHit;
                    ItemStack heldItem = entity.getHeldItem();
                    if (heldItem != null && EarthItems.instance().isMatch(heldItem) && !world.isRemote) {
                        entity.entityDropItem(heldItem, 2.0f);
                        entity.setCurrentItemOrArmor(0, null);
                    }
                    return;
                }
                case BLOCK: {
                    int DEPTH = 3;
                    if (!player.isSneaking() && BlockSide.TOP.isEqual(hit.sideHit) && world.getBlock(hit.blockX, hit.blockY - 9 - 1, hit.blockZ).getMaterial().isSolid() && this.consumeCharges(world, player, 2, true)) {
                        for (int h = 0; h < 6; ++h) {
                            int originY = hit.blockY - h;
                            Block blockID = world.getBlock(hit.blockX, originY, hit.blockZ);
                            if (!BlockProtect.canBreak(blockID, world)) continue;
                            int blockMetadata = world.getBlockMetadata(hit.blockX, originY, hit.blockZ);
                            world.setBlockToAir(hit.blockX, originY, hit.blockZ);
                            if (BlockProtect.canBreak(hit.blockX, originY + 3, hit.blockZ, world)) {
                                world.setBlock(hit.blockX, originY + 3, hit.blockZ, blockID, blockMetadata, 3);
                            }
                            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)hit.blockX, (double)hit.blockY, (double)hit.blockZ, (double)(hit.blockX + 1), (double)(hit.blockY + 2), (double)(hit.blockZ + 1));
                            for (Object obj : world.getEntitiesWithinAABB(Entity.class, bounds)) {
                                Entity entity = (Entity)obj;
                                if (entity instanceof EntityLivingBase) {
                                    ((EntityLivingBase)entity).setPositionAndUpdate(entity.posX, entity.posY + 3.0, entity.posZ);
                                    continue;
                                }
                                entity.setPosition(entity.posX, entity.posY + 3.0, entity.posZ);
                            }
                        }
                    } else if (!(player.isSneaking() || BlockSide.BOTTOM.isEqual(hit.sideHit) || BlockSide.TOP.isEqual(hit.sideHit))) {
                        if (this.isThrowableRock(world, hit.blockX, hit.blockY, hit.blockZ, hit.sideHit) && this.consumeCharges(world, player, 3, true)) {
                            world.setBlockToAir(hit.blockX, hit.blockY, hit.blockZ);
                            ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_EXPLODE, world, hit.blockX, hit.blockY, hit.blockZ, 0.5, 0.5, 8);
                            EntityWitchProjectile rockEntity = new EntityWitchProjectile(world, (EntityLivingBase)player, Witchery.Items.GENERIC.itemRock);
                            rockEntity.setPosition((double)hit.blockX + 0.5, (double)hit.blockY + 0.5, (double)hit.blockZ + 0.5);
                            world.spawnEntityInWorld((Entity)rockEntity);
                        }
                    } else if (player.isSneaking() && this.consumeCharges(world, player, 2, true)) {
                        Block blockID = world.getBlock(hit.blockX, hit.blockY, hit.blockZ);
                        Item ingot = EarthItems.instance().oreToIngot(blockID);
                        if (ingot != null) {
                            world.setBlock(hit.blockX, hit.blockY, hit.blockZ, Blocks.stone, 0, 3);
                            if (!world.isRemote) {
                                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)hit.blockX, (double)hit.blockY, (double)hit.blockZ, new ItemStack(ingot, 2, 0)));
                            }
                        }
                    }
                    return;
                }
            }
        }
        if ((seconds = elapsedTicks / 20) >= 2 && !player.isSneaking() && this.consumeCharges(world, player, 6 * seconds, true)) {
            ServerTickEvents.TASKS.add(new ShockwaveTask(player, 2 * seconds));
        } else {
            this.playFailSound(world, player);
        }
    }

    private boolean isThrowableRock(World world, int blockX, int blockY, int blockZ, int sideHit) {
        Block[] blocks = new Block[]{Blocks.dirt, Blocks.grass, Blocks.stone, Blocks.cobblestone, Blocks.sand, Blocks.gravel, Blocks.sandstone, Blocks.stone_slab, Blocks.brick_block, Blocks.mossy_cobblestone, Blocks.grass, Blocks.stone_stairs, Blocks.clay, Blocks.soul_sand, Blocks.stonebrick, Blocks.brick_stairs, Blocks.stone_brick_stairs, Blocks.mycelium, Blocks.nether_brick, Blocks.nether_brick_stairs, Blocks.sandstone_stairs, Blocks.hardened_clay, Blocks.coal_block, Blocks.netherrack};
        Block blockID = world.getBlock(blockX, blockY, blockZ);
        if (!Arrays.asList(blocks).contains(blockID)) {
            return false;
        }
        boolean northValid = BlockSide.NORTH.isEqual(sideHit) && !world.getBlock(blockX + 1, blockY, blockZ).getMaterial().isSolid();
        boolean southValid = BlockSide.SOUTH.isEqual(sideHit) && !world.getBlock(blockX - 1, blockY, blockZ).getMaterial().isSolid();
        boolean eastValid = BlockSide.EAST.isEqual(sideHit) && !world.getBlock(blockX, blockY, blockZ + 1).getMaterial().isSolid();
        boolean westValid = BlockSide.WEST.isEqual(sideHit) && !world.getBlock(blockX, blockY, blockZ - 1).getMaterial().isSolid();
        return northValid || southValid || eastValid || westValid;
    }

    private static class ShockwaveTask
    extends ServerTickEvents.ServerTickTask {
        final Coord center;
        final EntityPlayer creator;
        final int maxRadius;
        final int MIN_RADIUS = 2;
        int stage = 0;

        public ShockwaveTask(EntityPlayer creator, int maxRadius) {
            super(creator.worldObj);
            this.center = new Coord((int)creator.posX, (int)creator.posY - 1, (int)creator.posZ);
            this.creator = creator;
            this.maxRadius = maxRadius + 2;
        }

        @Override
        public boolean process() {
            ++this.stage;
            Block centerBlock = this.center.getBlock(this.world);
            if (this.stage == 1) {
                this.drawCircle(this.world, this.center.x, this.center.y, this.center.z, this.stage + 2, 2, 1);
            } else {
                this.drawCircle(this.world, this.center.x, this.center.y + 2, this.center.z, this.stage + 2, 2, -1);
                this.drawCircle(this.world, this.center.x, this.center.y + 1, this.center.z, this.stage + 2 - 1, 2, -1);
            }
            if (this.stage < this.maxRadius) {
                this.drawCircle(this.world, this.center.x, this.center.y, this.center.z, this.stage + 2 + 1, 2, 2);
            } else {
                this.drawCircle(this.world, this.center.x, this.center.y + 1, this.center.z, this.stage + 2, 2, -1);
            }
            int r = this.stage + 2;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.center.x - r), (double)(this.center.y + 1), (double)(this.center.z - r), (double)(this.center.x + r), (double)(this.center.y + 3), (double)(this.center.z + r));
            for (Object obj : this.world.getEntitiesWithinAABB(EntityLivingBase.class, bounds)) {
                EntityLivingBase entity = (EntityLivingBase)obj;
                Coord position = new Coord((Entity)entity);
                double dist = this.center.distanceTo(position);
                if (!(dist <= (double)(r + 1)) || !(dist >= (double)r)) continue;
                entity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)this.creator), 8.0f);
                RiteProtectionCircleRepulsive.push(this.world, (Entity)entity, this.center.x, this.center.y, this.center.z);
            }
            return this.stage == this.maxRadius;
        }

        protected void drawCircle(World world, int x0, int y0, int z0, int radius, int blocksToMove, int direction) {
            int x = radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawPixel(world, x + x0, y0, z + z0, blocksToMove, direction);
                this.drawPixel(world, z + x0, y0, x + z0, blocksToMove, direction);
                this.drawPixel(world, -x + x0, y0, z + z0, blocksToMove, direction);
                this.drawPixel(world, -z + x0, y0, x + z0, blocksToMove, direction);
                this.drawPixel(world, -x + x0, y0, -z + z0, blocksToMove, direction);
                this.drawPixel(world, -z + x0, y0, -x + z0, blocksToMove, direction);
                this.drawPixel(world, x + x0, y0, -z + z0, blocksToMove, direction);
                this.drawPixel(world, z + x0, y0, -x + z0, blocksToMove, direction);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }

        protected void drawPixel(World world, int x, int y, int z, int blocksToMove, int direction) {
            if (direction > 0) {
                if (world.isAirBlock(x, y - blocksToMove + 1, z) || world.getBlock(x, y + 1, z).getMaterial().isSolid()) {
                    return;
                }
                for (int i = 0; i < blocksToMove; ++i) {
                    Block blockID = world.getBlock(x, y - i, z);
                    int blockMetadata = world.getBlockMetadata(x, y - i, z);
                    if (BlockProtect.canBreak(blockID, world)) {
                        world.setBlockToAir(x, y - i, z);
                    }
                    if (!BlockProtect.canBreak(x, y - i + direction, z, world)) continue;
                    world.setBlock(x, y - i + direction, z, blockID, blockMetadata, 3);
                }
            } else {
                if (world.isAirBlock(x, y, z) || world.getBlock(x, y + direction - 1, z).getMaterial().isSolid()) {
                    return;
                }
                for (int i = blocksToMove - 1; i >= 0; --i) {
                    Block blockID = world.getBlock(x, y - i, z);
                    int blockMetadata = world.getBlockMetadata(x, y - i, z);
                    if (BlockProtect.canBreak(blockID, world)) {
                        world.setBlockToAir(x, y - i, z);
                    }
                    if (!BlockProtect.canBreak(x, y - i + direction, z, world)) continue;
                    world.setBlock(x, y - i + direction, z, blockID, blockMetadata, 3);
                }
            }
        }
    }
}

