/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions;

import com.emoniph.witchery.brewing.potions.PotionEnderInhibition;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.DimensionalLocation;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class InfusionOtherwhere
extends Infusion {
    private static final String RECALL_LOCATON_KEY = "WITCRecall";
    private static final int SAVE_RECALL_POINT_THRESHOLD = 60;

    public InfusionOtherwhere(int infusionID) {
        super(infusionID);
    }

    @Override
    public IIcon getPowerBarIcon(EntityPlayer player, int index) {
        return Blocks.portal.getIcon(0, 0);
    }

    @Override
    public void onLeftClickEntity(ItemStack itemstack, World world, EntityPlayer player, Entity otherEntity) {
        if (world.isRemote) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            if (player.isSneaking()) {
                DimensionalLocation recallLocation = this.recallLocation(InfusionOtherwhere.getNBT((Entity)player), RECALL_LOCATON_KEY);
                if (recallLocation != null && recallLocation.dimension != Config.instance().dimensionDreamID && recallLocation.dimension != Config.instance().dimensionTormentID && recallLocation.dimension != Config.instance().dimensionMirrorID && world.provider.dimensionId != Config.instance().dimensionDreamID && world.provider.dimensionId != Config.instance().dimensionTormentID && world.provider.dimensionId != Config.instance().dimensionMirrorID && !PotionEnderInhibition.isActive((Entity)player, 2) && this.consumeCharges(world, player, 4, false)) {
                    if (player instanceof EntityPlayerMP && !InfusionOtherwhere.isConnectionClosed((EntityPlayerMP)player)) {
                        player.fallDistance = 0.0f;
                        ItemGeneral.teleportToLocation(world, recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension, (Entity)player, true);
                        otherLivingEntity.fallDistance = 0.0f;
                        if (!PotionEnderInhibition.isActive((Entity)otherLivingEntity, 2)) {
                            ItemGeneral.teleportToLocation(world, recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension, (Entity)otherLivingEntity, true);
                        }
                    }
                } else {
                    world.playSoundAtEntity((Entity)player, "note.snare", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                }
            } else if (!PotionEnderInhibition.isActive((Entity)player, 2) && this.consumeCharges(world, player, 2, true)) {
                double hikeModified2;
                double HIKE_HEIGHT = 8.0;
                MovingObjectPosition hitMOP = InfusionOtherwhere.raytraceUpBlocks(world, (EntityLivingBase)player, true, 8.0);
                double hikeModified = hitMOP == null ? 8.0 : Math.min((double)hitMOP.blockY - otherLivingEntity.posY - 2.0, 8.0);
                MovingObjectPosition hitMOP2 = InfusionOtherwhere.raytraceUpBlocks(world, otherLivingEntity, true, 8.0);
                double d = hikeModified2 = hitMOP2 == null ? 8.0 : Math.min((double)hitMOP2.blockY - otherLivingEntity.posY - 2.0, 8.0);
                if (player instanceof EntityPlayerMP && !InfusionOtherwhere.isConnectionClosed((EntityPlayerMP)player) && hikeModified > 0.0 && hikeModified2 > 0.0) {
                    ItemGeneral.teleportToLocation(world, player.posX, player.posY + hikeModified, player.posZ, player.dimension, (Entity)player, true);
                    if (!PotionEnderInhibition.isActive((Entity)otherLivingEntity, 2)) {
                        ItemGeneral.teleportToLocation(world, otherLivingEntity.posX, otherLivingEntity.posY + hikeModified2, otherLivingEntity.posZ, otherLivingEntity.dimension, (Entity)otherLivingEntity, true);
                    }
                }
            }
        }
    }

    @Override
    public void onUsingItemTick(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
        if (player.isSneaking() && elapsedTicks == 60) {
            if (!world.isRemote) {
                ChatUtil.sendTranslated(EnumChatFormatting.GRAY, (ICommandSender)player, "witchery.infuse.cansetrecall", new Object[0]);
            }
            player.worldObj.playSoundAtEntity((Entity)player, "note.pling", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        } else if (!player.isSneaking() && elapsedTicks > 0 && elapsedTicks % 20 == 0) {
            int MAX_TELEPORT_DISTANCE = 40 + 20 * (elapsedTicks / 20);
            MovingObjectPosition hitMOP = InfusionOtherwhere.doCustomRayTrace(world, player, true, MAX_TELEPORT_DISTANCE);
            if (hitMOP != null) {
                player.worldObj.playSoundAtEntity((Entity)player, "random.orb", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                if (!world.isRemote) {
                    ChatUtil.sendTranslated(EnumChatFormatting.GRAY, (ICommandSender)player, "witchery.infuse.canteleport", new Object[0]);
                }
            } else {
                player.worldObj.playSoundAtEntity((Entity)player, "random.pop", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (world.isRemote) {
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
        if (player.isSneaking() && elapsedTicks >= 60) {
            this.storeLocation(InfusionOtherwhere.getNBT((Entity)player), RECALL_LOCATON_KEY, player);
            SoundEffect.RANDOM_FIZZ.playAtPlayer(world, player);
        } else if (player.isSneaking()) {
            DimensionalLocation recallLocation = this.recallLocation(InfusionOtherwhere.getNBT((Entity)player), RECALL_LOCATON_KEY);
            if (recallLocation != null && recallLocation.dimension != Config.instance().dimensionDreamID && recallLocation.dimension != Config.instance().dimensionTormentID && recallLocation.dimension != Config.instance().dimensionMirrorID && world.provider.dimensionId != Config.instance().dimensionDreamID && world.provider.dimensionId != Config.instance().dimensionTormentID && world.provider.dimensionId != Config.instance().dimensionMirrorID && !PotionEnderInhibition.isActive((Entity)player, 2) && this.consumeCharges(world, player, 2, false)) {
                if (player instanceof EntityPlayerMP && !InfusionOtherwhere.isConnectionClosed((EntityPlayerMP)player)) {
                    player.fallDistance = 0.0f;
                    ItemGeneral.teleportToLocation(world, recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension, (Entity)player, true);
                    Infusion.setCooldown(world, itemstack, 1500);
                }
            } else {
                world.playSoundAtEntity((Entity)player, "note.snare", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        } else {
            int MAX_TELEPORT_DISTANCE = 40 + 20 * (elapsedTicks / 20);
            MovingObjectPosition hitMOP = InfusionOtherwhere.doCustomRayTrace(world, player, true, MAX_TELEPORT_DISTANCE);
            if (hitMOP != null && !PotionEnderInhibition.isActive((Entity)player, 2) && this.consumeCharges(world, player, 1, false)) {
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)player, 0.5, 2.0, 16);
                InfusionOtherwhere.teleportEntity(player, hitMOP);
                ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)player, 0.5, 2.0, 16);
                Infusion.setCooldown(world, itemstack, 1500);
            } else {
                world.playSoundAtEntity((Entity)player, "note.snare", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                if (hitMOP == null && !world.isRemote) {
                    ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.infuse.cannotteleport", new Object[0]);
                }
            }
        }
    }

    private void storeLocation(NBTTagCompound nbt, String key, EntityPlayer player) {
        DimensionalLocation location = new DimensionalLocation((Entity)player);
        location.saveToNBT(nbt, key);
        if (!player.worldObj.isRemote) {
            ChatUtil.sendTranslated(EnumChatFormatting.GRAY, (ICommandSender)player, "witchery.infuse.setrecall", player.worldObj.provider.getDimensionName(), Integer.valueOf(MathHelper.floor_double((double)location.posX)).toString(), Integer.valueOf(MathHelper.floor_double((double)location.posY)).toString(), Integer.valueOf(MathHelper.floor_double((double)location.posZ)).toString());
        }
    }

    private DimensionalLocation recallLocation(NBTTagCompound nbtTag, String key) {
        DimensionalLocation location = new DimensionalLocation(nbtTag, key);
        if (!location.isValid) {
            return null;
        }
        return location;
    }

    public static void teleportEntity(EntityPlayer entityPlayer, MovingObjectPosition hitMOP) {
        EntityPlayerMP player;
        if (hitMOP != null && entityPlayer instanceof EntityPlayerMP && !InfusionOtherwhere.isConnectionClosed(player = (EntityPlayerMP)entityPlayer)) {
            switch (hitMOP.typeOfHit) {
                case ENTITY: {
                    player.setPositionAndUpdate(hitMOP.hitVec.xCoord, hitMOP.hitVec.yCoord, hitMOP.hitVec.zCoord);
                    break;
                }
                case BLOCK: {
                    double hitx = hitMOP.hitVec.xCoord;
                    double hity = hitMOP.hitVec.yCoord;
                    double hitz = hitMOP.hitVec.zCoord;
                    switch (hitMOP.sideHit) {
                        case 0: {
                            hity -= 2.0;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            hitz -= 0.5;
                            break;
                        }
                        case 3: {
                            hitz += 0.5;
                            break;
                        }
                        case 4: {
                            hitx -= 0.5;
                            break;
                        }
                        case 5: {
                            hitx += 0.5;
                        }
                    }
                    player.fallDistance = 0.0f;
                    player.setPositionAndUpdate(hitx, hity, hitz);
                    break;
                }
            }
        }
    }

    public static MovingObjectPosition doCustomRayTrace(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedBlock = InfusionOtherwhere.raytraceBlocks(world, player, collisionFlag, reachDistance);
        MovingObjectPosition pickedEntity = InfusionOtherwhere.raytraceEntities(world, player, collisionFlag, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        Vec3 playerPosition = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        double dBlock = pickedBlock.hitVec.distanceTo(playerPosition);
        double dEntity = pickedEntity.hitVec.distanceTo(playerPosition);
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public static MovingObjectPosition raytraceEntities(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedEntity = null;
        Vec3 playerPosition = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 playerLook = player.getLookVec();
        Vec3 playerViewOffset = Vec3.createVectorHelper((double)(playerPosition.xCoord + playerLook.xCoord * reachDistance), (double)(playerPosition.yCoord + playerLook.yCoord * reachDistance), (double)(playerPosition.zCoord + playerLook.zCoord * reachDistance));
        double playerBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = player.boundingBox.expand(playerBorder, playerBorder, playerBorder);
        List entitiesHit = world.getEntitiesWithinAABBExcludingEntity((Entity)player, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.canBeCollidedWith() || entityHit.boundingBox == null || (hitMOP = (aabb = entityHit.boundingBox.expand((double)(border = entityHit.getCollisionBorderSize()), (double)border, (double)border)).calculateIntercept(playerPosition, playerViewOffset)) == null) continue;
            if (aabb.isVecInside(playerPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(entityHit)) == null) continue;
                pickedEntity.hitVec = hitMOP.hitVec;
                closestEntity = 0.0;
                continue;
            }
            double distance = playerPosition.distanceTo(hitMOP.hitVec);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.hitVec = hitMOP.hitVec;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    private static boolean isConnectionClosed(EntityPlayerMP player) {
        return !player.playerNetServerHandler.netManager.isChannelOpen();
    }

    public static MovingObjectPosition raytraceBlocks(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        Vec3 playerPosition = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 playerLook = player.getLookVec();
        Vec3 playerViewOffset = Vec3.createVectorHelper((double)(playerPosition.xCoord + playerLook.xCoord * reachDistance), (double)(playerPosition.yCoord + playerLook.yCoord * reachDistance), (double)(playerPosition.zCoord + playerLook.zCoord * reachDistance));
        return world.func_147447_a(playerPosition, playerViewOffset, collisionFlag, !collisionFlag, false);
    }

    private static MovingObjectPosition raytraceUpBlocks(World world, EntityLivingBase player, boolean collisionFlag, double reachDistance) {
        Vec3 playerPosition = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 playerUp = Vec3.createVectorHelper((double)0.0, (double)1.0, (double)0.0);
        Vec3 playerViewOffset = Vec3.createVectorHelper((double)(playerPosition.xCoord + playerUp.xCoord * reachDistance), (double)(playerPosition.yCoord + playerUp.yCoord * reachDistance), (double)(playerPosition.zCoord + playerUp.zCoord * reachDistance));
        return world.func_147447_a(playerPosition, playerViewOffset, collisionFlag, !collisionFlag, false);
    }
}

