/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.infusion.infusions;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBarrier;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.infusion.infusions.InfusionOtherwhere;
import com.emoniph.witchery.util.BlockSide;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.EntityUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class InfusionLight
extends Infusion {
    private static final int BARRIER_RADIUS = 2;
    private static final int BARRIER_HEIGHT = 3;
    private static final boolean BARRIER_BLOCKS_PLAYERS = true;
    private static final int AGGRO_DROP_RADIUS = 20;
    protected static final int BARRIER_TICKS_TO_LIVE_ = 200;

    public InfusionLight(int infusionID) {
        super(infusionID);
    }

    @Override
    public IIcon getPowerBarIcon(EntityPlayer player, int index) {
        return Blocks.snow.getIcon(0, 0);
    }

    @Override
    public void onLeftClickEntity(ItemStack itemstack, World world, EntityPlayer player, Entity otherEntity) {
        if (world.isRemote) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            int UPSHIFT = 4;
            int posX = (int)otherEntity.posX;
            int posY = (int)otherEntity.posY + 4;
            int posZ = (int)otherEntity.posZ;
            if (world.isAirBlock(posX, posY, posZ) && world.isAirBlock(posX, posY + 1, posZ) && world.isAirBlock(posX, posY + 2, posZ) && world.isAirBlock(posX + 1, posY, posZ) && world.isAirBlock(posX + 1, posY + 1, posZ) && world.isAirBlock(posX + 1, posY + 2, posZ) && world.isAirBlock(posX, posY, posZ + 1) && world.isAirBlock(posX, posY + 1, posZ + 1) && world.isAirBlock(posX, posY + 2, posZ + 1) && world.isAirBlock(posX - 1, posY, posZ) && world.isAirBlock(posX - 1, posY + 1, posZ) && world.isAirBlock(posX - 1, posY + 2, posZ) && world.isAirBlock(posX, posY, posZ - 1) && world.isAirBlock(posX, posY + 1, posZ - 1) && world.isAirBlock(posX, posY + 2, posZ - 1) && this.consumeCharges(world, player, 5, true)) {
                this.drawFilledCircle(world, posX, posZ, posY - 1, 2, null);
                for (int y = posY; y < posY + 3; ++y) {
                    this.drawCircle(world, posX, posZ, y, 2, null);
                }
                this.drawFilledCircle(world, posX, posZ, posY + 3, 2, null);
                otherLivingEntity.setPositionAndUpdate((double)posX, (double)posY, (double)posZ);
            }
        }
    }

    @Override
    public void onUsingItemTick(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (world.isRemote) {
            if (!player.isRiding()) {
                int var7;
                int var6;
                int var5 = MathHelper.floor_double((double)player.posX);
                if (world.getBlock(var5, var6 = MathHelper.floor_double((double)(player.posY - 2.0)), var7 = MathHelper.floor_double((double)player.posZ)) != Blocks.ice) {
                    if (player.onGround) {
                        if (!player.isInWater()) {
                            player.motionX *= 1.6500000476837158;
                            player.motionZ *= 1.6500000476837158;
                        } else {
                            player.motionX *= (double)1.1f;
                            player.motionZ *= (double)1.1f;
                        }
                    }
                } else {
                    player.motionX *= (double)1.1f;
                    player.motionZ *= (double)1.1f;
                }
            }
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
        if (elapsedTicks % 30 == 0 && elapsedTicks > 19) {
            if (this.consumeCharges(world, player, 1, true)) {
                this.bendLightAroundPlayer(world, player, true);
            } else {
                this.bendLightAroundPlayer(world, player, false);
            }
        }
    }

    protected void bendLightAroundPlayer(World world, EntityPlayer player, boolean active) {
        if (active) {
            player.addPotionEffect(new PotionEffect(Potion.invisibility.id, 30, 0, true));
            int r = 20;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(player.posX - 20.0), (double)player.posY, (double)(player.posZ - 20.0), (double)(player.posX + 20.0), (double)(player.posY + 2.0), (double)(player.posZ + 20.0));
            for (Object obj : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                EntityLiving entity = (EntityLiving)obj;
                if (entity.getAttackTarget() != player || !(Coord.distance(entity.posX, entity.posY, entity.posZ, player.posX, player.posY, player.posZ) <= 20.0)) continue;
                EntityUtil.dropAttackTarget(entity);
            }
        } else {
            player.removePotionEffect(Potion.invisibility.id);
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        MovingObjectPosition hitMOP;
        if (world.isRemote) {
            return;
        }
        this.bendLightAroundPlayer(world, player, false);
        int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
        if (elapsedTicks < 20 && player.isSneaking() && (hitMOP = InfusionOtherwhere.doCustomRayTrace(world, player, true, 16.0)) != null) {
            switch (hitMOP.typeOfHit) {
                case ENTITY: {
                    if (!(hitMOP.entityHit instanceof EntityLivingBase)) break;
                    EntityLivingBase otherLivingEntity = (EntityLivingBase)hitMOP.entityHit;
                    if (!this.consumeCharges(world, player, 3, true)) break;
                    int posX = (int)otherLivingEntity.posX;
                    int posY = (int)otherLivingEntity.posY;
                    int posZ = (int)otherLivingEntity.posZ;
                    this.drawFilledCircle(world, posX, posZ, posY - 1, 1, player);
                    for (int y = posY; y < posY + 3; ++y) {
                        this.drawCircle(world, posX, posZ, y, 2, player);
                    }
                    this.drawFilledCircle(world, posX, posZ, posY + 3, 2, player);
                    break;
                }
                case BLOCK: {
                    int z;
                    int y;
                    int x;
                    int i;
                    int dy;
                    int dx;
                    if (BlockSide.TOP.isEqual(hitMOP.sideHit) && this.consumeCharges(world, player, 3, true)) {
                        InfusionLight.placeBarrierShield(world, player, hitMOP);
                        break;
                    }
                    if (BlockSide.TOP.isEqual(hitMOP.sideHit) || BlockSide.TOP.isEqual(hitMOP.sideHit) || !this.consumeCharges(world, player, 3, true)) break;
                    int b0 = 0;
                    switch (hitMOP.sideHit) {
                        case 0: 
                        case 1: {
                            b0 = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            b0 = 8;
                            break;
                        }
                        case 4: 
                        case 5: {
                            b0 = 4;
                        }
                    }
                    int n = hitMOP.sideHit == 5 ? 1 : (dx = hitMOP.sideHit == 4 ? -1 : 0);
                    int n2 = hitMOP.sideHit == 0 ? -1 : (dy = hitMOP.sideHit == 1 ? 1 : 0);
                    int dz = hitMOP.sideHit == 3 ? 1 : (hitMOP.sideHit == 2 ? -1 : 0);
                    int sproutExtent = 16;
                    boolean isInitialBlockSolid = world.getBlock(hitMOP.blockX, hitMOP.blockY, hitMOP.blockZ).getMaterial().isSolid();
                    int n3 = i = hitMOP.sideHit == 1 && !isInitialBlockSolid ? 0 : 1;
                    while (i < 16 && InfusionLight.setBlockIfNotSolid(world, x = hitMOP.blockX + i * dx, y = hitMOP.blockY + i * dy, z = hitMOP.blockZ + i * dz)) {
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    public static void placeBarrierShield(World world, EntityPlayer player, MovingObjectPosition hitMOP) {
        double f1 = MathHelper.cos((float)(-player.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        double f2 = MathHelper.sin((float)(-player.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        Vec3 loc = Vec3.createVectorHelper((double)f2, (double)0.0, (double)f1);
        Material material = world.getBlock(hitMOP.blockX, hitMOP.blockY, hitMOP.blockZ).getMaterial();
        int yPlus = 1;
        if (material != null && !material.isSolid()) {
            yPlus = 0;
        }
        InfusionLight.drawBarrierBlockColumn(world, player, hitMOP.blockX, hitMOP.blockY + yPlus, hitMOP.blockZ, 3);
        loc.rotateAroundY((float)Math.toRadians(90.0));
        int newX = MathHelper.floor_double((double)((double)hitMOP.blockX + 0.5 + loc.xCoord * 1.0));
        int newZ = MathHelper.floor_double((double)((double)hitMOP.blockZ + 0.5 + loc.zCoord * 1.0));
        InfusionLight.drawBarrierBlockColumn(world, player, newX, hitMOP.blockY + yPlus, newZ, 3);
        loc.rotateAroundY((float)Math.toRadians(180.0));
        newX = MathHelper.floor_double((double)((double)hitMOP.blockX + 0.5 + loc.xCoord * 1.0));
        newZ = MathHelper.floor_double((double)((double)hitMOP.blockZ + 0.5 + loc.zCoord * 1.0));
        InfusionLight.drawBarrierBlockColumn(world, player, newX, hitMOP.blockY + yPlus, newZ, 3);
    }

    private static boolean setBlockIfNotSolid(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z).getMaterial().isReplaceable()) {
            BlockBarrier.setBlock(world, x, y, z, 200, true, null);
            return true;
        }
        return false;
    }

    private static void drawBarrierBlockColumn(World world, EntityPlayer player, int posX, int posY, int posZ, int height) {
        for (int offsetPosY = posY; offsetPosY < posY + height; ++offsetPosY) {
            Material material = world.getBlock(posX, offsetPosY, posZ).getMaterial();
            Block blockID = world.getBlock(posX, offsetPosY, posZ);
            if (!material.isReplaceable() && blockID != Witchery.Blocks.BARRIER) continue;
            BlockBarrier.setBlock(world, posX, offsetPosY, posZ, 200, true, player);
        }
    }

    protected void drawCircle(World world, int x0, int z0, int y, int radius, EntityPlayer player) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawPixel(world, x + x0, z + z0, y, player);
            this.drawPixel(world, z + x0, x + z0, y, player);
            this.drawPixel(world, -x + x0, z + z0, y, player);
            this.drawPixel(world, -z + x0, x + z0, y, player);
            this.drawPixel(world, -x + x0, -z + z0, y, player);
            this.drawPixel(world, -z + x0, -x + z0, y, player);
            this.drawPixel(world, x + x0, -z + z0, y, player);
            this.drawPixel(world, z + x0, -x + z0, y, player);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawFilledCircle(World world, int x0, int z0, int y, int radius, EntityPlayer player) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, -x + x0, x + x0, z + z0, y, player);
            this.drawLine(world, -z + x0, z + x0, x + z0, y, player);
            this.drawLine(world, -x + x0, x + x0, -z + z0, y, player);
            this.drawLine(world, -z + x0, z + x0, -x + z0, y, player);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, int x1, int x2, int z, int y, EntityPlayer player) {
        for (int x = x1; x <= x2; ++x) {
            this.drawPixel(world, x, z, y, player);
        }
    }

    protected void drawPixel(World world, int x, int z, int y, EntityPlayer player) {
        Block blockID = world.getBlock(x, y, z);
        Material material = world.getBlock(x, y, z).getMaterial();
        if (!material.isSolid() || blockID == Witchery.Blocks.BARRIER || material == Material.air) {
            BlockBarrier.setBlock(world, x, y, z, 200, true, player);
        }
    }
}

