/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class EntityAITradePlayerGeneric
extends EntityAIBase {
    private IMerchant merchant;
    private EntityLiving entity;

    public EntityAITradePlayerGeneric(IMerchant merchant, EntityLiving entity) {
        this.merchant = merchant;
        this.entity = entity;
        this.setMutexBits(5);
    }

    public boolean shouldExecute() {
        if (!this.entity.isEntityAlive()) {
            return false;
        }
        if (this.entity.isInWater()) {
            return false;
        }
        if (!this.entity.onGround) {
            return false;
        }
        if (this.entity.velocityChanged) {
            return false;
        }
        EntityPlayer entityplayer = this.merchant.getCustomer();
        return entityplayer == null ? false : (this.entity.getDistanceSqToEntity((Entity)entityplayer) > 16.0 ? false : entityplayer.openContainer instanceof Container);
    }

    public void startExecuting() {
        this.entity.getNavigator().clearPathEntity();
    }

    public void resetTask() {
        this.merchant.setCustomer((EntityPlayer)null);
    }
}

