/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.entity.EntityGoblin;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.AxisAlignedBB;

public class EntityAIPickUpBlocks
extends EntityAIBase {
    protected final EntityGoblin entity;
    protected final double range;

    public EntityAIPickUpBlocks(EntityGoblin entity, double range) {
        this.entity = entity;
        this.range = range;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        return this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItem() == null && this.entity.getLeashed() && this.isItemInReachableDistance();
    }

    public void startExecuting() {
        AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.entity.posX - this.range), (double)(this.entity.posY - this.range), (double)(this.entity.posZ - this.range), (double)(this.entity.posX + this.range), (double)(this.entity.posY + this.range), (double)(this.entity.posZ + this.range));
        List items = this.entity.worldObj.getEntitiesWithinAABB(EntityItem.class, bb);
        double SPEED = 0.6;
        for (EntityItem item : items) {
            if (!this.entity.getNavigator().tryMoveToEntityLiving((Entity)item, 0.6)) continue;
            break;
        }
    }

    public boolean continueExecuting() {
        return this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItem() == null && this.entity.getLeashed() && this.isItemInReachableDistance();
    }

    public void updateTask() {
        if (this.entity.getNavigator().noPath()) {
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.entity.posX - this.range), (double)(this.entity.posY - this.range), (double)(this.entity.posZ - this.range), (double)(this.entity.posX + this.range), (double)(this.entity.posY + this.range), (double)(this.entity.posZ + this.range));
            List items = this.entity.worldObj.getEntitiesWithinAABB(EntityItem.class, bb);
            double SPEED = 0.6;
            for (EntityItem item : items) {
                if (!this.entity.getNavigator().tryMoveToEntityLiving((Entity)item, 0.6)) continue;
                break;
            }
        } else {
            double PICKUP_RANGE = 1.5;
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.entity.posX - 1.5), (double)(this.entity.posY - 1.5), (double)(this.entity.posZ - 1.5), (double)(this.entity.posX + 1.5), (double)(this.entity.posY + 1.5), (double)(this.entity.posZ + 1.5));
            List items = this.entity.worldObj.getEntitiesWithinAABB(EntityItem.class, bb);
            if (!items.isEmpty()) {
                this.entity.setCurrentItemOrArmor(0, ((EntityItem)items.get(0)).getEntityItem());
                if (!this.entity.worldObj.isRemote) {
                    ((EntityItem)items.get(0)).setDead();
                }
            }
        }
    }

    protected boolean isItemInReachableDistance() {
        AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.entity.posX - this.range), (double)(this.entity.posY - this.range), (double)(this.entity.posZ - this.range), (double)(this.entity.posX + this.range), (double)(this.entity.posY + this.range), (double)(this.entity.posZ + this.range));
        List items = this.entity.worldObj.getEntitiesWithinAABB(EntityItem.class, bb);
        double SPEED = 0.1;
        for (EntityItem item : items) {
            if (this.entity.getNavigator().getPathToEntityLiving((Entity)item) == null) continue;
            return true;
        }
        return false;
    }
}

