/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class EntityAIMoveTowardsEntityClass
extends EntityAIBase {
    private EntityCreature theEntity;
    private EntityLivingBase targetEntity;
    private Class<? extends EntityLiving> targetType;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private double speed;
    private float maxTargetDistance;
    private float minTargetDistance;

    public EntityAIMoveTowardsEntityClass(EntityCreature par1EntityCreature, Class<? extends EntityLiving> targetType, double par2, float par4, float par5) {
        this.theEntity = par1EntityCreature;
        this.targetType = targetType;
        this.speed = par2;
        this.minTargetDistance = par4;
        this.maxTargetDistance = par5;
        this.setMutexBits(1);
    }

    private EntityLiving getDistanceSqToPartner() {
        double R = this.maxTargetDistance;
        AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)(this.theEntity.posX - R), (double)(this.theEntity.posY - R), (double)(this.theEntity.posZ - R), (double)(this.theEntity.posX + R), (double)(this.theEntity.posY + R), (double)(this.theEntity.posZ + R));
        List mogs = this.theEntity.worldObj.getEntitiesWithinAABB(this.targetType, bb);
        double minDistance = Double.MAX_VALUE;
        EntityLiving target = null;
        for (Object obj : mogs) {
            EntityLiving mog = (EntityLiving)obj;
            double distance = this.theEntity.getDistanceSqToEntity((Entity)mog);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            target = mog;
        }
        return target;
    }

    public boolean shouldExecute() {
        if (this.theEntity.worldObj.rand.nextInt(20) != 0) {
            return false;
        }
        this.targetEntity = this.getDistanceSqToPartner();
        if (this.targetEntity == null) {
            return false;
        }
        double dist = this.targetEntity.getDistanceSqToEntity((Entity)this.theEntity);
        if (dist > (double)(this.maxTargetDistance * this.maxTargetDistance)) {
            return false;
        }
        if (dist < (double)(this.minTargetDistance * this.minTargetDistance)) {
            return false;
        }
        Vec3 vec3 = RandomPositionGenerator.findRandomTargetBlockTowards((EntityCreature)this.theEntity, (int)16, (int)7, (Vec3)Vec3.createVectorHelper((double)this.targetEntity.posX, (double)this.targetEntity.posY, (double)this.targetEntity.posZ));
        if (vec3 == null) {
            return false;
        }
        this.movePosX = vec3.xCoord;
        this.movePosY = vec3.yCoord;
        this.movePosZ = vec3.zCoord;
        return true;
    }

    public boolean continueExecuting() {
        return !this.theEntity.getNavigator().noPath() && this.targetEntity.isEntityAlive() && this.targetEntity.getDistanceSqToEntity((Entity)this.theEntity) < (double)(this.maxTargetDistance * this.maxTargetDistance);
    }

    public void resetTask() {
        this.targetEntity = null;
    }

    public void startExecuting() {
        this.theEntity.getNavigator().tryMoveToXYZ(this.movePosX, this.movePosY, this.movePosZ, this.speed);
    }
}

