/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.item.ItemGeneral;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityAIFlyerFollowOwner
extends EntityAIBase {
    private EntityTameable thePet;
    private EntityLivingBase theOwner;
    World theWorld;
    private double field_75336_f;
    private int field_75343_h;
    float maxDist;
    float minDist;
    private boolean field_75344_i;

    public EntityAIFlyerFollowOwner(EntityTameable par1EntityTameable, double par2, float par4, float par5) {
        this.thePet = par1EntityTameable;
        this.theWorld = par1EntityTameable.worldObj;
        this.field_75336_f = par2;
        this.minDist = par4;
        this.maxDist = par5;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.thePet.getOwner();
        if (entitylivingbase == null && Familiar.couldBeFamiliar(this.thePet)) {
            entitylivingbase = Familiar.getOwnerForFamiliar(this.thePet).getCurrentOwner();
        }
        if (entitylivingbase == null) {
            return false;
        }
        if (this.thePet.isSitting()) {
            return false;
        }
        if (this.thePet.dimension != entitylivingbase.dimension || this.thePet.getDistanceSqToEntity((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = entitylivingbase;
        return true;
    }

    public boolean continueExecuting() {
        return this.thePet.getDistanceSqToEntity((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist) && !this.thePet.isSitting();
    }

    public void startExecuting() {
        this.field_75343_h = 0;
    }

    public void resetTask() {
        this.theOwner = null;
    }

    public void updateTask() {
        if (!this.thePet.isSitting() && --this.field_75343_h <= 0) {
            this.field_75343_h = 10;
            if (this.thePet.dimension != this.theOwner.dimension || this.thePet.getDistanceSqToEntity((Entity)this.theOwner) >= 256.0) {
                int x = MathHelper.floor_double((double)this.theOwner.posX) - 2;
                int z = MathHelper.floor_double((double)this.theOwner.posZ) - 2;
                int y = MathHelper.floor_double((double)this.theOwner.boundingBox.minY) - 2;
                for (int dx = 0; dx <= 4; ++dx) {
                    for (int dz = 0; dz <= 4; ++dz) {
                        for (int dy = 0; dy <= 4; ++dy) {
                            int newX = x + dz;
                            int newY = y + dy;
                            int newZ = z + dz;
                            if (!this.theOwner.worldObj.getBlock(newX, newY - 1, newZ).isSideSolid((IBlockAccess)this.theOwner.worldObj, newX, newY - 1, newZ, ForgeDirection.UP) || this.theOwner.worldObj.getBlock(newX, newY, newZ).isNormalCube() || this.theOwner.worldObj.getBlock(newX, newY + 1, newZ).isNormalCube()) continue;
                            ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                            ItemGeneral.teleportToLocation(this.theWorld, 0.5 + (double)newX, 0.01 + (double)newY, 0.5 + (double)newZ, this.theOwner.dimension, (Entity)this.thePet, true);
                            return;
                        }
                    }
                }
            } else {
                double d0 = this.theOwner.posX - this.thePet.posX;
                double d1 = this.theOwner.posY - this.thePet.posY;
                double d2 = this.theOwner.posZ - this.thePet.posZ;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.isCourseTraversable(this.theOwner.posX, this.theOwner.posY, this.theOwner.posZ, d3 = (double)MathHelper.sqrt_double((double)d3))) {
                    this.thePet.motionX += d0 / d3 * 0.1;
                    this.thePet.motionY = this.thePet.posY < this.theOwner.posY + 2.0 ? (this.thePet.motionY += d1 / d3 * 0.1 + 0.1) : (this.thePet.motionY += d1 / d3 * 0.1);
                    this.thePet.motionZ += d2 / d3 * 0.1;
                } else {
                    double newX = this.thePet.posX + (double)((this.thePet.worldObj.rand.nextFloat() * 8.0f - 4.0f) * 6.0f);
                    double newY = this.thePet.posY + (double)((this.thePet.worldObj.rand.nextFloat() * 2.0f - 1.0f) * 6.0f);
                    double newZ = this.thePet.posZ + (double)((this.thePet.worldObj.rand.nextFloat() * 8.0f - 4.0f) * 6.0f);
                    d0 = newX - this.thePet.posX;
                    d1 = newY - this.thePet.posY;
                    d2 = newZ - this.thePet.posZ;
                    d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    d3 = MathHelper.sqrt_double((double)d3);
                    this.thePet.motionX += d0 / d3 * 0.1;
                    this.thePet.motionY += d1 / d3 * 0.1 + 0.1;
                    this.thePet.motionZ += d2 / d3 * 0.1;
                }
            }
            this.thePet.renderYawOffset = this.thePet.rotationYaw = -((float)Math.atan2(this.thePet.motionX, this.thePet.motionZ)) * 180.0f / (float)Math.PI;
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.thePet.posX) / par7;
        double d5 = (par3 - this.thePet.posY) / par7;
        double d6 = (par5 - this.thePet.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.thePet.boundingBox.copy();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.thePet.worldObj.getCollidingBoundingBoxes((Entity)this.thePet, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

