/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockVoidBramble;
import com.emoniph.witchery.brewing.EntityBrew;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.entity.EntityFlyingTameable;
import com.emoniph.witchery.entity.EntityWitchProjectile;
import com.emoniph.witchery.util.TimeUtil;
import com.emoniph.witchery.util.Waypoint;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;

public class EntityAIFlyerFlyToWaypoint
extends EntityAIBase {
    private EntityFlyingTameable flyer;
    private CarryRequirement carryRequirement;
    private static final double HIT_RADIUS = 1.0;
    private static final double HIT_RADIUS_SQ = 1.0;
    int courseTimer = 0;

    public EntityAIFlyerFlyToWaypoint(EntityFlyingTameable flyer, CarryRequirement carryRestrictions) {
        this.flyer = flyer;
        this.carryRequirement = carryRestrictions;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        return this.flyer.waypoint != null && (this.flyer.getHeldItem() != null || this.carryRequirement != CarryRequirement.HELD_ITEM);
    }

    public boolean continueExecuting() {
        boolean heldItem = this.flyer.getHeldItem() != null;
        boolean awayFromHome = this.flyer.getDistanceSq(this.flyer.homeX, this.flyer.posY, this.flyer.homeZ) > 1.0 || Math.abs(this.flyer.posY - this.flyer.homeY) > 1.0;
        return heldItem && this.carryRequirement == CarryRequirement.HELD_ITEM || this.flyer.waypoint != null || awayFromHome;
    }

    public void startExecuting() {
    }

    public void resetTask() {
        this.flyer.waypoint = null;
        this.flyer.setSitting(true);
        if (this.flyer.riddenByEntity != null) {
            this.flyer.riddenByEntity.mountEntity(null);
        }
        this.courseTimer = 0;
    }

    public void updateTask() {
        if (!this.flyer.isSitting()) {
            Waypoint waypoint = this.flyer.getWaypoint();
            if (this.carryRequirement == CarryRequirement.ENTITY_LIVING) {
                List entities;
                if (this.flyer.getDistanceSq(waypoint.X, waypoint.Y, waypoint.Z) <= 1.0 && (entities = this.flyer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.flyer.boundingBox.expand(1.0, 1.0, 1.0))) != null && entities.size() > 1) {
                    if (!this.flyer.worldObj.isRemote) {
                        for (EntityLivingBase entity : entities) {
                            if (entity == this.flyer) continue;
                            entity.mountEntity((Entity)this.flyer);
                        }
                    }
                    this.flyer.waypoint = null;
                    waypoint = this.flyer.getWaypoint();
                }
            } else if (this.flyer.getHeldItem() != null && this.flyer.getDistanceSq(waypoint.X, waypoint.Y, waypoint.Z) <= 1.0) {
                if (!this.flyer.worldObj.isRemote) {
                    ItemStack stack = this.flyer.getHeldItem();
                    this.flyer.setCurrentItemOrArmor(0, null);
                    if (Witchery.Items.GENERIC.isBrew(stack)) {
                        this.flyer.worldObj.playSoundAtEntity((Entity)this.flyer, "random.bow", 0.5f, 0.4f / (this.flyer.worldObj.rand.nextFloat() * 0.4f + 0.8f));
                        EntityWitchProjectile projectile = new EntityWitchProjectile(this.flyer.worldObj, (EntityLivingBase)this.flyer, Witchery.Items.GENERIC.subItems.get(stack.getItemDamage()));
                        projectile.motionX = 0.0;
                        projectile.motionZ = 0.0;
                        this.flyer.worldObj.spawnEntityInWorld((Entity)projectile);
                    } else if (Witchery.Items.BREW == stack.getItem() && WitcheryBrewRegistry.INSTANCE.isSplash(stack.getTagCompound())) {
                        this.flyer.worldObj.playSoundAtEntity((Entity)this.flyer, "random.bow", 0.5f, 0.4f / (this.flyer.worldObj.rand.nextFloat() * 0.4f + 0.8f));
                        EntityBrew projectile = new EntityBrew(this.flyer.worldObj, (EntityLivingBase)this.flyer, stack, false);
                        projectile.motionX = 0.0;
                        projectile.motionZ = 0.0;
                        this.flyer.worldObj.spawnEntityInWorld((Entity)projectile);
                    } else if (stack.getItem() == Items.potionitem && ItemPotion.isSplash((int)stack.getItemDamage())) {
                        this.flyer.worldObj.playSoundAtEntity((Entity)this.flyer, "random.bow", 0.5f, 0.4f / (this.flyer.worldObj.rand.nextFloat() * 0.4f + 0.8f));
                        EntityPotion projectile = new EntityPotion(this.flyer.worldObj, (EntityLivingBase)this.flyer, stack);
                        projectile.motionX = 0.0;
                        projectile.motionZ = 0.0;
                        this.flyer.worldObj.spawnEntityInWorld((Entity)projectile);
                    } else {
                        EntityItem item = new EntityItem(this.flyer.worldObj, this.flyer.posX, this.flyer.posY, this.flyer.posZ, stack);
                        if (stack.getItem() == Witchery.Items.SEEDS_MINDRAKE) {
                            item.lifespan = TimeUtil.secsToTicks(3);
                        }
                        this.flyer.worldObj.spawnEntityInWorld((Entity)item);
                    }
                }
                this.flyer.waypoint = null;
                waypoint = this.flyer.getWaypoint();
            }
            double dX = waypoint.X - this.flyer.posX;
            double dY = waypoint.Y - this.flyer.posY;
            double dZ = waypoint.Z - this.flyer.posZ;
            double trajectory = dX * dX + dY * dY + dZ * dZ;
            if ((trajectory = (double)MathHelper.sqrt_double((double)trajectory)) >= 128.0 && this.carryRequirement == CarryRequirement.HELD_ITEM) {
                BlockVoidBramble.teleportRandomly(this.flyer.worldObj, (int)waypoint.X, (int)waypoint.Y, (int)waypoint.Z, (Entity)this.flyer, 16);
            }
            if (--this.courseTimer < 0) {
                this.courseTimer = 0;
            }
            if (this.courseTimer == 0) {
                if (!this.isCourseTraversable(waypoint.X, waypoint.Y, waypoint.Z, trajectory)) {
                    double newX = this.flyer.posX + (this.flyer.worldObj.rand.nextDouble() * 4.0 - 2.0) * 6.0;
                    double newY = this.flyer.posY + (this.flyer.worldObj.rand.nextDouble() * 2.0 - 1.0) * 4.0;
                    double newZ = this.flyer.posZ + (this.flyer.worldObj.rand.nextDouble() * 4.0 - 2.0) * 6.0;
                    if (this.flyer.worldObj.rand.nextInt(2) != 0) {
                        dX = newX - this.flyer.posX;
                        dZ = newZ - this.flyer.posZ;
                    }
                    dY = this.flyer.getDistanceSq(waypoint.X, waypoint.Y, waypoint.Z) <= 1.0 ? (this.flyer.posY > waypoint.Y && newY > 0.0 ? -newY : newY) - this.flyer.posY : newY - this.flyer.posY;
                    trajectory = dX * dX + dY * dY + dZ * dZ;
                    trajectory = MathHelper.sqrt_double((double)trajectory);
                }
                double ACCELERATION = 0.2;
                this.flyer.motionX += dX / trajectory * 0.2;
                this.flyer.motionZ += dZ / trajectory * 0.2;
                this.flyer.motionY = this.flyer.motionY + (dY / trajectory * 0.2 + (this.flyer.posY < Math.min(waypoint.Y + (double)(this.carryRequirement == CarryRequirement.HELD_ITEM ? 32 : 32), 255.0) ? 0.1 : 0.0));
                this.courseTimer = 10;
            }
            this.flyer.renderYawOffset = this.flyer.rotationYaw = -((float)Math.atan2(this.flyer.motionX, this.flyer.motionZ)) * 180.0f / (float)Math.PI;
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (par1 - this.flyer.posX) / par7;
        double d5 = (par3 - this.flyer.posY) / par7;
        double d6 = (par5 - this.flyer.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.flyer.boundingBox.copy();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.flyer.worldObj.getCollidingBoundingBoxes((Entity)this.flyer, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static enum CarryRequirement {
        NONE,
        HELD_ITEM,
        ENTITY_LIVING;

    }
}

