/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity.ai;

import com.emoniph.witchery.Witchery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;

public class EntityAIAttackCloseTargetOnCollide
extends EntityAIAttackOnCollide {
    EntityCreature attacker;
    Class classTarget;
    double maxDistance;

    public EntityAIAttackCloseTargetOnCollide(EntityCreature par1EntityLiving, Class par2Class, double par3, boolean par4, double maxDistance) {
        this(par1EntityLiving, par3, par4, maxDistance);
        this.classTarget = par2Class;
    }

    public EntityAIAttackCloseTargetOnCollide(EntityCreature par1EntityLiving, double par2, boolean par3, double maxDistance) {
        super(par1EntityLiving, par2, par3);
        this.attacker = par1EntityLiving;
        this.maxDistance = maxDistance;
    }

    public boolean shouldExecute() {
        boolean execute = super.shouldExecute();
        if (execute && !this.isTargetNearby()) {
            execute = false;
        }
        return execute;
    }

    protected boolean isTargetNearby() {
        EntityLivingBase entityTarget = this.attacker != null ? this.attacker.getAttackTarget() : null;
        return entityTarget != null && this.attacker.getDistanceSqToEntity((Entity)entityTarget) <= this.maxDistance * this.maxDistance && this.attacker.getNavigator().getPathToEntityLiving((Entity)entityTarget) != null && (entityTarget.getHeldItem() == null || entityTarget.getHeldItem().getItem() != Witchery.Items.DEVILS_TONGUE_CHARM);
    }

    public boolean continueExecuting() {
        boolean execute = super.continueExecuting();
        if (execute && !this.isTargetNearby()) {
            execute = false;
        }
        return execute;
    }
}

