/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.Shapeshift;
import com.emoniph.witchery.entity.EntityVillagerWere;
import com.emoniph.witchery.entity.EntityWitchHunter;
import com.emoniph.witchery.util.CreatureUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityWolfman
extends EntityMob
implements IEntitySelector {
    private int formerProfession = -1;
    private int attackTimer;
    private boolean infectious;
    boolean isSitting;
    private MerchantRecipeList buyingList;
    private int wealth;
    public ItemStack itemInUse;
    public int itemInUseCount;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation skinOverride;

    public EntityWolfman(World world) {
        super(world);
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityWitchHunter.class, 1.0, true));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, (IEntitySelector)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
        this.setSize(0.6f, 1.8f);
        this.experienceValue = 20;
    }

    public boolean isEntityApplicable(Entity target) {
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            return !Shapeshift.INSTANCE.isAnimalForm(player);
        }
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(80.0);
    }

    protected void entityInit() {
        super.entityInit();
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(boolean p_70904_1_) {
        this.isSitting = p_70904_1_;
    }

    public int getTotalArmorValue() {
        int i = super.getTotalArmorValue() + 10;
        if (i > 20) {
            i = 20;
        }
        return i;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.wolfman.name");
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public void onLivingUpdate() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.worldObj.isRemote) {
            if (this.formerProfession != -1 && this.ticksExisted % 100 == 3 && !CreatureUtil.isFullMoon(this.worldObj) && !this.isPotionActive(Witchery.Potions.WOLFSBANE)) {
                EntityWolfman.convertToVillager((EntityLiving)this, this.formerProfession, this.infectious, this.wealth, this.buyingList);
            } else if (this.ticksExisted % 40 == 4 && this.isPotionActive(Potion.poison)) {
                this.removePotionEffect(Potion.poison.id);
            }
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (CreatureUtil.isSilverDamage(source)) {
            return super.attackEntityFrom(source, Math.min(damage * 1.5f, 15.0f));
        }
        return super.attackEntityFrom(source, Math.min(damage, 1.0f));
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = super.attackEntityAsMob(targetEntity);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 4;
    }

    protected String getLivingSound() {
        return this.worldObj.rand.nextInt(20) == 0 ? "witchery:mob.wolfman.howl" : "witchery:mob.wolfman.say";
    }

    protected String getHurtSound() {
        return "witchery:mob.wolfman.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.wolfman.death";
    }

    protected void dropFewItems(boolean p_70628_1_, int fortune) {
        super.dropFewItems(p_70628_1_, fortune);
    }

    protected Item getDropItem() {
        return Items.bone;
    }

    protected void dropRareDrop(int p_70600_1_) {
        switch (this.rand.nextInt(3)) {
            case 0: {
                this.entityDropItem(Witchery.Items.GENERIC.itemSilverDust.createStack(this.worldObj.rand.nextInt(3) + 1), 0.0f);
                break;
            }
            case 1: {
                this.dropItem(Items.bone, 1);
                break;
            }
            case 2: {
                this.dropItem(Items.leather, 1);
            }
        }
    }

    public void setFormerProfession(int profession, int wealth, MerchantRecipeList buyingList) {
        this.formerProfession = profession;
        this.buyingList = buyingList;
        this.wealth = wealth;
    }

    public int getFormerProfession() {
        return this.formerProfession;
    }

    public int getWealth() {
        return this.wealth;
    }

    public MerchantRecipeList getBuyingList() {
        return this.buyingList;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setInteger("FormerProfession", this.formerProfession);
        nbtRoot.setBoolean("Infectious", this.infectious);
        nbtRoot.setInteger("Riches", this.wealth);
        if (this.buyingList != null) {
            nbtRoot.setTag("Offers", (NBTBase)this.buyingList.getRecipiesAsTags());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.formerProfession = nbtRoot.getInteger("FormerProfession");
        this.infectious = nbtRoot.getBoolean("Infectious");
        this.wealth = nbtRoot.getInteger("Riches");
        if (nbtRoot.hasKey("Offers", 10)) {
            NBTTagCompound nbttagcompound1 = nbtRoot.getCompoundTag("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
    }

    public void setInfectious() {
        this.infectious = true;
    }

    public boolean isInfectious() {
        return this.infectious;
    }

    public void onKillEntity(EntityLivingBase targetEntity) {
        super.onKillEntity(targetEntity);
    }

    protected boolean canDespawn() {
        return false;
    }

    public static void convertToVillager(EntityLiving target, int profession, boolean infectious, int wealth, MerchantRecipeList buyingList) {
        if (target != null && !target.worldObj.isRemote) {
            EntityVillagerWere entity = new EntityVillagerWere(target.worldObj, profession, infectious);
            entity.copyLocationAndAnglesFrom((Entity)target);
            entity.setLookingForHome();
            entity.func_110163_bv();
            target.worldObj.removeEntity((Entity)target);
            target.worldObj.spawnEntityInWorld((Entity)entity);
            target.worldObj.playAuxSFXAtEntity(null, 1017, (int)target.posX, (int)target.posY, (int)target.posZ, 0);
        }
    }

    public static void convertToCuredVillager(EntityLiving target, int profession, int wealth, MerchantRecipeList buyingList) {
        if (target != null && !target.worldObj.isRemote) {
            EntityVillager entity = new EntityVillager(target.worldObj, profession);
            entity.copyLocationAndAnglesFrom((Entity)target);
            entity.setLookingForHome();
            entity.func_110163_bv();
            target.worldObj.removeEntity((Entity)target);
            target.worldObj.spawnEntityInWorld((Entity)entity);
            target.worldObj.playAuxSFXAtEntity(null, 1017, (int)target.posX, (int)target.posY, (int)target.posZ, 0);
        }
    }

    public void setItemInUse(ItemStack stack, int itemInUseCount) {
        this.itemInUse = stack;
        this.itemInUseCount = itemInUseCount;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSkinResource(ResourceLocation skinOverride) {
        this.skinOverride = skinOverride;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSkinResource() {
        return this.skinOverride;
    }
}

