/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityBolt;
import com.emoniph.witchery.entity.EntityVillageGuard;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.network.PacketSound;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.Village;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityWitchHunter
extends EntityCreature
implements IRangedAttackMob,
IEntitySelector {
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f);
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.2, false);
    private String targetPlayerName;
    private static final double HUNTER_NOTICE_CHANCE = 0.1;
    private static final long HUNTER_DELAY = TimeUtil.minsToTicks(2);
    private static final double HUNTER_TRIGGER_CHANCE = 0.01;

    public EntityWitchHunter(World par1World) {
        super(par1World);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, (IEntitySelector)this));
        this.experienceValue = 5;
        this.targetPlayerName = "";
        if (par1World != null && !par1World.isRemote) {
            this.setCombatTask();
        }
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.witchhunter.name");
    }

    public boolean isEntityApplicable(Entity entity) {
        if (CreatureUtil.isUndead(entity) || CreatureUtil.isDemonic(entity) || entity instanceof EntityWitch || CreatureUtil.isWerewolf(entity)) {
            return true;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            return CreatureUtil.isWitch(entity) || CreatureUtil.isWerewolf(entity) || CreatureUtil.isVampire(entity) || this.targetPlayerName != null && !this.targetPlayerName.isEmpty() && player.getCommandSenderName().equals(this.targetPlayerName);
        }
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(13, (Object)new Byte(0));
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "mob.villager.hit";
    }

    protected String getDeathSound() {
        return "mob.villager.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("step.grass", 0.15f, 1.0f);
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
        }
        if (flag = targetEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float f = this.getBrightness(1.0f);
        if (f > 0.5f) {
            this.entityAge += 2;
        }
        if (!this.worldObj.isRemote && this.ticksExisted % 20 == 2 && this.isPotionActive(Potion.poison)) {
            this.removePotionEffect(Potion.poison.id);
        }
        super.onLivingUpdate();
    }

    protected String getSwimSound() {
        return "game.hostile.swim";
    }

    protected String getSplashSound() {
        return "game.hostile.swim.splash";
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.ridingEntity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.ridingEntity;
            this.renderYawOffset = entitycreature.renderYawOffset;
        }
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        if (damageSource.getEntity() != null && (damageSource.getEntity() instanceof EntityVillageGuard || damageSource.getEntity() instanceof EntityWitchHunter)) {
            return false;
        }
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (super.attackEntityFrom(damageSource, Math.min(damage, 9.0f))) {
            Entity entity = damageSource.getEntity();
            if (this.riddenByEntity != entity && this.ridingEntity != entity) {
                if (entity != this) {
                    this.entityToAttack = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected String func_146067_o(int distance) {
        return distance > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    protected void dropFewItems(boolean par1, int par2) {
        int j = this.rand.nextInt(3 + par2);
        for (int k = 0; k < j; ++k) {
            this.entityDropItem(Witchery.Items.GENERIC.itemBoltStake.createStack(), 0.0f);
        }
    }

    protected void dropRareDrop(int par1) {
        this.entityDropItem(Witchery.Items.GENERIC.itemBoltAntiMagic.createStack(2), 0.0f);
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.onSpawnWithEgg(par1EntityLivingData);
        this.setHunterType(this.worldObj.rand.nextInt(3));
        this.setCurrentItemOrArmor(0, new ItemStack(Witchery.Items.CROSSBOW_PISTOL));
        this.enchantEquipment();
        return par1EntityLivingData;
    }

    public void setCombatTask() {
        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.getHeldItem();
        if (itemstack != null && itemstack.getItem() == Witchery.Items.CROSSBOW_PISTOL) {
            this.tasks.addTask(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.tasks.addTask(4, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLivingBase, float par2) {
        EntityBolt entityarrow = new EntityBolt(this.worldObj, (EntityLivingBase)this, par1EntityLivingBase, 1.6f, 14 - this.worldObj.difficultySetting.getDifficultyId() * 4);
        int i = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)this.getHeldItem());
        int j = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)this.getHeldItem());
        entityarrow.setDamage((double)(par2 * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.worldObj.difficultySetting.getDifficultyId() * 0.11f));
        if (i > 0) {
            entityarrow.setDamage(entityarrow.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.setKnockbackStrength(j);
        }
        if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)this.getHeldItem()) > 0 || CreatureUtil.isVampire((Entity)this.getAttackTarget()) && this.worldObj.rand.nextInt(3) == 0) {
            entityarrow.setFire(100);
        }
        if (this.getAttackTarget() != null) {
            if (CreatureUtil.isWerewolf((Entity)this.getAttackTarget())) {
                entityarrow.setBoltType(4);
            } else if (CreatureUtil.isUndead((Entity)this.getAttackTarget())) {
                entityarrow.setBoltType(3);
            } else if (this.worldObj.rand.nextInt(4) == 0) {
                entityarrow.setBoltType(2);
            }
        }
        this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.worldObj.spawnEntityInWorld((Entity)entityarrow);
    }

    public int getHunterType() {
        return this.dataWatcher.getWatchableObjectByte(13);
    }

    public void setHunterType(int par1) {
        this.dataWatcher.updateObject(13, (Object)((byte)par1));
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("HunterType")) {
            byte b0 = nbtRoot.getByte("HunterType");
            this.setHunterType(b0);
        }
        this.targetPlayerName = nbtRoot.getString("HunterTarget");
        this.setCombatTask();
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("HunterType", (byte)this.getHunterType());
        nbtRoot.setString("HunterTarget", this.targetPlayerName);
    }

    public void setCurrentItemOrArmor(int slot, ItemStack stack) {
        super.setCurrentItemOrArmor(slot, stack);
        if (!this.worldObj.isRemote && slot == 0) {
            this.setCombatTask();
        }
    }

    public double getYOffset() {
        return super.getYOffset() - 0.5;
    }

    public static void blackMagicPerformed(EntityPlayer player) {
        NBTTagCompound nbtPlayer;
        if (player != null && player.worldObj != null && !player.worldObj.isRemote && (nbtPlayer = Infusion.getNBT((Entity)player)) != null && nbtPlayer.getLong("WITCHunterTrigger") <= 0L && player.worldObj.rand.nextDouble() < 0.1) {
            long totalWorldTicks = TimeUtil.getServerTimeInTicks();
            nbtPlayer.setLong("WITCHunterTrigger", totalWorldTicks);
        }
    }

    public static void handleWitchHunterEffects(EntityPlayer player, long totalWorldTicks) {
        long triggerTimeTicks;
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        if (nbtPlayer != null && ((triggerTimeTicks = nbtPlayer.getLong("WITCHunterTrigger")) > 0L && totalWorldTicks >= triggerTimeTicks + HUNTER_DELAY && player.worldObj.rand.nextDouble() < 0.01 || EntityWitchHunter.isVampireActive(player, totalWorldTicks))) {
            nbtPlayer.removeTag("WITCHunterTrigger");
            int MAX_SPAWNS = 2;
            int tries = 3;
            int spawned = 0;
            for (int i = 0; i < 3 && spawned < 2; ++i) {
                EntityWitchHunter creature = (EntityWitchHunter)Infusion.spawnCreature(player.worldObj, EntityWitchHunter.class, MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), (EntityLivingBase)player, 3, 8, ParticleEffect.SMOKE, null);
                if (creature == null) continue;
                ++spawned;
                creature.targetPlayerName = player.getCommandSenderName();
                creature.onSpawnWithEgg(null);
                EntityUtil.setTarget((EntityLiving)creature, (EntityLivingBase)player);
            }
            if (spawned > 0) {
                Witchery.packetPipeline.sendTo((IMessage)new PacketSound(SoundEffect.WITCHERY_RANDOM_THEYCOME, (Entity)player, 1.0f, 1.0f), player);
            }
        }
    }

    private static boolean isVampireActive(EntityPlayer player, long totalWorldTicks) {
        Village village;
        if (Config.instance().vampireHunterSpawnChance <= 0.0 || player.capabilities.isCreativeMode) {
            return false;
        }
        ExtendedPlayer playerEx = ExtendedPlayer.get(player);
        if (playerEx.getVampireLevel() < 10) {
            return false;
        }
        if (player.worldObj.rand.nextDouble() < Config.instance().vampireHunterSpawnChance && (village = player.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), 128)) != null && village.getReputationForPlayer(player.getCommandSenderName()) < -1) {
            List hunters = player.worldObj.getEntitiesWithinAABB(EntityWitchHunter.class, player.boundingBox.expand(64.0, 16.0, 64.0));
            return hunters == null || hunters.size() == 0;
        }
        return false;
    }

    protected void attackEntity(Entity p_70785_1_, float p_70785_2_) {
        if (this.attackTime <= 0 && p_70785_2_ < 2.0f && p_70785_1_.boundingBox.maxY > this.boundingBox.minY && p_70785_1_.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(p_70785_1_);
        }
    }

    public float getBlockPathWeight(int p_70783_1_, int p_70783_2_, int p_70783_3_) {
        return 0.5f - this.worldObj.getLightBrightness(p_70783_1_, p_70783_2_, p_70783_3_);
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, i, j = MathHelper.floor_double((double)this.boundingBox.minY), k = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.getBlockLightValue(i, j, k);
        if (this.worldObj.isThundering()) {
            int i1 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            l = this.worldObj.getBlockLightValue(i, j, k);
            this.worldObj.skylightSubtracted = i1;
        }
        return l <= this.rand.nextInt(8);
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.getCanSpawnHere();
    }

    protected boolean func_146066_aG() {
        return true;
    }
}

