/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityFlyingTameable;
import com.emoniph.witchery.entity.ai.EntityAIFlyerAttackOnCollide;
import com.emoniph.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import com.emoniph.witchery.entity.ai.EntityAIFlyerFollowOwner;
import com.emoniph.witchery.entity.ai.EntityAIFlyerLand;
import com.emoniph.witchery.entity.ai.EntityAIFlyerMate;
import com.emoniph.witchery.entity.ai.EntityAIFlyerWander;
import com.emoniph.witchery.entity.ai.EntityAIFlyingTempt;
import com.emoniph.witchery.entity.ai.EntityAISitAndStay;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import com.emoniph.witchery.util.Waypoint;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityWingedMonkey
extends EntityFlyingTameable {
    private int attackTimer;
    public EntityAIFlyingTempt aiTempt;
    private int timeToLive = -1;
    private static final ItemStack[] TEMPTATIONS = new ItemStack[]{new ItemStack(Items.porkchop), new ItemStack(Items.beef)};

    public EntityWingedMonkey(World world) {
        super(world);
        this.setSize(0.6f, 0.8f);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.ENTITY_LIVING));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFlyerAttackOnCollide((EntityCreature)this, 1.0, true));
        this.aiTempt = new EntityAIFlyingTempt((EntityCreature)this, 0.6, TEMPTATIONS, true);
        this.tasks.addTask(4, (EntityAIBase)this.aiTempt);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIFlyerFollowOwner(this, 1.0, 14.0f, 5.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIFlyerMate((EntityAnimal)this, 0.8));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, 0.8, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 0.8, 10.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + 5;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("FeatherColor", (byte)this.getFeatherColor());
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("FeatherColor")) {
            this.setFeatherColor(nbtRoot.getByte("FeatherColor"));
        }
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
    }

    public void onUpdate() {
        super.onUpdate();
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(21, (Object)((byte)(this.worldObj.rand.nextInt(100) == 0 ? 0 : this.worldObj.rand.nextInt(15) + 1)));
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.3f);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void updateAITick() {
        this.getNavigator().clearPathEntity();
        super.updateAITick();
        if (!(this.worldObj == null || this.isDead || this.worldObj.isRemote || this.timeToLive == -1 || --this.timeToLive != 0 && this.getAttackTarget() != null && !this.getAttackTarget().isDead)) {
            ParticleEffect.EXPLODE.send(SoundEffect.NONE, (Entity)this, 1.0, 1.0, 16);
            this.setDead();
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (!this.isTemp()) {
            int var3 = this.rand.nextInt(3) + this.rand.nextInt(1 + par2);
            for (int var4 = 0; var4 < var3; ++var4) {
                this.entityDropItem(new ItemStack(Items.feather), 0.0f);
            }
        }
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    protected String getLivingSound() {
        return "witchery:mob.monkey.say";
    }

    protected String getHurtSound() {
        return "witchery:mob.monkey.hit";
    }

    protected String getDeathSound() {
        return "witchery:mob.monkey.death";
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 2.0f);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        this.setSitting(false);
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public double getMountedYOffset() {
        return this.riddenByEntity != null ? (double)(-this.riddenByEntity.height) * 0.6 : 0.0;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean interact(EntityPlayer player) {
        if (this.isTemp()) {
            return true;
        }
        ItemStack itemstack = player.inventory.getCurrentItem();
        if (this.isTamed()) {
            if (TameableUtil.isOwner(this, player) && !this.isBreedingItem(itemstack)) {
                if (itemstack != null && itemstack.getItem() == Items.dye) {
                    if (!this.worldObj.isRemote) {
                        int i = BlockColored.func_150032_b((int)itemstack.getItemDamage());
                        this.setFeatherColor(i);
                        if (!player.capabilities.isCreativeMode) {
                            --itemstack.stackSize;
                        }
                        if (itemstack.stackSize <= 0) {
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
                        }
                    }
                } else {
                    if (itemstack != null && (itemstack.getItem() == Items.name_tag || itemstack.getItem() == Witchery.Items.POLYNESIA_CHARM || itemstack.getItem() == Witchery.Items.DEVILS_TONGUE_CHARM)) {
                        return false;
                    }
                    if (Witchery.Items.GENERIC.itemWaystonePlayerBound.isMatch(itemstack) || Witchery.Items.GENERIC.itemWaystoneBound.isMatch(itemstack)) {
                        this.waypoint = itemstack.copy();
                        this.homeX = 0.0;
                        this.homeY = 0.0;
                        this.homeZ = 0.0;
                        Waypoint wp = this.getWaypoint();
                        this.homeX = wp.X;
                        this.homeY = wp.Y;
                        this.homeZ = wp.Z;
                        Witchery.Items.GENERIC.bindToLocation(this.worldObj, (int)this.posX, (int)this.posY, (int)this.posZ, this.worldObj.provider.dimensionId, this.worldObj.provider.getDimensionName(), this.waypoint);
                        if (!this.worldObj.isRemote && this.isSitting()) {
                            this.setSitting(false);
                        }
                        player.mountEntity((Entity)this);
                        ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_ORB, (Entity)this, 1.0, 1.0, 16);
                    } else if (itemstack != null && Witchery.Items.TAGLOCK_KIT.isTaglockPresent(itemstack, 1)) {
                        this.waypoint = itemstack.copy();
                        this.homeX = this.posX;
                        this.homeY = this.posY;
                        this.homeZ = this.posZ;
                        ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_ORB, (Entity)this, 1.0, 1.0, 16);
                        if (!player.capabilities.isCreativeMode) {
                            --itemstack.stackSize;
                        }
                    } else if (this.getDistanceSqToEntity((Entity)player) < 9.0 && !this.worldObj.isRemote) {
                        this.setSitting(!this.isSitting());
                    }
                }
                return true;
            }
            if (TameableUtil.isOwner(this, player) && this.isBreedingItem(itemstack) && this.getHealth() < this.getMaxHealth()) {
                if (!this.worldObj.isRemote) {
                    this.heal(10.0f);
                    if (!player.capabilities.isCreativeMode) {
                        --itemstack.stackSize;
                    }
                    if (itemstack.stackSize <= 0) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
                    }
                }
                return true;
            }
            return super.interact(player);
        }
        if (itemstack != null && (itemstack.getItem() == Items.porkchop || itemstack.getItem() == Items.beef) && player.getDistanceSqToEntity((Entity)this) < 9.0) {
            if (!player.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            if (itemstack.stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
            }
            if (!this.worldObj.isRemote) {
                if (this.rand.nextInt(3) == 0) {
                    this.setTamed(true);
                    this.setTameSkin(1 + this.worldObj.rand.nextInt(3));
                    TameableUtil.setOwner(this, player);
                    this.func_110163_bv();
                    this.playTameEffect(true);
                    this.setSitting(true);
                    this.worldObj.setEntityState((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.worldObj.setEntityState((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (!this.isBreedingItem(itemstack)) {
            return super.interact(player);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIcon(ItemStack stack, int pass) {
        return stack.getItem().requiresMultipleRenderPasses() ? stack.getItem().getIcon(stack, pass) : stack.getIconIndex();
    }

    public EntityWingedMonkey spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        EntityWingedMonkey entityocelot = new EntityWingedMonkey(this.worldObj);
        if (this.isTamed()) {
            entityocelot.func_110163_bv();
            entityocelot.setTameSkin(this.getTameSkin());
            entityocelot.setFeatherColor(this.getFeatherColor());
        }
        return entityocelot;
    }

    public boolean isBreedingItem(ItemStack itemstack) {
        return itemstack != null && (itemstack.getItem() == Items.porkchop || itemstack.getItem() == Items.beef);
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityWingedMonkey)) {
            return false;
        }
        EntityWingedMonkey entityocelot = (EntityWingedMonkey)par1EntityAnimal;
        return !entityocelot.isTamed() ? false : this.isInLove() && entityocelot.isInLove();
    }

    public int getFeatherColor() {
        return this.dataWatcher.getWatchableObjectByte(21) & 0xF;
    }

    public void setFeatherColor(int par1) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        this.dataWatcher.updateObject(21, (Object)((byte)(b0 & 0xF0 | par1 & 0xF)));
    }

    public int getTameSkin() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setTameSkin(int par1) {
        this.dataWatcher.updateObject(18, (Object)((byte)par1));
    }

    public boolean getCanSpawnHere() {
        if (this.worldObj.rand.nextInt(3) == 0) {
            return false;
        }
        if (this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox)) {
            int i = MathHelper.floor_double((double)this.posX);
            int j = MathHelper.floor_double((double)this.boundingBox.minY);
            int k = MathHelper.floor_double((double)this.posZ);
            if (j < 63) {
                return false;
            }
            Block block = this.worldObj.getBlock(i, j - 1, k);
            if (block == Blocks.grass || block != null && block.isLeaves((IBlockAccess)this.worldObj, i, j - 1, k)) {
                return true;
            }
        }
        return false;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.wingedmonkey.name");
    }

    public EntityAgeable createChild(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }
}

