/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityWolfman;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityVillagerWere
extends EntityVillager {
    private boolean infectious;

    public EntityVillagerWere(World world) {
        this(world, 0, false);
    }

    public EntityVillagerWere(World world, int profession, boolean infectious) {
        super(world, profession);
        this.infectious = infectious;
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setBoolean("Infectious", this.infectious);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.infectious = nbtRoot.getBoolean("Infectious");
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.worldObj.isRemote && this.ticksExisted % 100 == 3 && !this.isChild() && CreatureUtil.isFullMoon(this.worldObj) && !this.isPotionActive(Witchery.Potions.WOLFSBANE)) {
            this.convertToWolfman();
        }
    }

    protected void convertToWolfman() {
        EntityWolfman entity = new EntityWolfman(this.worldObj);
        if (this.infectious) {
            entity.setInfectious();
        }
        entity.setFormerProfession(this.getProfession(), this.wealth, this.buyingList);
        entity.func_110163_bv();
        entity.copyLocationAndAnglesFrom((Entity)this);
        entity.onSpawnWithEgg(null);
        this.worldObj.removeEntity((Entity)this);
        this.worldObj.spawnEntityInWorld((Entity)entity);
        this.worldObj.playAuxSFXAtEntity(null, 1017, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
        SoundEffect.WITCHERY_MOB_WOLFMAN_HOWL.playAt(this.worldObj, this.posX, this.posY, this.posZ);
    }
}

