/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBloodCrucible;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.ExtendedVillager;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.Village;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityVampire
extends EntityCreature
implements IEntitySelector,
IHandleDT {
    private Village villageObj;
    private ChunkCoordinates coffinPos = new ChunkCoordinates(0, 0, 0);
    float damageDone = 0.0f;

    public EntityVampire(World world) {
        super(world);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.2, false));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 0, false, true, (IEntitySelector)this));
        this.experienceValue = 20;
    }

    public boolean isEntityApplicable(Entity entity) {
        return entity instanceof EntityVillager && this.villageObj != null || entity instanceof EntityPlayer && !ExtendedPlayer.get((EntityPlayer)entity).isVampire();
    }

    protected void updateAITick() {
        super.updateAITick();
        if (!this.worldObj.isRemote) {
            if (this.worldObj.isDaytime()) {
                if (this.getAITarget() == null) {
                    this.setAttackTarget(null);
                }
                if (this.ticksExisted % 100 == 2) {
                    this.villageObj = null;
                    this.damageDone = 0.0f;
                    if (this.getDistanceSq(this.coffinPos.posX, this.coffinPos.posY, this.coffinPos.posZ) > 16.0) {
                        ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)this, 0.8, 1.5, 16);
                        EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, this.coffinPos.posX, this.coffinPos.posY, this.coffinPos.posZ, 8);
                        ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)this, 0.8, 1.5, 16);
                        this.setHomeArea(this.coffinPos.posX, this.coffinPos.posY, this.coffinPos.posZ, 4);
                    }
                }
                if (this.ticksExisted % 20 == 2 && CreatureUtil.isInSunlight((EntityLivingBase)this)) {
                    this.setFire(2);
                }
            } else if (this.damageDone >= 20.0f) {
                if (this.villageObj != null) {
                    this.setAttackTarget(null);
                    this.setRevengeTarget(null);
                    this.villageObj = null;
                    ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)this, 0.8, 1.5, 16);
                    EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, this.coffinPos.posX, this.coffinPos.posY, this.coffinPos.posZ, 8);
                    ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)this, 0.8, 1.5, 16);
                    this.setHomeArea(this.coffinPos.posX, this.coffinPos.posY, this.coffinPos.posZ, 4);
                    this.tryFillBloodCrucible();
                }
            } else if (this.villageObj == null && this.ticksExisted % 500 == 2) {
                this.villageObj = this.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), 128);
                if (this.villageObj != null) {
                    ChunkCoordinates townPos = this.villageObj.getCenter();
                    ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)this, 0.8, 1.5, 16);
                    EntityUtil.moveToBlockPositionAndUpdate((EntityLiving)this, townPos.posX, townPos.posY, townPos.posZ, 8);
                    ParticleEffect.SMOKE.send(SoundEffect.WITCHERY_RANDOM_POOF, (Entity)this, 0.8, 1.5, 16);
                    this.setHomeArea(townPos.posX, townPos.posY, townPos.posZ, this.villageObj.getVillageRadius());
                }
            }
        }
    }

    public void tryFillBloodCrucible() {
        int r = 6;
        for (int x = this.coffinPos.posX - 6; x <= this.coffinPos.posX + 6; ++x) {
            for (int z = this.coffinPos.posZ - 6; z <= this.coffinPos.posZ + 6; ++z) {
                for (int y = this.coffinPos.posY - 6; y <= this.coffinPos.posY + 6; ++y) {
                    if (this.worldObj.getBlock(x, y, z) != Witchery.Blocks.BLOOD_CRUCIBLE) continue;
                    BlockBloodCrucible.TileEntityBloodCrucible crucible = BlockUtil.getTileEntity((IBlockAccess)this.worldObj, x, y, z, BlockBloodCrucible.TileEntityBloodCrucible.class);
                    if (crucible != null) {
                        crucible.increaseBloodLevel();
                    }
                    return;
                }
            }
        }
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void setStalkingArea(int p_110171_1_, int p_110171_2_, int p_110171_3_) {
        this.coffinPos.set(p_110171_1_, p_110171_2_, p_110171_3_);
    }

    protected String getSwimSound() {
        return "game.hostile.swim";
    }

    protected String getSplashSound() {
        return "game.hostile.swim.splash";
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(13, (Object)new Byte(0));
        this.dataWatcher.addObject(14, (Object)new Integer(500));
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected String getLivingSound() {
        return "mob.villager.idle";
    }

    protected String getHurtSound() {
        return "mob.villager.hit";
    }

    protected String getDeathSound() {
        return "mob.villager.death";
    }

    protected float getSoundPitch() {
        return 0.6f;
    }

    public void onLivingUpdate() {
        this.updateArmSwingProgress();
        float f = this.getBrightness(1.0f);
        if (f > 0.5f) {
            this.entityAge += 2;
        }
        super.onLivingUpdate();
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (entity instanceof EntityVillager) {
            ExtendedVillager villagerEx = ExtendedVillager.get((EntityVillager)entity);
            if (villagerEx != null && this.worldObj.rand.nextInt(10) == 0) {
                this.damageDone += 4.0f;
                int taken = villagerEx.takeBlood(30, (EntityLivingBase)this);
                if (taken > 0) {
                    this.heal(4.0f);
                    ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, this.worldObj, entity.posX, entity.posY + (double)entity.height * 0.8, entity.posZ, 0.5, 0.2, 16);
                }
            }
            flag = true;
        } else {
            boolean needsBlood = this.damageDone < 20.0f;
            flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f);
            if (flag) {
                int j;
                if (i > 0) {
                    entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                    this.motionX *= 0.6;
                    this.motionZ *= 0.6;
                }
                if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                    entity.setFire(j * 4);
                }
                if (entity instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
                }
                EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
            }
        }
        return flag;
    }

    protected void attackEntity(Entity p_70785_1_, float p_70785_2_) {
        if (this.attackTime <= 0 && p_70785_2_ < 2.0f && p_70785_1_.boundingBox.maxY > this.boundingBox.minY && p_70785_1_.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(p_70785_1_);
        }
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    public void updateRidden() {
        super.updateRidden();
        if (this.ridingEntity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.ridingEntity;
            this.renderYawOffset = entitycreature.renderYawOffset;
        }
    }

    protected String func_146067_o(int p_146067_1_) {
        return p_146067_1_ > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        return super.attackEntityFrom(source, damage);
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 0.0f;
    }

    public void onDeath(DamageSource source) {
        if (!CreatureUtil.checkForVampireDeath((EntityLivingBase)this, source)) {
            return;
        }
        super.onDeath(source);
    }

    protected Item getDropItem() {
        return Items.shears;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void dropRareDrop(int p_70600_1_) {
    }

    protected void addRandomArmor() {
        this.setCurrentItemOrArmor(1, new ItemStack((Item)Witchery.Items.VAMPIRE_BOOTS));
        boolean male = this.worldObj.rand.nextBoolean();
        if (male) {
            this.setCurrentItemOrArmor(2, new ItemStack((Item)(this.worldObj.rand.nextInt(3) == 0 ? Witchery.Items.VAMPIRE_LEGS_KILT : Witchery.Items.VAMPIRE_LEGS)));
            this.setCurrentItemOrArmor(3, new ItemStack((Item)(this.worldObj.rand.nextInt(3) == 0 ? Witchery.Items.VAMPIRE_COAT_CHAIN : Witchery.Items.VAMPIRE_COAT)));
        } else {
            this.setCurrentItemOrArmor(2, new ItemStack((Item)(this.worldObj.rand.nextInt(4) != 0 ? Witchery.Items.VAMPIRE_LEGS_KILT : Witchery.Items.VAMPIRE_LEGS)));
            this.setCurrentItemOrArmor(3, new ItemStack((Item)(this.worldObj.rand.nextInt(3) == 0 ? Witchery.Items.VAMPIRE_COAT_FEMALE_CHAIN : Witchery.Items.VAMPIRE_COAT_FEMALE)));
        }
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.vampire.name");
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.onSpawnWithEgg(p_110161_1_);
        this.addRandomArmor();
        this.coffinPos.set((int)this.posX, (int)this.posY, (int)this.posZ);
        return p_110161_1_;
    }

    public int getGuardType() {
        return this.dataWatcher.getWatchableObjectByte(13);
    }

    public void setGuardType(int p_82201_1_) {
        this.dataWatcher.updateObject(13, (Object)((byte)p_82201_1_));
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("GuardType", 99)) {
            byte b0 = nbtRoot.getByte("GuardType");
            this.setGuardType(b0);
        }
        this.coffinPos.set(nbtRoot.getInteger("BaseX"), nbtRoot.getInteger("BaseY"), nbtRoot.getInteger("BaseZ"));
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setByte("GuardType", (byte)this.getGuardType());
        ChunkCoordinates home = this.getHomePosition();
        nbtRoot.setInteger("BaseX", this.coffinPos.posX);
        nbtRoot.setInteger("BaseY", this.coffinPos.posY);
        nbtRoot.setInteger("BaseZ", this.coffinPos.posZ);
    }

    public void setCurrentItemOrArmor(int p_70062_1_, ItemStack p_70062_2_) {
        super.setCurrentItemOrArmor(p_70062_1_, p_70062_2_);
    }

    public double getYOffset() {
        return super.getYOffset() - 0.5;
    }
}

