/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityCorpse;
import com.emoniph.witchery.entity.EntityCovenWitch;
import com.emoniph.witchery.entity.EntityEnt;
import com.emoniph.witchery.entity.EntityFlyingTameable;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.entity.EntityHornedHuntsman;
import com.emoniph.witchery.entity.ai.EntityAITreefydWander;
import com.emoniph.witchery.familiar.IFamiliar;
import com.emoniph.witchery.item.ItemTaglockKit;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityTreefyd
extends EntityMob
implements IEntitySelector {
    public CreatureID testID = new CreatureID(new UUID(0L, 0L), "");
    private static ArrayList<String> groupables = null;
    private ArrayList<String> knownPlayers = new ArrayList();
    private ArrayList<String> knownCreatureTypes = new ArrayList();
    private ArrayList<CreatureID> knownCreatures = new ArrayList();

    public EntityTreefyd(World par1World) {
        super(par1World);
        this.setSize(0.4f, 1.8f);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.tasks.addTask(5, (EntityAIBase)new EntityAITreefydWander(this, 0.8));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, (IEntitySelector)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    public boolean isEntityApplicable(Entity entity) {
        if (entity.getClass() == ((Object)((Object)this)).getClass() || entity instanceof EntityHornedHuntsman || entity instanceof EntityEnt || entity instanceof EntityFlying || entity instanceof EntityFlyingTameable || entity instanceof EntityAmbientCreature || entity instanceof EntityWaterMob || this.isFamiliar(entity) || entity instanceof EntityCovenWitch || entity instanceof EntityCorpse) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            String ownerName = this.getOwnerName();
            if (ownerName != null && !ownerName.isEmpty() && player.getCommandSenderName().equals(ownerName)) {
                return false;
            }
            if (this.knownPlayers != null && this.knownPlayers.contains(player.getCommandSenderName())) {
                return false;
            }
        }
        if (entity instanceof EntityLiving) {
            EntityLiving creature = (EntityLiving)entity;
            if (this.knownCreatureTypes != null && this.knownCreatureTypes.contains(creature.getCommandSenderName())) {
                return false;
            }
            this.testID.id = entity.getUniqueID();
            if (this.knownCreatures != null && this.knownCreatures.contains(this.testID)) {
                return false;
            }
        }
        return true;
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean interact(EntityPlayer player) {
        block33: {
            block35: {
                block34: {
                    if (this.worldObj.isRemote || player == null || !player.getCommandSenderName().equals(this.getOwnerName())) break block33;
                    stack = player.getHeldItem();
                    if (stack == null || stack.getItem() != Witchery.Items.TAGLOCK_KIT) break block34;
                    this.setAttackTarget(null);
                    boundEntityType = Witchery.Items.TAGLOCK_KIT.getBoundEntityType(stack, 1);
                    switch (1.$SwitchMap$com$emoniph$witchery$item$ItemTaglockKit$BoundType[boundEntityType.ordinal()]) {
                        case 1: {
                            otherUsername = Witchery.Items.TAGLOCK_KIT.getBoundUsername(stack, 1);
                            if (player.getCommandSenderName().equals(otherUsername)) break;
                            if (!player.isSneaking() && !this.knownPlayers.contains(otherUsername)) {
                                this.knownPlayers.add(otherUsername);
                            } else if (player.isSneaking() && this.knownPlayers.contains(otherUsername)) {
                                this.knownPlayers.remove(otherUsername);
                            } else {
                                this.showCurrentKnownEntities(player);
                                return super.interact(player);
                            }
                            --stack.stackSize;
                            if (stack.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                            }
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                            this.showCurrentKnownEntities(player);
                            return true;
                        }
                        case 2: {
                            otherCreature = Witchery.Items.TAGLOCK_KIT.getBoundCreatureID(stack, 1);
                            creatureName = Witchery.Items.TAGLOCK_KIT.getBoundEntityDisplayName(stack, 1);
                            if (otherCreature.equals(this.getUniqueID())) ** GOTO lbl58
                            if (!this.isGroupableCreature(otherCreature, creatureName)) ** GOTO lbl42
                            if (!player.isSneaking() && !this.knownCreatureTypes.contains(creatureName)) {
                                this.knownCreatureTypes.add(creatureName);
                            } else if (player.isSneaking() && this.knownCreatureTypes.contains(creatureName)) {
                                this.knownCreatureTypes.remove(creatureName);
                            } else {
                                this.showCurrentKnownEntities(player);
                                return super.interact(player);
lbl42:
                                // 1 sources

                                creatureID = new CreatureID(otherCreature, creatureName);
                                if (!player.isSneaking() && !this.knownCreatures.contains(creatureID)) {
                                    this.knownCreatures.add(creatureID);
                                } else if (player.isSneaking() && this.knownCreatures.contains(creatureID)) {
                                    this.knownCreatures.remove(creatureID);
                                } else {
                                    this.showCurrentKnownEntities(player);
                                    return super.interact(player);
                                }
                            }
                            --stack.stackSize;
                            if (stack.stackSize <= 0) {
                                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                            }
                            if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
lbl58:
                            // 4 sources

                            this.showCurrentKnownEntities(player);
                            return true;
                        }
                    }
                    break block35;
                }
                if (stack != null && Witchery.Items.GENERIC.itemSeedsTreefyd.isMatch(stack)) {
                    if (!this.worldObj.isRemote) {
                        entity = new EntityTreefyd(this.worldObj);
                        entity.setLocationAndAngles(0.5 + this.posX, this.posY, 0.5 + this.posZ, 0.0f, 0.0f);
                        entity.onSpawnWithEgg(null);
                        entity.setOwner(player.getCommandSenderName());
                        entity.func_110163_bv();
                        entity.knownPlayers = (ArrayList)this.knownPlayers.clone();
                        entity.knownCreatureTypes = (ArrayList)this.knownCreatureTypes.clone();
                        entity.knownCreatures = (ArrayList)this.knownCreatures.clone();
                        this.worldObj.spawnEntityInWorld((Entity)entity);
                        ParticleEffect.SLIME.send(SoundEffect.MOB_SILVERFISH_KILL, (Entity)this, 1.0, 2.0, 16);
                        ParticleEffect.EXPLODE.send(SoundEffect.NONE, (Entity)this, 1.0, 2.0, 16);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                } else if (stack != null && Witchery.Items.GENERIC.itemCreeperHeart.isMatch(stack)) {
                    if (!this.worldObj.isRemote) {
                        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
                        this.setHealth(this.getMaxHealth());
                        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
                        ParticleEffect.SLIME.send(SoundEffect.MOB_SILVERFISH_KILL, (Entity)this, 0.5, 2.0, 16);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                } else if (stack != null && Witchery.Items.GENERIC.itemDemonHeart.isMatch(stack)) {
                    if (!this.worldObj.isRemote) {
                        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(150.0);
                        this.setHealth(this.getMaxHealth());
                        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
                        ParticleEffect.FLAME.send(SoundEffect.MOB_ENDERDRAGON_GROWL, (Entity)this, 0.5, 2.0, 16);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        --stack.stackSize;
                    }
                } else if (stack != null && stack.getItem() == Witchery.Items.BOLINE && !this.worldObj.isRemote) {
                    this.setSentinal(this.isSentinal() == false);
                }
            }
            this.showCurrentKnownEntities(player);
        }
        return super.interact(player);
    }

    private boolean isGroupableCreature(UUID otherCreature, String creatureName) {
        if (groupables == null) {
            groupables = new ArrayList();
            this.addGroupableType(EntityVillager.class);
            this.addGroupableType(EntityGoblin.class);
            this.addGroupableType(EntitySheep.class);
            this.addGroupableType(EntityCow.class);
            this.addGroupableType(EntityMooshroom.class);
            this.addGroupableType(EntityChicken.class);
            this.addGroupableType(EntityPig.class);
            this.addGroupableType(EntityHorse.class);
        }
        return groupables.contains(creatureName);
    }

    private void addGroupableType(Class<? extends EntityLiving> className) {
        String name = (String)EntityList.classToStringMapping.get(className);
        if (name != null) {
            String localName = StatCollector.translateToLocal((String)("entity." + name + ".name"));
            groupables.add(localName);
        }
    }

    private void showCurrentKnownEntities(EntityPlayer player) {
        StringBuffer sb = new StringBuffer();
        String ownerName = this.getOwnerName();
        if (ownerName != null && !ownerName.isEmpty()) {
            sb.append(this.getOwnerName());
        }
        for (String s : this.knownPlayers) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        for (String s : this.knownCreatureTypes) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("#");
            sb.append(s);
        }
        for (CreatureID cid : this.knownCreatures) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(cid.toString());
        }
        String message = this.getCommandSenderName() + " (" + sb.toString() + ")";
        ChatUtil.sendPlain((ICommandSender)player, message);
    }

    private boolean isFamiliar(Entity entity) {
        if (entity instanceof IFamiliar) {
            IFamiliar familiar = (IFamiliar)entity;
            return familiar.isFamiliar();
        }
        return false;
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.treefyd.name");
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(50.0);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public boolean attackEntityAsMob(Entity entity) {
        EntityPlayer player;
        if (!this.worldObj.isRemote && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).isPotionActive(Potion.blindness)) {
            player.addPotionEffect(new PotionEffect(Potion.blindness.id, 100, 0));
        }
        return super.attackEntityAsMob(entity);
    }

    public int getMaxSafePointTries() {
        return this.getAttackTarget() == null ? 3 : 3 + (int)(this.getHealth() - 1.0f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(18, (Object)0);
    }

    public boolean isSentinal() {
        return this.dataWatcher.getWatchableObjectInt(18) == 1;
    }

    protected void setSentinal(boolean screaming) {
        this.dataWatcher.updateObject(18, (Object)(screaming ? 1 : 0));
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.getOwnerName() == null) {
            nbtRoot.setString("Owner", "");
        } else {
            nbtRoot.setString("Owner", this.getOwnerName());
        }
        if (this.knownPlayers.size() > 0) {
            NBTTagList nbtPlayers = new NBTTagList();
            for (String playerName : this.knownPlayers) {
                NBTTagCompound nbtKnownPlayer = new NBTTagCompound();
                nbtKnownPlayer.setString("PlayerName", playerName);
                nbtPlayers.appendTag((NBTBase)nbtKnownPlayer);
            }
            nbtRoot.setTag("KnownPlayers", (NBTBase)nbtPlayers);
        }
        if (this.knownCreatureTypes.size() > 0) {
            NBTTagList nbtCreatureTypes = new NBTTagList();
            for (String typeName : this.knownCreatureTypes) {
                NBTTagCompound nbtKnownCreatureType = new NBTTagCompound();
                nbtKnownCreatureType.setString("CreatureTypeName", typeName);
                nbtCreatureTypes.appendTag((NBTBase)nbtKnownCreatureType);
            }
            nbtRoot.setTag("KnownCreatureTypes", (NBTBase)nbtCreatureTypes);
        }
        if (this.knownCreatures.size() > 0) {
            NBTTagList nbtCreatures = new NBTTagList();
            for (CreatureID creatureID : this.knownCreatures) {
                NBTTagCompound nbtKnownCreature = new NBTTagCompound();
                nbtKnownCreature.setLong("CreatureMost", creatureID.id.getMostSignificantBits());
                nbtKnownCreature.setLong("CreatureLeast", creatureID.id.getLeastSignificantBits());
                nbtKnownCreature.setString("CreatureName", creatureID.name);
                nbtCreatures.appendTag((NBTBase)nbtKnownCreature);
            }
            nbtRoot.setTag("KnownCreatures", (NBTBase)nbtCreatures);
        }
        nbtRoot.setBoolean("SentinalPlant", this.isSentinal());
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        String playerName;
        int i;
        super.readEntityFromNBT(nbtRoot);
        String s = nbtRoot.getString("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
        }
        if (nbtRoot.hasKey("KnownPlayers")) {
            NBTTagList nbtPlayers = nbtRoot.getTagList("KnownPlayers", 10);
            this.knownPlayers = new ArrayList();
            for (i = 0; i < nbtPlayers.tagCount(); ++i) {
                NBTTagCompound nbtKnownPlayer = nbtPlayers.getCompoundTagAt(i);
                playerName = nbtKnownPlayer.getString("PlayerName");
                if (playerName == null || playerName.isEmpty()) continue;
                this.knownPlayers.add(playerName);
            }
        }
        if (nbtRoot.hasKey("KnownCreatureTypes")) {
            NBTTagList nbtCreatureTypes = nbtRoot.getTagList("KnownCreatureTypes", 10);
            this.knownCreatureTypes = new ArrayList();
            for (i = 0; i < nbtCreatureTypes.tagCount(); ++i) {
                NBTTagCompound nbtKnownCreatureType = nbtCreatureTypes.getCompoundTagAt(i);
                String typeName = nbtKnownCreatureType.getString("CreatureTypeName");
                if (typeName == null || typeName.isEmpty()) continue;
                this.knownCreatureTypes.add(typeName);
            }
        }
        if (nbtRoot.hasKey("KnownCreatures")) {
            NBTTagList nbtCreatures = nbtRoot.getTagList("KnownCreatures", 10);
            this.knownCreatures = new ArrayList();
            for (i = 0; i < nbtCreatures.tagCount(); ++i) {
                NBTTagCompound nbtKnownCreature = nbtCreatures.getCompoundTagAt(i);
                playerName = nbtKnownCreature.getString("PlayerName");
                long uuidMost = nbtKnownCreature.getLong("CreatureMost");
                long uuidLeast = nbtKnownCreature.getLong("CreatureLeast");
                String cname = nbtKnownCreature.getString("CreatureName");
                if (uuidMost == 0L && uuidLeast == 0L) continue;
                UUID creatureID = new UUID(uuidMost, uuidLeast);
                this.knownCreatures.add(new CreatureID(creatureID, cname));
            }
        }
        if (nbtRoot.hasKey("SentinalPlant")) {
            this.setSentinal(nbtRoot.getBoolean("SentinalPlant"));
        }
    }

    public String getOwnerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String par1Str) {
        this.func_110163_bv();
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public EntityPlayer getOwnerEntity() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    public void onUpdate() {
        super.onUpdate();
    }

    protected String getHurtSound() {
        return "mob.silverfish.hit";
    }

    protected String getLivingSound() {
        return "witchery:mob.treefyd.treefyd_say";
    }

    protected String getDeathSound() {
        return "mob.creeper.death";
    }

    protected Item getDropItem() {
        return Item.getItemFromBlock((Block)Blocks.red_flower);
    }

    protected void dropRareDrop(int par1) {
        this.entityDropItem(Witchery.Items.GENERIC.itemSeedsTreefyd.createStack(), 0.0f);
    }

    protected boolean canDespawn() {
        return false;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$emoniph$witchery$item$ItemTaglockKit$BoundType;

        static {
            $SwitchMap$com$emoniph$witchery$item$ItemTaglockKit$BoundType = new int[ItemTaglockKit.BoundType.values().length];
            try {
                1.$SwitchMap$com$emoniph$witchery$item$ItemTaglockKit$BoundType[ItemTaglockKit.BoundType.PLAYER.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$emoniph$witchery$item$ItemTaglockKit$BoundType[ItemTaglockKit.BoundType.CREATURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$emoniph$witchery$item$ItemTaglockKit$BoundType[ItemTaglockKit.BoundType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static class CreatureID {
        UUID id;
        String name;

        public CreatureID(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof UUID) {
                return this.id.equals((UUID)obj);
            }
            if (obj.getClass() == this.getClass()) {
                return this.id.equals(((CreatureID)obj).id);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

