/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntitySummonedUndead
extends EntityMob {
    private int timeToLive = -1;

    public EntitySummonedUndead(World world) {
        super(world);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(19, (Object)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.getSummonerName() == null) {
            nbtRoot.setString("Summoner", "");
        } else {
            nbtRoot.setString("Summoner", this.getSummonerName());
        }
        nbtRoot.setBoolean("Obscured", this.isObscured());
        nbtRoot.setInteger("SuicideIn", this.timeToLive);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        String s = nbtRoot.getString("Summoner");
        if (s.length() > 0) {
            this.setSummoner(s);
        }
        this.setObscured(nbtRoot.getBoolean("Obscured"));
        this.timeToLive = nbtRoot.hasKey("SuicideIn") ? nbtRoot.getInteger("SuicideIn") : -1;
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    public String getSummonerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setSummoner(String par1Str) {
        this.func_110163_bv();
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public EntityPlayer getSummoner() {
        return this.worldObj.getPlayerEntityByName(this.getSummonerName());
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (!this.isTemp()) {
            int quantity;
            int chance = this.rand.nextInt(Math.max(4 - par2, 2));
            int n = quantity = chance == 0 ? 1 : 0;
            if (quantity > 0) {
                this.entityDropItem(Witchery.Items.GENERIC.itemSpectralDust.createStack(quantity), 0.0f);
            }
        }
    }

    protected void updateAITick() {
        super.updateAITick();
        if (!(this.worldObj == null || this.isDead || this.worldObj.isRemote || this.timeToLive == -1 || --this.timeToLive != 0 && this.getAttackTarget() != null && !this.getAttackTarget().isDead)) {
            ParticleEffect.EXPLODE.send(SoundEffect.NONE, (Entity)this, 1.0, 1.0, 16);
            this.setDead();
        }
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 3;
    }

    public boolean isScreaming() {
        return this.dataWatcher.getWatchableObjectInt(18) == 1;
    }

    protected void setScreaming(boolean screaming) {
        this.dataWatcher.updateObject(18, (Object)(screaming ? 1 : 0));
    }

    public boolean isObscured() {
        return this.dataWatcher.getWatchableObjectInt(19) == 1;
    }

    public void setObscured(boolean obscured) {
        this.dataWatcher.updateObject(19, (Object)(obscured ? 1 : 0));
    }

    public boolean attackEntityFrom(DamageSource damageSource, float damage) {
        return super.attackEntityFrom(damageSource, Math.min(damage, 15.0f));
    }
}

