/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.infusion.infusions.symbols.EffectRegistry;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffect;
import com.emoniph.witchery.infusion.infusions.symbols.SymbolEffectProjectile;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySpellEffect
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround;
    public EntityLivingBase shootingEntity;
    private int ticksAlive;
    private int ticksInAir;
    private int lifetime = -1;
    private int effectLevel;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    private int effectID;

    public EntitySpellEffect(World par1World) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
        this.noClip = true;
    }

    public EntitySpellEffect setLifeTime(int ticks) {
        this.lifetime = ticks;
        return this;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(6, (Object)0);
        this.dataWatcher.addObject(15, (Object)0);
    }

    public void setShooter(EntityLivingBase entity) {
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(15, (Object)entity.getEntityId());
        }
    }

    public int getShooterID() {
        int id = this.dataWatcher.getWatchableObjectInt(15);
        return id;
    }

    public boolean isShooter(Entity entity) {
        int us;
        int idOther = entity.getEntityId();
        return idOther == (us = this.getShooterID());
    }

    public void setEffectID(int effectID) {
        this.effectID = effectID;
        this.getDataWatcher().updateObject(6, (Object)effectID);
    }

    public int getEffectID() {
        return this.getDataWatcher().getWatchableObjectInt(6);
    }

    public int getEffectLevel() {
        return this.effectLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double par1) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public EntitySpellEffect(World par1World, double par2, double par4, double par6, double par8, double par10, double par12, SymbolEffect effect, int effectLevel) {
        super(par1World);
        this.effectLevel = effectLevel;
        this.setSize(1.0f, 1.0f);
        this.setLocationAndAngles(par2, par4, par6, this.rotationYaw, this.rotationPitch);
        this.setPosition(par2, par4, par6);
        double d6 = MathHelper.sqrt_double((double)(par8 * par8 + par10 * par10 + par12 * par12));
        this.accelerationX = par8 / d6 * 0.1;
        this.accelerationY = par10 / d6 * 0.1;
        this.accelerationZ = par12 / d6 * 0.1;
        this.setEffectID(effect.getEffectID());
    }

    public EntitySpellEffect(World par1World, EntityLivingBase par2EntityLivingBase, double par3, double par5, double par7, SymbolEffect effect, int effectLevel) {
        super(par1World);
        this.shootingEntity = par2EntityLivingBase;
        this.effectLevel = effectLevel;
        this.setSize(1.0f, 1.0f);
        this.setLocationAndAngles(par2EntityLivingBase.posX, par2EntityLivingBase.posY, par2EntityLivingBase.posZ, par2EntityLivingBase.rotationYaw, par2EntityLivingBase.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        double d3 = MathHelper.sqrt_double((double)((par3 += this.rand.nextGaussian() * 0.4) * par3 + (par5 += this.rand.nextGaussian() * 0.4) * par5 + (par7 += this.rand.nextGaussian() * 0.4) * par7));
        this.accelerationX = par3 / d3 * 0.1;
        this.accelerationY = par5 / d3 * 0.1;
        this.accelerationZ = par7 / d3 * 0.1;
        this.setEffectID(effect.getEffectID());
    }

    public void onUpdate() {
        if (!this.worldObj.isRemote && (this.shootingEntity != null && this.shootingEntity.isDead || !this.worldObj.blockExists((int)this.posX, (int)this.posY, (int)this.posZ))) {
            this.setDead();
        } else {
            SymbolEffect effect;
            super.onUpdate();
            if (this.inGround) {
                Block i = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
                if (i == this.inTile) {
                    ++this.ticksAlive;
                    if (this.ticksAlive == 600) {
                        this.setDead();
                    }
                    return;
                }
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
                if (this.ticksInAir == 200) {
                    this.setDead();
                }
            }
            Vec3 vec3 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            Vec3 vec31 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3, vec31);
            vec3 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            vec31 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            if (movingobjectposition != null) {
                vec31 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
            }
            Entity entity = null;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d0 = 0.0;
            boolean remote = this.worldObj.isRemote;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.canBeCollidedWith() || this.isShooter(entity1) && this.ticksInAir < 25 || (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand((double)(f = 0.3f), (double)f, (double)f)).calculateIntercept(vec3, vec31)) == null || !((d1 = vec3.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null || this.lifetime != -1 && Math.max(--this.lifetime, 0) == 0) {
                this.onImpact(movingobjectposition);
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float f1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
            this.rotationPitch = (float)(Math.atan2(f1, this.motionY) * 180.0 / Math.PI) - 90.0f;
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float f2 = this.getMotionFactor();
            if (this.isInWater()) {
                for (int k = 0; k < 4; ++k) {
                    float f3 = 0.25f;
                    this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
                }
                f2 = 0.8f;
            }
            if ((effect = EffectRegistry.instance().getEffect(this.getEffectID())) == null) {
                this.setDead();
            } else {
                if (effect.fallsToEarth() && this.getEffectLevel() == 1) {
                    this.accelerationX *= 0.8;
                    this.accelerationY *= 0.8;
                    this.accelerationZ *= 0.8;
                    this.motionX += this.accelerationX;
                    this.motionY += this.accelerationY;
                    this.motionZ += this.accelerationZ;
                    this.motionY -= 0.05;
                } else {
                    this.motionX += this.accelerationX;
                    this.motionY += this.accelerationY;
                    this.motionZ += this.accelerationZ;
                    this.motionX *= (double)f2;
                    this.motionY *= (double)f2;
                    this.motionZ *= (double)f2;
                }
                this.worldObj.spawnParticle(effect.isCurse() ? ParticleEffect.MOB_SPELL.toString() : ParticleEffect.SLIME.toString(), this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0);
                if (effect.isCurse()) {
                    this.worldObj.spawnParticle(effect.isCurse() ? ParticleEffect.FLAME.toString() : ParticleEffect.SLIME.toString(), this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0);
                }
                this.setPosition(this.posX, this.posY, this.posZ);
            }
        }
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        SymbolEffect effect;
        if (!this.worldObj.isRemote && (effect = EffectRegistry.instance().getEffect(this.getEffectID())) != null && effect instanceof SymbolEffectProjectile) {
            if (effect.isCurse()) {
                ParticleEffect.MOB_SPELL.send(SoundEffect.MOB_ENDERDRAGON_HIT, this, 1.0, 1.0, 16);
            } else {
                ParticleEffect.SLIME.send(SoundEffect.MOB_SLIME_SMALL, this, 1.0, 1.0, 16);
            }
            ((SymbolEffectProjectile)effect).onCollision(this.worldObj, this.shootingEntity, mop, this);
        }
        this.setDead();
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setShort("xTile", (short)this.xTile);
        nbtRoot.setShort("yTile", (short)this.yTile);
        nbtRoot.setShort("zTile", (short)this.zTile);
        nbtRoot.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.inTile));
        nbtRoot.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbtRoot.setTag("direction", (NBTBase)this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbtRoot.setInteger("EffectID", this.effectID);
        nbtRoot.setInteger("lifetime", this.lifetime);
        nbtRoot.setInteger("effectLevel", this.effectLevel);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        this.xTile = nbtRoot.getShort("xTile");
        this.yTile = nbtRoot.getShort("yTile");
        this.zTile = nbtRoot.getShort("zTile");
        this.inTile = Block.getBlockById((int)(nbtRoot.getByte("inTile") & 0xFF));
        this.inGround = nbtRoot.getByte("inGround") == 1;
        this.lifetime = nbtRoot.hasKey("lifetime") ? nbtRoot.getInteger("lifetime") : -1;
        if (nbtRoot.hasKey("direction") && nbtRoot.hasKey("EffectID")) {
            this.effectID = nbtRoot.getInteger("EffectID");
            this.setEffectID(this.effectID);
            NBTTagList nbttaglist = nbtRoot.getTagList("direction", 6);
            this.motionX = nbttaglist.func_150309_d(0);
            this.motionY = nbttaglist.func_150309_d(1);
            this.motionZ = nbttaglist.func_150309_d(2);
        } else {
            this.setDead();
        }
        this.effectLevel = Math.max(nbtRoot.getInteger("effectLevel"), 1);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public float getCollisionBorderSize() {
        return 1.0f;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        boolean canDeflect;
        if (this.isEntityInvulnerable()) {
            return false;
        }
        this.setBeenAttacked();
        Entity entity = par1DamageSource.getEntity();
        boolean bl = canDeflect = entity != null && this.getEffectID() != 5 && entity instanceof EntityPlayer && ((EntityPlayer)entity).getHeldItem() != null && ((EntityPlayer)entity).getHeldItem().getItem() == Witchery.Items.MYSTIC_BRANCH;
        if (canDeflect) {
            Vec3 vec3 = par1DamageSource.getEntity().getLookVec();
            if (vec3 != null) {
                this.motionX = vec3.xCoord;
                this.motionY = vec3.yCoord;
                this.motionZ = vec3.zCoord;
                this.accelerationX = this.motionX * 0.1;
                this.accelerationY = this.motionY * 0.1;
                this.accelerationZ = this.motionZ * 0.1;
            }
            if (par1DamageSource.getEntity() instanceof EntityLivingBase) {
                this.shootingEntity = (EntityLivingBase)par1DamageSource.getEntity();
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }
}

