/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.blocks.BlockBrazier;
import com.emoniph.witchery.blocks.BlockKettle;
import com.emoniph.witchery.entity.EntitySummonedUndead;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityPoltergeist
extends EntitySummonedUndead {
    private int attackTimer;

    public EntityPoltergeist(World par1World) {
        super(par1World);
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
    }

    protected boolean isAIEnabled() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 15;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (TimeUtil.secondsElapsed(5, this.ticksExisted)) {
            double RADIUS = 16.0;
            double RADIUS_SQ = 256.0;
            double THROW_RANGE = 3.0;
            double THROW_RANGE_SQ = 9.0;
            double EVIL_RANGE = 8.0;
            double EVIL_RANGE_SQ = 64.0;
            double MAX_SPEED = 0.6;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 16.0), (double)(this.posY - 16.0), (double)(this.posZ - 16.0), (double)(this.posX + 16.0), (double)(this.posY + 16.0), (double)(this.posZ + 16.0));
            List hangingItems = this.worldObj.getEntitiesWithinAABB(EntityHanging.class, bounds);
            for (Object obj : hangingItems) {
                EntityHanging hanging = (EntityHanging)obj;
                if (!(this.getDistanceSqToEntity((Entity)hanging) <= 256.0)) continue;
                if (this.getDistanceSqToEntity((Entity)hanging) <= 9.0) {
                    if (!this.worldObj.isRemote) {
                        hanging.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 3.0f);
                    }
                    this.attackTimer = 15;
                    this.worldObj.setEntityState((Entity)this, (byte)4);
                } else {
                    this.getNavigator().tryMoveToXYZ(hanging.posX, hanging.posY, hanging.posZ, 1.0);
                }
                return;
            }
            EntityPlayer summoner = this.getSummoner();
            if (summoner != null && this.getDistanceSqToEntity((Entity)summoner) <= 64.0) {
                TileEntity closest = null;
                double closestDist = -1.0;
                for (Object obj : this.worldObj.loadedTileEntityList) {
                    if (!(obj instanceof IInventory) || obj instanceof BlockKettle.TileEntityKettle || obj instanceof BlockBrazier.TileEntityBrazier) continue;
                    TileEntity tile = (TileEntity)obj;
                    double distSq = this.getDistanceSq(0.5 + (double)tile.xCoord, 0.5 + (double)tile.yCoord, 0.5 + (double)tile.zCoord);
                    if (!(distSq <= 256.0)) continue;
                    IInventory inventory = (IInventory)tile;
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                        if (inventory.getStackInSlot(i) == null) continue;
                        indices.add(i);
                    }
                    if (indices.size() <= 0 || closest != null && !(distSq < closestDist)) continue;
                    closest = tile;
                    closestDist = distSq;
                }
                if (closest != null) {
                    IInventory inventory = (IInventory)closest;
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                        if (inventory.getStackInSlot(i) == null) continue;
                        indices.add(i);
                    }
                    if (indices.size() > 0) {
                        if (this.getDistanceSq(0.5 + (double)closest.xCoord, 0.5 + (double)closest.yCoord, 0.5 + (double)closest.zCoord) <= 9.0) {
                            if (!this.worldObj.isRemote) {
                                int slot = (Integer)indices.get(this.worldObj.rand.nextInt(indices.size()));
                                ItemStack stack = inventory.getStackInSlot(slot);
                                if (stack.stackSize > 1) {
                                    --stack.stackSize;
                                    stack = stack.copy();
                                    stack.stackSize = 1;
                                } else {
                                    inventory.setInventorySlotContents(slot, null);
                                }
                                EntityItem itemEntity = new EntityItem(this.worldObj, 0.5 + (double)closest.xCoord, 0.5 + (double)closest.yCoord, 0.5 + (double)closest.zCoord, stack);
                                this.worldObj.spawnEntityInWorld((Entity)itemEntity);
                                itemEntity.lifespan = TimeUtil.minsToTicks(15);
                                itemEntity.motionX = -0.3 + this.worldObj.rand.nextDouble() * 0.6;
                                itemEntity.motionY = 0.1 + this.worldObj.rand.nextDouble() * 0.2;
                                itemEntity.motionZ = -0.3 + this.worldObj.rand.nextDouble() * 0.6;
                            }
                            this.attackTimer = 15;
                            this.worldObj.setEntityState((Entity)this, (byte)4);
                        } else {
                            this.getNavigator().tryMoveToXYZ((double)closest.xCoord, (double)closest.yCoord, (double)closest.zCoord, 1.0);
                        }
                        return;
                    }
                }
            }
            List droppedItems = this.worldObj.getEntitiesWithinAABB(EntityItem.class, bounds);
            for (Object obj : droppedItems) {
                EntityItem dropped = (EntityItem)obj;
                if (!(this.getDistanceSqToEntity((Entity)dropped) <= 256.0)) continue;
                if (this.getDistanceSqToEntity((Entity)dropped) <= 9.0) {
                    if (!this.worldObj.isRemote) {
                        dropped.motionX = -0.3 + this.worldObj.rand.nextDouble() * 0.6;
                        dropped.motionY = 0.1 + this.worldObj.rand.nextDouble() * 0.2;
                        dropped.motionZ = -0.3 + this.worldObj.rand.nextDouble() * 0.6;
                    }
                    this.attackTimer = 15;
                    this.worldObj.setEntityState((Entity)this, (byte)4);
                } else {
                    this.getNavigator().tryMoveToXYZ(dropped.posX, dropped.posY, dropped.posZ, 1.0);
                }
                return;
            }
        }
    }

    public void onUpdate() {
        super.onUpdate();
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        boolean flag = super.attackEntityAsMob(par1Entity);
        return flag;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "witchery:mob.spectre.spectre_die";
    }

    protected String getDeathSound() {
        return "witchery:mob.spectre.spectre_die";
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.poltergeist.name");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData par1EntityLivingData1 = super.onSpawnWithEgg(par1EntityLivingData);
        this.addPotionEffect(new PotionEffect(Potion.invisibility.id, Integer.MAX_VALUE));
        return par1EntityLivingData1;
    }
}

