/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.entity.EntitySpirit;
import com.emoniph.witchery.entity.ai.EntityAIFlyerAttackOnCollide;
import com.emoniph.witchery.entity.ai.EntityAIFlyerLand;
import com.emoniph.witchery.entity.ai.EntityAISitAndStay;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityLostSoul
extends EntitySpirit {
    private int timeToLive = -1;

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public boolean isTemp() {
        return this.timeToLive != -1;
    }

    public EntityLostSoul(World world) {
        super(world);
        this.tasks.taskEntries.clear();
        this.targetTasks.taskEntries.clear();
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, 0.8, true));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("FeatherColor", this.getFeatherColor());
        par1NBTTagCompound.setByte("SoulType", (byte)this.getSoulType());
        par1NBTTagCompound.setInteger("SuicideIn", this.timeToLive);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasKey("FeatherColor")) {
            this.setFeatherColor(par1NBTTagCompound.getInteger("FeatherColor"));
        }
        if (par1NBTTagCompound.hasKey("SoulType")) {
            this.setSoulType(par1NBTTagCompound.getByte("SoulType"));
        }
        this.timeToLive = par1NBTTagCompound.hasKey("SuicideIn") ? par1NBTTagCompound.getInteger("SuicideIn") : -1;
    }

    public void setInWeb() {
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(22, (Object)this.worldObj.rand.nextInt(3));
        switch (this.getSoulType()) {
            case 0: {
                this.setFeatherColor(0xFF0000);
                break;
            }
            case 1: {
                this.setFeatherColor(65280);
                break;
            }
            case 2: {
                this.setFeatherColor(255);
            }
        }
    }

    public int getSoulType() {
        return this.dataWatcher.getWatchableObjectInt(22);
    }

    public void setSoulType(int par1) {
        this.dataWatcher.updateObject(22, (Object)par1);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.4);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
    }

    public boolean attackEntityAsMob(Entity targetEntity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (targetEntity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
        }
        DamageSource source = null;
        if (this.worldObj.rand.nextInt(4) == 0) {
            switch (this.getSoulType()) {
                case 0: {
                    source = DamageSource.inFire;
                    break;
                }
                case 1: {
                    source = DamageSource.causeMobDamage((EntityLivingBase)this);
                    break;
                }
                case 2: {
                    source = DamageSource.magic;
                }
            }
        }
        if (source == null) {
            source = DamageSource.causeMobDamage((EntityLivingBase)this);
        }
        if (flag = targetEntity.attackEntityFrom(source, f)) {
            int j;
            if (i > 0) {
                targetEntity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                targetEntity.setFire(j * 4);
            }
            if (targetEntity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
        }
        return flag;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        float MAX_DAMAGE = 15.0f;
        switch (this.getSoulType()) {
            case 0: {
                if (!source.isFireDamage() && !source.isExplosion()) break;
                return super.attackEntityFrom(source, Math.min(damage, 15.0f));
            }
            case 1: {
                if (source.isProjectile() || source.isMagicDamage() || source.isFireDamage() || source.isExplosion() || source == DamageSource.inWall || source == DamageSource.cactus || source == DamageSource.drown || source == DamageSource.wither) break;
                return super.attackEntityFrom(source, Math.min(damage, 15.0f));
            }
            case 2: {
                if (!source.isMagicDamage()) break;
                return super.attackEntityFrom(source, Math.min(damage, 15.0f));
            }
        }
        return false;
    }

    @Override
    protected void updateAITick() {
        super.updateAITick();
        if (!this.worldObj.isRemote && this.timeToLive != -1 && --this.timeToLive <= 0) {
            this.setDead();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
    }

    @Override
    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.lostsoul.name");
    }
}

