/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.potions.PotionEnderInhibition;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.common.ServerTickEvents;
import com.emoniph.witchery.entity.EntitySpirit;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.util.CircleUtil;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.EntityPosition;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityItemWaystone
extends EntityItem {
    public EntityItemWaystone(World world) {
        super(world);
    }

    public EntityItemWaystone(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityItemWaystone(World world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z, stack);
    }

    public EntityItemWaystone(EntityItem entityItem) {
        super(entityItem.worldObj, entityItem.posX, entityItem.posY, entityItem.posZ, entityItem.getEntityItem());
        this.delayBeforeCanPickup = entityItem.delayBeforeCanPickup;
        this.motionX = entityItem.motionX;
        this.motionY = entityItem.motionY;
        this.motionZ = entityItem.motionZ;
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        double minPickupRange = 0.75;
        double minPickupRangeSq = 0.5625;
        if (this.getDistanceSqToEntity((Entity)player) <= 0.5625) {
            super.onCollideWithPlayer(player);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote && this.age > TimeUtil.secsToTicks(2) && this.age % 40 == 0) {
            Block glyph;
            Coord center;
            if (Witchery.Items.GENERIC.itemWaystone.isMatch(this.getEntityItem())) {
                Block glyph2 = Witchery.Blocks.GLYPH_OTHERWHERE;
                Coord center2 = EntityItemWaystone.isTinyBlockCircle(this.worldObj, new Coord((Entity)this), glyph2);
                if (center2 != null) {
                    int originalStackSize = this.getEntityItem().stackSize;
                    int remainingStackSize = 0;
                    double R = 2.0;
                    double RSq = 4.0;
                    EntityPosition centerPoint = new EntityPosition((double)center2.x + 0.5, (double)center2.y + 0.5, (double)center2.z + 0.5);
                    AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(centerPoint.x - 2.0), (double)(centerPoint.y - 2.0), (double)(centerPoint.z - 2.0), (double)(centerPoint.x + 2.0), (double)(centerPoint.y + 2.0), (double)(centerPoint.z + 2.0));
                    ItemStack boundStone = null;
                    EntityPlayer target = null;
                    double targetDistSq = -1.0;
                    List nearbyPlayers = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                    for (EntityPlayer player : nearbyPlayers) {
                        double distSq = player.getDistanceSq(centerPoint.x, player.posY, centerPoint.z);
                        if (!(distSq <= 4.0) || target != null && !(distSq < targetDistSq)) continue;
                        target = player;
                        targetDistSq = distSq;
                    }
                    if (target == null) {
                        List nearbyCreatures = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, bounds);
                        for (EntityLiving creature : nearbyCreatures) {
                            double distSq = creature.getDistanceSq(centerPoint.x, creature.posY, centerPoint.z);
                            if (!(distSq <= 4.0) || target != null && !(distSq < targetDistSq)) continue;
                            target = creature;
                            targetDistSq = distSq;
                        }
                    }
                    if (target != null) {
                        IPowerSource power = PowerSources.findClosestPowerSource(this.worldObj, center2);
                        if (power != null) {
                            if (power.consumePower(4000.0f)) {
                                int convertableStackSize = Math.min(originalStackSize, 1);
                                remainingStackSize = originalStackSize - convertableStackSize;
                                boundStone = Witchery.Items.GENERIC.itemWaystonePlayerBound.createStack(convertableStackSize);
                                Witchery.Items.TAGLOCK_KIT.setTaglockForEntity(boundStone, null, (Entity)target, false, (Integer)1);
                            } else {
                                ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, this.worldObj, center2, 1.0, 1.0, 16);
                            }
                        } else {
                            ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, this.worldObj, center2, 1.0, 1.0, 16);
                        }
                    } else {
                        int convertableStackSize = Math.min(originalStackSize, 8);
                        remainingStackSize = originalStackSize - convertableStackSize;
                        boundStone = Witchery.Items.GENERIC.itemWaystoneBound.createStack(convertableStackSize);
                        Witchery.Items.GENERIC.bindToLocation(this.worldObj, center2.x, center2.y, center2.z, this.dimension, this.worldObj.provider.getDimensionName(), boundStone);
                    }
                    if (boundStone != null) {
                        EntityUtil.spawnEntityInWorld(this.worldObj, (Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, boundStone));
                        if (remainingStackSize > 0) {
                            EntityUtil.spawnEntityInWorld(this.worldObj, (Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, Witchery.Items.GENERIC.itemWaystone.createStack(remainingStackSize)));
                        }
                        ParticleEffect.LARGE_EXPLODE.send(SoundEffect.RANDOM_POP, (Entity)this, 1.0, 1.0, 16);
                        EntityItemWaystone.isInnerTinyBlockCircle(this.worldObj, center2.x, center2.y, center2.z, glyph2, true);
                        this.setDead();
                    }
                }
            } else if (Witchery.Items.GENERIC.itemWaystoneBound.isMatch(this.getEntityItem()) || Witchery.Items.GENERIC.itemWaystonePlayerBound.isMatch(this.getEntityItem())) {
                Block glyph3 = Witchery.Blocks.GLYPH_OTHERWHERE;
                Coord center3 = EntityItemWaystone.isSmallBlockCircle(this.worldObj, new Coord((Entity)this), glyph3);
                if (center3 != null) {
                    double R = 4.0;
                    double RSq = 16.0;
                    ItemStack usedStone = this.getEntityItem().splitStack(1);
                    if (this.getEntityItem().stackSize > 0) {
                        EntityUtil.spawnEntityInWorld(this.worldObj, (Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.getEntityItem()));
                    }
                    this.setDead();
                    AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)((double)center3.x + 0.5 - 4.0), (double)((double)center3.y + 0.5 - 4.0), (double)((double)center3.z + 0.5 - 4.0), (double)((double)center3.x + 0.5 + 4.0), (double)((double)center3.y + 0.5 + 4.0), (double)((double)center3.z + 0.5 + 4.0));
                    List list = this.worldObj.getEntitiesWithinAABB(Entity.class, bounds);
                    for (Entity entity : list) {
                        if (entity.isDead || !(entity.getDistanceSq(0.5 + (double)center3.x, entity.posY, 0.5 + (double)center3.z) <= 16.0) || !(entity instanceof EntityLivingBase) && !(entity instanceof EntityItem) || PotionEnderInhibition.isActive(entity, 1)) continue;
                        ServerTickEvents.TASKS.add(new TeleportTask(this.worldObj, usedStone, entity));
                    }
                }
            } else if (Witchery.Items.GENERIC.itemAttunedStone.isMatch(this.getEntityItem())) {
                Block glyph4 = Witchery.Blocks.GLYPH_RITUAL;
                Coord center4 = EntityItemWaystone.isTinyBlockCircle(this.worldObj, new Coord((Entity)this), glyph4);
                if (center4 != null) {
                    int originalStackSize = this.getEntityItem().stackSize;
                    int remainingStackSize = 0;
                    double R = 2.0;
                    double RSq = 4.0;
                    EntityPosition centerPoint = new EntityPosition((double)center4.x + 0.5, (double)center4.y + 0.5, (double)center4.z + 0.5);
                    AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(centerPoint.x - 2.0), (double)(centerPoint.y - 2.0), (double)(centerPoint.z - 2.0), (double)(centerPoint.x + 2.0), (double)(centerPoint.y + 2.0), (double)(centerPoint.z + 2.0));
                    int convertableStackSize = Math.min(originalStackSize, 1);
                    remainingStackSize = originalStackSize - convertableStackSize;
                    EntityCreature creature = Infusion.spawnCreature(this.worldObj, EntitySpirit.class, (int)this.posX, (int)this.posY, (int)this.posZ, null, 0, 0, ParticleEffect.INSTANT_SPELL, null);
                    if (creature != null) {
                        EntitySpirit spirit = (EntitySpirit)creature;
                        creature.func_110163_bv();
                        spirit.setTarget("Village", 2);
                    }
                    if (remainingStackSize > 0) {
                        EntityUtil.spawnEntityInWorld(this.worldObj, (Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, Witchery.Items.GENERIC.itemAttunedStone.createStack(remainingStackSize)));
                    }
                    ParticleEffect.LARGE_EXPLODE.send(SoundEffect.RANDOM_POP, (Entity)this, 1.0, 1.0, 16);
                    EntityItemWaystone.isInnerTinyBlockCircle(this.worldObj, center4.x, center4.y, center4.z, glyph4, true);
                    this.setDead();
                }
            } else if (Witchery.Items.GENERIC.itemSubduedSpirit.isMatch(this.getEntityItem()) && (center = EntityItemWaystone.isTinyBlockCircle(this.worldObj, new Coord((Entity)this), glyph = Witchery.Blocks.GLYPH_RITUAL)) != null) {
                int originalStackSize = this.getEntityItem().stackSize;
                int remainingStackSize = 0;
                double R = 2.0;
                double RSq = 4.0;
                EntityPosition centerPoint = new EntityPosition((double)center.x + 0.5, (double)center.y + 0.5, (double)center.z + 0.5);
                AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(centerPoint.x - 2.0), (double)(centerPoint.y - 2.0), (double)(centerPoint.z - 2.0), (double)(centerPoint.x + 2.0), (double)(centerPoint.y + 2.0), (double)(centerPoint.z + 2.0));
                int convertableStackSize = Math.min(originalStackSize, 1);
                remainingStackSize = originalStackSize - convertableStackSize;
                EntityCreature creature = Infusion.spawnCreature(this.worldObj, EntitySpirit.class, (int)this.posX, (int)this.posY, (int)this.posZ, null, 0, 0, ParticleEffect.INSTANT_SPELL, null);
                if (creature != null) {
                    EntitySpirit spirit = (EntitySpirit)creature;
                    creature.func_110163_bv();
                    spirit.setTarget("Village", 2);
                }
                if (remainingStackSize > 0) {
                    EntityUtil.spawnEntityInWorld(this.worldObj, (Entity)new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, Witchery.Items.GENERIC.itemSubduedSpirit.createStack(remainingStackSize)));
                }
                ParticleEffect.LARGE_EXPLODE.send(SoundEffect.RANDOM_POP, (Entity)this, 1.0, 1.0, 16);
                EntityItemWaystone.isInnerTinyBlockCircle(this.worldObj, center.x, center.y, center.z, glyph, true);
                this.setDead();
            }
        }
    }

    private static Coord isTinyBlockCircle(World world, Coord coord, Block runeBlock) {
        int x = coord.x;
        int y = coord.y;
        int z = coord.z;
        if (EntityItemWaystone.isInnerTinyBlockCircle(world, x, y, z, runeBlock, false)) {
            return coord;
        }
        return null;
    }

    private static boolean isInnerTinyBlockCircle(World world, int x, int y, int z, Block runeBlock, boolean explode) {
        int[][] circle;
        for (int[] coord : circle = new int[][]{{x, z - 1}, {x + 1, z - 1}, {x + 1, z}, {x + 1, z + 1}, {x, z + 1}, {x - 1, z + 1}, {x - 1, z}, {x - 1, z - 1}}) {
            if (world.getBlock(coord[0], y, coord[1]) == runeBlock) continue;
            return false;
        }
        if (explode) {
            for (int[] coord : circle) {
                world.setBlockToAir(coord[0], y, coord[1]);
                ParticleEffect.EXPLODE.send(SoundEffect.NONE, world, 0.5 + (double)coord[0], y, 0.5 + (double)coord[1], 0.5, 0.5, 16);
            }
        }
        return true;
    }

    private static Coord isSmallBlockCircle(World world, Coord coord, Block runeBlock) {
        int[][] circle;
        int x = coord.x;
        int z = coord.z;
        for (int[] co : circle = new int[][]{{0, 0}, {1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {-1, 1}, {1, -1}, {-1, -1}}) {
            if (!CircleUtil.isSmallCircle(world, coord.x + co[0], coord.y, coord.z + co[1], runeBlock)) continue;
            return new Coord(coord.x - co[0], coord.y, coord.z - co[1]);
        }
        return null;
    }

    private static class TeleportTask
    extends ServerTickEvents.ServerTickTask {
        ItemStack stone;
        Entity entity;

        public TeleportTask(World world, ItemStack stone, Entity entity) {
            super(world);
            this.stone = stone;
            this.entity = entity;
        }

        @Override
        public boolean process() {
            if (!Witchery.Items.GENERIC.teleportToLocation(this.world, this.stone, this.entity, 0, true)) {
                ParticleEffect.SMOKE.send(SoundEffect.NOTE_SNARE, this.world, this.entity.posX, this.entity.posY, this.entity.posZ, 1.0, 1.0, 16);
            }
            return true;
        }
    }
}

