/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.util.IHandleDT;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityHornedHuntsman
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
IHandleDT {
    private int attackTimer;
    private boolean explosiveEntrance;
    long ticksSinceTeleport = 0L;

    public EntityHornedHuntsman(World par1World) {
        super(par1World);
        this.setSize(1.4f, 3.2f);
        this.isImmuneToFire = true;
        this.getNavigator().setAvoidsWater(true);
        this.getNavigator().setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 30.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.experienceValue = 70;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(20, (Object)new Integer(0));
    }

    public void causeExplosiveEntrance() {
        this.explosiveEntrance = true;
    }

    public int getTotalArmorValue() {
        return 4;
    }

    public void setInWeb() {
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.hornedHuntsman.name");
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
    }

    public int func_82212_n() {
        return this.dataWatcher.getWatchableObjectInt(20);
    }

    public void func_82215_s(int par1) {
        this.dataWatcher.updateObject(20, (Object)par1);
    }

    public void func_82206_m() {
        this.func_82215_s(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        if (this.func_82212_n() > 0) {
            int i = this.func_82212_n() - 1;
            if (i <= 0) {
                if (this.explosiveEntrance) {
                    this.worldObj.newExplosion((Entity)this, this.posX, this.posY + (double)this.getEyeHeight(), this.posZ, 6.0f, false, this.worldObj.getGameRules().getGameRuleBooleanValue("mobGriefing"));
                }
                this.worldObj.playBroadcastSound(1013, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            }
            this.func_82215_s(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(20.0f);
            }
        } else {
            super.updateAITasks();
            if (this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            if (this.ticksExisted % 20 == 0 && this.worldObj.rand.nextInt(5) == 0 && this.getAttackTarget() != null && !this.worldObj.isRemote && this.getEntitySenses().canSee((Entity)this.getAttackTarget())) {
                float f;
                double d0 = this.getDistanceSq(this.getAttackTarget().posX, this.getAttackTarget().boundingBox.minY, this.getAttackTarget().posZ);
                this.getLookHelper().setLookPositionWithEntity((Entity)this.getAttackTarget(), 30.0f, 30.0f);
                float range = 30.0f;
                float f1 = f = MathHelper.sqrt_double((double)d0) / range;
                if (f < 0.1f) {
                    f1 = 0.1f;
                }
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.attackEntityWithRangedAttack(this.getAttackTarget(), f);
            }
            if (this.ticksExisted % (200 + this.worldObj.rand.nextInt(4) * 100) == 0 && this.getAttackTarget() != null && this.getDistanceSqToEntity((Entity)this.getAttackTarget()) <= 256.0 && !this.worldObj.isRemote && this.getEntitySenses().canSee((Entity)this.getAttackTarget())) {
                EntityWolf wolf = new EntityWolf(this.worldObj);
                wolf.setLocationAndAngles(this.posX - 0.5 + this.worldObj.rand.nextDouble(), this.posY, this.posZ - 0.5 + this.worldObj.rand.nextDouble(), this.rotationYawHead, this.rotationPitch);
                wolf.setAngry(true);
                wolf.setAttackTarget(this.getAttackTarget());
                wolf.addPotionEffect(new PotionEffect(Potion.resistance.id, 20000, 1));
                ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_FIZZ, (Entity)wolf, 2.0, 2.0, 10);
                this.worldObj.spawnEntityInWorld((Entity)wolf);
            }
            if (!this.worldObj.isRemote && this.getNavigator().noPath() && this.getAttackTarget() != null && (long)this.ticksExisted - this.ticksSinceTeleport > 200L) {
                this.ticksSinceTeleport = this.ticksExisted;
                this.teleportToEntity((Entity)this.getAttackTarget());
            }
        }
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX - par1Entity.posX), (double)(this.boundingBox.minY + (double)(this.height / 2.0f) - par1Entity.posY + (double)par1Entity.getEyeHeight()), (double)(this.posZ - par1Entity.posZ));
        vec3 = vec3.normalize();
        double d0 = 8.0;
        double d1 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.xCoord * d0;
        double d2 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3.yCoord * d0;
        double d3 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.zCoord * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        boolean flag = false;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.blockExists(i, j = MathHelper.floor_double((double)this.posY), k = MathHelper.floor_double((double)this.posZ))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.worldObj.getBlock(i, j - 1, k);
                if (block.getMaterial().blocksMovement()) {
                    flag1 = true;
                    continue;
                }
                this.posY -= 1.0;
                --j;
            }
            if (flag1) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.playSound("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(400.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.35);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        return super.attackEntityFrom(par1DamageSource, Math.min(par2, 15.0f));
    }

    @Override
    public float getCapDT(DamageSource source, float damage) {
        return 15.0f;
    }

    public boolean canAttackClass(Class par1Class) {
        return super.canAttackClass(par1Class);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("PlayerCreated", this.isPlayerCreated());
        par1NBTTagCompound.setInteger("Invul", this.func_82212_n());
        par1NBTTagCompound.setBoolean("explosiveEntrance", this.explosiveEntrance);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setPlayerCreated(par1NBTTagCompound.getBoolean("PlayerCreated"));
        this.func_82215_s(par1NBTTagCompound.getInteger("Invul"));
        this.explosiveEntrance = par1NBTTagCompound.hasKey("explosiveEntrance") ? par1NBTTagCompound.getBoolean("explosiveEntrance") : false;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return "mob.enderdragon.growl";
    }

    protected String getHurtSound() {
        return "mob.horse.zombie.hit";
    }

    protected String getDeathSound() {
        return "mob.wither.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.irongolem.walk", 1.0f, 1.0f);
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(new ItemStack(Items.skull, this.worldObj.rand.nextInt(3) == 0 ? 3 : 2, 1), 0.0f);
        Enchantment enchantment = Enchantment.enchantmentsBookList[this.rand.nextInt(Enchantment.enchantmentsBookList.length)];
        int k = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 2, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        ItemStack itemstack = Items.enchanted_book.getEnchantedItemStack(new EnchantmentData(enchantment, k));
        this.entityDropItem(itemstack, 0.0f);
        this.entityDropItem(Witchery.Items.GENERIC.itemInfernalBlood.createStack(), 0.0f);
        if (this.worldObj.rand.nextInt(4) == 0) {
            this.entityDropItem(new ItemStack(Witchery.Items.HUNTSMANS_SPEAR), 0.0f);
        }
    }

    protected Item getDropItem() {
        return null;
    }

    public boolean isPlayerCreated() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setPlayerCreated(boolean par1) {
        this.func_110163_bv();
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        EntityArrow entityarrow = new EntityArrow(this.worldObj, (EntityLivingBase)this, targetEntity, 1.6f, (float)(14 - this.worldObj.difficultySetting.getDifficultyId() * 4));
        entityarrow.setDamage((double)(par2 * 8.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.worldObj.difficultySetting.getDifficultyId() * 0.11f));
        entityarrow.setKnockbackStrength(2);
        this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.worldObj.spawnEntityInWorld((Entity)entityarrow);
    }
}

