/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.EntityThrowableBase;
import com.emoniph.witchery.client.particle.NaturePowerFX;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityFollower;
import com.emoniph.witchery.item.ItemSunGrenade;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.TimeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityGrenade
extends EntityThrowableBase {
    String owner;
    boolean blockPlaced;
    int blockX;
    int blockY;
    int blockZ;

    public EntityGrenade(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.noClip = false;
    }

    public EntityGrenade(World world, EntityLivingBase thrower, ItemStack stack) {
        super(world, thrower, -20.0f);
        this.setSize(0.25f, 0.25f);
        this.noClip = false;
        if (stack != null && stack.getItem() == Witchery.Items.DUP_GRENADE) {
            this.setMode(1);
            this.setOwner(ItemSunGrenade.getOwnerName(stack));
        } else {
            this.setMode(0);
        }
    }

    public EntityGrenade(World world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z, -20.0f);
        this.setSize(0.25f, 0.25f);
        this.noClip = false;
        if (stack != null && stack.getItem() == Witchery.Items.DUP_GRENADE) {
            this.setMode(1);
            this.setOwner(ItemSunGrenade.getOwnerName(stack));
        } else {
            this.setMode(0);
        }
    }

    @Override
    protected float getGravityVelocity() {
        return this.getImpact() ? 0.0f : 0.05f;
    }

    @Override
    protected float func_70182_d() {
        return 0.75f;
    }

    @Override
    protected float func_70183_g() {
        return -20.0f;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(6, (Object)0);
        this.dataWatcher.addObject(16, (Object)0);
    }

    public int getMode() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void setMode(int mode) {
        this.dataWatcher.updateObject(16, (Object)((byte)mode));
    }

    protected void setImpact(boolean impact) {
        this.getDataWatcher().updateObject(6, (Object)(impact ? (byte)1 : 0));
    }

    public boolean getImpact() {
        return this.getDataWatcher().getWatchableObjectByte(6) == 1;
    }

    @Override
    protected int getMaxGroundTicks() {
        return super.getMaxGroundTicks();
    }

    @Override
    protected int getMaxAirTicks() {
        return super.getMaxAirTicks();
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            if (this.getMode() == 0) {
                this.setImpact(true);
            } else {
                if (!this.worldObj.isRemote) {
                    this.onSetDead();
                } else {
                    this.onClientSetDead();
                }
                this.setDead();
            }
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
    }

    public void onEntityUpdate() {
        super.onEntityUpdate();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getMode() == 0) {
            if (this.worldObj.isRemote && this.getImpact() && this.worldObj.rand.nextInt(4) == 0) {
                float red = 1.0f;
                float green = 1.0f;
                float blue = 0.0f;
                Witchery.proxy.generateParticle(this.worldObj, this.posX - 0.1 + this.worldObj.rand.nextDouble() * 0.2, this.posY + 0.3 * (double)this.height - 0.1 + this.worldObj.rand.nextDouble() * 0.2, this.posZ - 0.1 + this.worldObj.rand.nextDouble() * 0.2, red, green, blue, 10, -0.3f);
            } else if (!this.worldObj.isRemote && !this.isDead) {
                if (!this.blockPlaced && this.ticksExisted % 5 == 4) {
                    this.blockPlaced = true;
                    this.blockX = MathHelper.floor_double((double)this.posX);
                    this.blockY = MathHelper.floor_double((double)this.posY);
                    this.blockZ = MathHelper.floor_double((double)this.posZ);
                    if (this.worldObj.isAirBlock(this.blockX, this.blockY, this.blockZ)) {
                        this.worldObj.setBlock(this.blockX, this.blockY, this.blockZ, (Block)Witchery.Blocks.LIGHT);
                    } else {
                        ++this.blockY;
                        if (this.worldObj.isAirBlock(this.blockX, this.blockY, this.blockZ)) {
                            this.worldObj.setBlock(this.blockX, this.blockY, this.blockZ, (Block)Witchery.Blocks.LIGHT);
                        }
                    }
                } else if (this.blockPlaced && (this.ticksExisted % 5 == 2 || this.getImpact())) {
                    int x = MathHelper.floor_double((double)this.posX);
                    int y = MathHelper.floor_double((double)this.posY);
                    int z = MathHelper.floor_double((double)this.posZ);
                    if (this.blockX != x || this.blockY != y || this.blockZ != z || this.ticksExisted % 30 == 4 && this.worldObj.isAirBlock(x, y, z)) {
                        if (this.worldObj.getBlock(this.blockX, this.blockY, this.blockZ) == Witchery.Blocks.LIGHT) {
                            this.worldObj.setBlockToAir(this.blockX, this.blockY, this.blockZ);
                        }
                        this.blockX = x;
                        this.blockY = y;
                        this.blockZ = z;
                        if (this.worldObj.isAirBlock(this.blockX, this.blockY, this.blockZ)) {
                            this.worldObj.setBlock(this.blockX, this.blockY, this.blockZ, (Block)Witchery.Blocks.LIGHT);
                        } else {
                            ++this.blockY;
                            if (this.worldObj.isAirBlock(this.blockX, this.blockY, this.blockZ)) {
                                this.worldObj.setBlock(this.blockX, this.blockY, this.blockZ, (Block)Witchery.Blocks.LIGHT);
                            }
                        }
                    }
                }
                if (this.getImpact()) {
                    Object entity = null;
                    List list = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
                    double d0 = 0.0;
                    for (int j = 0; j < list.size(); ++j) {
                        EntityLivingBase entity1 = (EntityLivingBase)list.get(j);
                        if (!entity1.canBeCollidedWith() || !CreatureUtil.isUndead((Entity)entity1)) continue;
                        entity1.setFire(3);
                    }
                }
            }
        }
    }

    @Override
    protected void onSetDead() {
        if (!this.worldObj.isRemote) {
            this.entityDropItem(Witchery.Items.GENERIC.itemQuartzSphere.createStack(), 0.5f);
            int mode = this.getMode();
            if (mode == 0) {
                if (this.blockPlaced) {
                    this.blockPlaced = false;
                    if (this.worldObj.getBlock(this.blockX, this.blockY, this.blockZ) == Witchery.Blocks.LIGHT) {
                        this.worldObj.setBlockToAir(this.blockX, this.blockY, this.blockZ);
                    }
                }
                Object entity = null;
                List list = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(3.0, 2.0, 3.0));
                double d0 = 0.0;
                for (int j = 0; j < list.size(); ++j) {
                    EntityLivingBase entity1 = (EntityLivingBase)list.get(j);
                    if (!entity1.canBeCollidedWith()) continue;
                    if (CreatureUtil.isUndead((Entity)entity1)) {
                        EntityPlayer player;
                        ExtendedPlayer playerEx;
                        entity1.setFire(5);
                        if (entity1 instanceof EntityPlayer && (playerEx = ExtendedPlayer.get(player = (EntityPlayer)entity1)).getVampireLevel() == 4 && playerEx.canIncreaseVampireLevel()) {
                            if (playerEx.getVampireQuestCounter() >= 9) {
                                playerEx.increaseVampireLevel();
                            } else {
                                playerEx.increaseVampireQuestCounter();
                            }
                        }
                    }
                    entity1.addPotionEffect(new PotionEffect(Potion.blindness.id, TimeUtil.secsToTicks(this.worldObj.rand.nextInt(3) + 10), 0, true));
                }
            } else if (mode == 1) {
                EntityFollower entity = new EntityFollower(this.worldObj);
                entity.setFollowerType(5);
                entity.setSkin(this.owner != null ? this.owner : "");
                entity.setCustomNameTag(this.owner != null ? this.owner : "Steve");
                entity.setLocationAndAngles(this.posX, this.posY, this.posZ, 0.0f, 0.0f);
                entity.setTTL(TimeUtil.secsToTicks(10));
                this.worldObj.spawnEntityInWorld((Entity)entity);
                entity.attractAttention();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientSetDead() {
        if (this.getMode() == 0) {
            for (int i = 0; i < 20; ++i) {
                double width = 0.4;
                double xPos = 0.3 + this.rand.nextDouble() * 0.4;
                double zPos = 0.3 + this.rand.nextDouble() * 0.4;
                double d0 = this.posX;
                double d1 = this.posY;
                double d2 = this.posZ;
                NaturePowerFX sparkle = new NaturePowerFX(this.worldObj, d0, d1, d2);
                sparkle.setScale(1.0f);
                sparkle.setGravity(0.2f);
                sparkle.setCanMove(true);
                sparkle.noClip = true;
                double maxSpeed = 0.08;
                double doubleSpeed = 0.16;
                sparkle.setVelocity(this.rand.nextDouble() * 0.16 - 0.08, this.rand.nextDouble() * 0.05 + 0.12, this.rand.nextDouble() * 0.16 - 0.08);
                sparkle.setMaxAge(25 + this.rand.nextInt(10));
                float red = 1.0f;
                float green = 1.0f;
                float blue = 0.0f;
                float maxColorShift = 0.2f;
                float doubleColorShift = maxColorShift * 2.0f;
                float colorshiftR = this.rand.nextFloat() * doubleColorShift - maxColorShift;
                float colorshiftG = this.rand.nextFloat() * doubleColorShift - maxColorShift;
                float colorshiftB = this.rand.nextFloat() * doubleColorShift - maxColorShift;
                sparkle.setRBGColorF(red + colorshiftR, green + colorshiftG, blue + colorshiftB);
                sparkle.setAlphaF(0.1f);
                Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)sparkle);
            }
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setImpact(nbtRoot.getBoolean("Impacted"));
        this.blockPlaced = nbtRoot.getBoolean("BlockPlaced");
        if (this.blockPlaced) {
            this.blockX = nbtRoot.getInteger("BlockPlacedX");
            this.blockY = nbtRoot.getInteger("BlockPlacedY");
            this.blockZ = nbtRoot.getInteger("BlockPlacedZ");
        }
        if (nbtRoot.hasKey("Mode")) {
            this.setMode(nbtRoot.getInteger("Mode"));
        }
        this.owner = nbtRoot.hasKey("Owner") ? nbtRoot.getString("Owner") : null;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setBoolean("Impacted", this.getImpact());
        if (this.blockPlaced) {
            nbtRoot.setBoolean("BlockPlaced", this.blockPlaced);
            nbtRoot.setInteger("BlockPlacedX", this.blockX);
            nbtRoot.setInteger("BlockPlacedY", this.blockY);
            nbtRoot.setInteger("BlockPlacedZ", this.blockZ);
        }
        nbtRoot.setInteger("Mode", this.getMode());
        if (this.owner != null) {
            nbtRoot.setString("Owner", this.owner);
        }
    }
}

