/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.EntityLilith;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityFollower
extends EntityTameable {
    private EntityAIWander aiWander = new EntityAIWander((EntityCreature)this, 0.8);
    int ticksToLive = -1;
    int transformCount;
    @SideOnly(value=Side.CLIENT)
    private ThreadDownloadImageData downloadImageSkin;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationSkin;
    private static final String[] FIRST_NAMES_M = new String[]{"Abraham", "Adam", "Adrian", "Alex", "Alexander", "Allen", "Ambrose", "Andrew", "Anthony", "Arthur", "Avery", "Barnaby", "Bartholomew", "Benedict", "Benjamin", "Bernard", "Billy", "Bobby", "Charles", "Charley", "Christopher", "Colin", "Conrad", "Cuthbert", "Daniel", "Danny", "Davey", "David", "Edmund", "Edward", "Francis", "Fred", "Freddy", "Geoffrey", "George", "Georgie", "Gerard", "Gilbert", "Giles", "Gregory", "Hans", "Hansel", "Heinrich", "Henry", "Hugh", "Humphrey", "Isaac", "Jack", "Jacques", "James", "Jamie", "Jerome", "Jim", "Jimmy", "John", "Johnny", "Joseph", "Julian", "Lancelot", "Lawrence", "Leonard", "Lou", "Luke", "Mark", "Martin", "Mathias", "Matthew", "Merlin", "Michael", "Miles", "Nat", "Nathan", "Nathaniel", "Ned", "Nicholas", "Oliver", "Oswyn", "Patrick", "Paul", "Peter", "Philip", "Piers", "Ralph", "Reynold", "Richard", "Ricky", "Robert", "Robin", "Roger", "Rowland", "Samuel", "Simon", "Solomon", "Stephen", "Terence", "Thomas", "Tim", "Tobias", "Tom", "Tommy", "Valentine", "Walter", "Wendell", "Will", "William", "Willie"};
    private static final String[] FIRST_NAMES_F = new String[]{"Agnes", "Alice", "Amy", "Anna", "Annabella", "Anne", "Arabella", "Audrey", "Avis", "Barbara", "Beatrice", "Becky", "Bella", "Belle", "Bertha", "Bessy", "Betty", "Blanche", "Bo", "Bonny", "Bridget", "Catalina", "Catherine", "Cecily", "Charity", "Charlotte", "Christina", "Christine", "Cinderella", "Cindy", "Clara", "Clarissa", "Clemence", "Clementine", "Constance", "Daisy", "Denise", "Dorothy", "Edith", "Elinor", "Elizabeth", "Ella", "Ellen", "Elsa", "Elsie", "Emma", "Eve", "Evelyn", "Fawn", "Flora", "Florence", "Floretta", "Fortune", "Frances", "Frideswide", "Gertrude", "Gillian", "Ginger", "Goat", "Goatley", "Goldie", "Grace", "Gretel", "Helen", "Hilda", "Hazel", "Isabel", "Jane", "Janet", "Jemima", "Jill", "Joan", "Joyce", "Judith", "Julia", "Juliet", "Katherine", "Katie", "Kitty", "Lena", "Lily", "Liza", "Lizzie", "Lucy", "Mabel", "Maggie", "Margaret", "Margery", "Maria", "Marion", "Marlene", "Martha", "Mary", "Maud", "Mildred", "Millicent", "Molly", "Odette", "Pansy", "Pearl", "Petunia", "Philippa", "Polly", "Rachel", "Rapunzel", "Rebecca", "Rose", "Rosie", "Ruth", "Sarah", "Shiela", "Snow", "Susanna", "Susie", "Sybil", "Talia", "Thomasina", "Trudy", "Ursula", "Winifred"};
    private static final String[] SURNAMES = new String[]{"Apple", "Applegreen", "Applerose", "Appleseed", "Appleton", "Applewhite", "Baker", "Barnes", "Bean", "Beanblossom", "Beanstock", "Beaste", "Beasten", "Bell", "Berry", "Bird", "Blackbird", "Blackwood", "Boar", "Botter", "Bowers", "Bremen", "Brockett", "Buckle", "Butcher", "Candle", "Castle", "Castleton", "Cherry", "Cherrytree", "Cherrywood", "Cherrywell", "Cottage", "Daw", "Deer", "Dilly", "Dove", "Duck", "Duckfield", "Duckling", "Faery", "Fairy", "Fiddle", "Fiddler", "Fisher", "Fitcher", "Flinders", "Friday", "Frogg", "Frogley", "Frost", "Gold", "Goldencrown", "Goldhair", "Goodfellow", "Goose", "Gooseberry", "Gosling", "Gray", "Green", "Greengrass", "Griggs", "Grimm", "Grundy", "Hare", "Hay", "Hazeltree", "Hickory", "Hood", "Horner", "Hubbard", "Hunter", "Korbes", "Lamb", "Lampkin", "Lark", "Locket", "Locks", "MacDonald", "Mack", "Malone", "Marsh", "McDiddler", "Meadow", "Meadows", "Merrypips", "Miller", "Mills", "Mockingbird", "Monday", "Mouse", "Mouseley", "Muffet", "Mulberry", "Nimble", "Nutt", "O'Hare", "O'Lairy", "Pea", "Peartree", "Pease", "Peep", "Pie", "Pigeon", "Pinchme", "Piper", "Porgy", "Porridge", "Pott", "Pumpkin", "Pumpkinseed", "Reynard", "River", "Rivers", "Roley", "Rooster", "Roseberry", "Rosebottom", "Roseleaf", "Shoe", "Shoemaker", "Shorter", "Silver", "Slipper", "Sprat", "Saturday", "Sparrow", "Spindle", "Spindler", "Spinner", "Star", "Stone", "Stonebridge", "Sunday", "Swan", "Tailor", "Thatcher", "Thumb", "Thursday", "Toad", "Tower", "Towers", "Trot", "Tucker", "Tuesday", "Twist", "Wednesday", "White", "Whittington", "Winkie", "Wolf", "Wolfram", "Wolfson", "Wolfwood", "Woodcroft", "Woods"};

    public EntityFollower(World world) {
        super(world);
        this.setSize(0.6f, 1.8f);
        this.getNavigator().setCanSwim(true);
        this.getNavigator().setAvoidsWater(false);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 2.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 2.0f, 4.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.experienceValue = 0;
    }

    protected int getExperiencePoints(EntityPlayer p_70693_1_) {
        return 0;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
    }

    public void setTTL(int ticks) {
        this.ticksToLive = ticks;
    }

    public EntityAgeable createChild(EntityAgeable lover) {
        return null;
    }

    public String getCommandSenderName() {
        switch (this.getFollowerType()) {
            case 0: {
                return Witchery.resource("entity.witchery.follower.elle.name");
            }
        }
        return super.getCommandSenderName();
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(19, (Object)String.valueOf(""));
    }

    public String getSkin() {
        return this.dataWatcher.getWatchableObjectString(19);
    }

    public void setSkin(String mode) {
        this.dataWatcher.updateObject(19, (Object)mode);
    }

    public int getFollowerType() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    public void onEntityUpdate() {
        EntityPlayer player;
        String skin;
        super.onEntityUpdate();
        if (!this.worldObj.isRemote && this.ticksExisted == 1 && this.getFollowerType() == 5 && (skin = this.getSkin()) != null && !skin.isEmpty() && (player = this.worldObj.getPlayerEntityByName(this.getSkin())) != null) {
            for (int i = 0; i <= 4; ++i) {
                ItemStack stack = player.getEquipmentInSlot(i);
                if (stack != null) {
                    this.setCurrentItemOrArmor(i, stack.copy());
                    continue;
                }
                this.setCurrentItemOrArmor(i, null);
            }
        }
        if (!this.worldObj.isRemote && this.ticksExisted % 40 == 5 && this.getFollowerType() == 5) {
            this.attractAttention();
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.worldObj.isRemote && this.isEntityAlive() && this.ticksToLive >= 0 && --this.ticksToLive == 0) {
            this.setDead();
        }
    }

    public void setFollowerType(int followerType) {
        this.dataWatcher.updateObject(18, (Object)followerType);
        if (followerType == 0) {
            this.isImmuneToFire = true;
        } else if (followerType <= 5) {
            this.tasks.addTask(5, (EntityAIBase)this.aiWander);
        }
    }

    protected int decreaseAirSupply(int par1) {
        if (this.getFollowerType() == 0) {
            return par1;
        }
        return super.decreaseAirSupply(par1);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void dropEquipment(boolean p_82160_1_, int p_82160_2_) {
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (this.getFollowerType() >= 1 && this.getFollowerType() <= 4) {
            this.entityDropItem(Witchery.Items.GENERIC.itemHeartOfGold.createStack(), 0.1f);
        }
    }

    private boolean isCourseTraversable(double waypointX, double waypointY, double waypointZ, double p_70790_7_) {
        double d4 = (waypointX - this.posX) / p_70790_7_;
        double d5 = (waypointY - this.posY) / p_70790_7_;
        double d6 = (waypointZ - this.posZ) / p_70790_7_;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        int i = 1;
        while ((double)i < p_70790_7_) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.worldObj.getCollidingBoundingBoxes((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.worldObj.isRemote && this.ticksExisted % 10 == 1 && this.getFollowerType() == 0) {
            this.doElleAI();
        }
    }

    public void doElleAI() {
        block6: {
            block3: {
                double waypointZ;
                double waypointY;
                block4: {
                    block5: {
                        if (!this.hasHome()) break block3;
                        if (!this.isWithinHomeDistanceCurrentPosition()) break block4;
                        ++this.transformCount;
                        if (this.transformCount != 20) break block5;
                        EntityLivingBase owner = this.getOwner();
                        if (owner == null || !(owner instanceof EntityPlayer)) break block6;
                        ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)((EntityPlayer)owner), "item.witchery:glassgoblet.lilithquestsummon", new Object[0]);
                        SoundEffect.WITCHERY_MOB_LILITH_TALK.playAt((EntityLiving)this);
                        break block6;
                    }
                    if (this.transformCount != 40) break block6;
                    this.transformCount = 0;
                    ParticleEffect.INSTANT_SPELL.send(SoundEffect.FIREWORKS_BLAST1, (Entity)this, 1.0, 1.0, 16);
                    EntityLilith vampire = new EntityLilith(this.worldObj);
                    vampire.func_110163_bv();
                    vampire.copyLocationAndAnglesFrom((Entity)this);
                    vampire.onSpawnWithEgg(null);
                    this.worldObj.removeEntity((Entity)this);
                    this.worldObj.spawnEntityInWorld((Entity)vampire);
                    vampire.worldObj.playAuxSFXAtEntity(null, 1017, (int)vampire.posX, (int)vampire.posY, (int)vampire.posZ, 0);
                    EntityLivingBase owner = this.getOwner();
                    if (owner != null && owner instanceof EntityPlayer) {
                        ChatUtil.sendTranslated(EnumChatFormatting.DARK_PURPLE, (ICommandSender)((EntityPlayer)owner), "item.witchery:glassgoblet.lilithquestsummon2", new Object[0]);
                        SoundEffect.WITCHERY_MOB_LILITH_TALK.playAt((EntityLiving)vampire);
                    }
                    this.worldObj.createExplosion((Entity)vampire, vampire.posX, vampire.posY, vampire.posZ, 6.0f, true);
                    break block6;
                }
                double d0 = (double)this.getHomePosition().posX - this.posX;
                double d1 = (double)this.getHomePosition().posY - this.posY;
                double d2 = (double)this.getHomePosition().posZ - this.posZ;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (!(d3 > 0.0)) break block6;
                d3 = MathHelper.sqrt_double((double)d3);
                double waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                if (this.isCourseTraversable(waypointX, waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f), waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f), d3)) {
                    this.motionX += d0 / d3 * 0.2;
                    this.motionY += d1 / d3 * 0.2;
                    this.motionZ += d2 / d3 * 0.2;
                }
                break block6;
            }
            for (int i = 0; i < 10; ++i) {
                int l;
                int k;
                int j = MathHelper.floor_double((double)(this.posX + (double)this.rand.nextInt(30) - 15.0));
                if (!EntityFollower.isLavaPool(this.worldObj, j, k = MathHelper.floor_double((double)(this.boundingBox.minY + (double)this.rand.nextInt(6) - 3.0)), l = MathHelper.floor_double((double)(this.posZ + (double)this.rand.nextInt(30) - 15.0)), 6)) continue;
                this.setHomeArea(j, k, l, 2);
                this.func_152115_b("");
                break;
            }
        }
    }

    private static boolean isLavaPool(World world, int x, int y, int z, int max) {
        if (EntityFollower.isLavaPoolColumn(world, x, y, z) && EntityFollower.isLavaPoolColumn(world, x + 1, y, z) && EntityFollower.isLavaPoolColumn(world, x - 1, y, z) && EntityFollower.isLavaPoolColumn(world, x, y, z + 1) && EntityFollower.isLavaPoolColumn(world, x, y, z - 1)) {
            int max2 = max * max;
            for (int dx = x - max; dx <= x + max; ++dx) {
                for (int dz = z - max; dz <= z + max; ++dz) {
                    double dist = Coord.distanceSq(x, y, z, dx, y, dz);
                    if (!(dist <= (double)max2) || world.getBlock(dx, y, dz) == Blocks.lava) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isLavaPoolColumn(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) == Blocks.lava && world.isAirBlock(x, y + 1, z) && world.isAirBlock(x, y + 2, z)) {
            int depth = 4;
            for (int dy = y - depth; dy < dy; ++dy) {
                if (world.getBlock(x, y, z) == Blocks.lava) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setOwner(EntityPlayer player) {
        this.setTamed(true);
        this.setPathToEntity(null);
        this.setAttackTarget(null);
        this.setHealth(20.0f);
        this.func_152115_b(player.getUniqueID().toString());
        this.worldObj.setEntityState((Entity)this, (byte)7);
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.setFollowerType(nbtRoot.getInteger("FollowerType"));
        this.ticksToLive = nbtRoot.hasKey("TicksToLive") ? nbtRoot.getInteger("TicksToLive") : -1;
        if (nbtRoot.hasKey("Skin")) {
            this.setSkin(nbtRoot.getString("Skin"));
        }
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setInteger("FollowerType", this.getFollowerType());
        nbtRoot.setInteger("TicksToLive", this.ticksToLive);
        nbtRoot.setString("Skin", this.getSkin());
    }

    public static String generateFollowerName(int followerType) {
        Random ra = new Random();
        if (followerType != 4) {
            return String.format("%s %s", FIRST_NAMES_F[ra.nextInt(FIRST_NAMES_F.length)], SURNAMES[ra.nextInt(SURNAMES.length)]);
        }
        return String.format("%s %s", FIRST_NAMES_M[ra.nextInt(FIRST_NAMES_M.length)], SURNAMES[ra.nextInt(SURNAMES.length)]);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationSkin() {
        if (this.locationSkin == null) {
            this.setupCustomSkin();
        }
        if (this.locationSkin != null) {
            return this.locationSkin;
        }
        return AbstractClientPlayer.locationStevePng;
    }

    @SideOnly(value=Side.CLIENT)
    private void setupCustomSkin() {
        String owner = this.getSkin();
        if (owner != null && !owner.isEmpty()) {
            this.locationSkin = AbstractClientPlayer.getLocationSkin((String)owner);
            this.downloadImageSkin = AbstractClientPlayer.getDownloadImageSkin((ResourceLocation)this.locationSkin, (String)owner);
        }
    }

    public void attractAttention() {
        EntityPlayer player;
        String owner;
        if (!this.worldObj.isRemote && (owner = this.getSkin()) != null && !owner.isEmpty() && (player = this.worldObj.getPlayerEntityByName(owner)) != null) {
            List list = this.worldObj.getEntitiesWithinAABB(EntityMob.class, this.boundingBox.expand(16.0, 8.0, 16.0));
            for (EntityMob mob : list) {
                if (mob.getAttackTarget() != player) continue;
                mob.setRevengeTarget((EntityLivingBase)this);
                mob.setAttackTarget((EntityLivingBase)this);
                mob.setTarget((Entity)this);
            }
        }
    }
}

