/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.entity.ai.EntityAIFamiliarFindDiamonds;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityFamiliar
extends EntityOcelot {
    private int searches = 0;
    private static final int WATCH_KEY_OBJ_TO_FIND = 23;
    private static final Item[] ITEMS = new Item[]{Items.diamond, Items.emerald, Items.gold_ingot, Items.iron_ingot, Items.redstone, Items.dye, Items.coal};
    private static final Block[] ORES = new Block[]{Blocks.diamond_ore, Blocks.emerald_ore, Blocks.gold_ore, Blocks.iron_ore, Blocks.redstone_ore, Blocks.lapis_ore, Blocks.coal_ore};
    private static final Integer[] ORE_DEPTH = new Integer[]{14, 14, 30, 64, 16, 30, 64};

    public EntityFamiliar(World world) {
        super(world);
        this.setSize(0.8f, 0.8f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.taskEntries.clear();
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)this.aiSit);
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIFamiliarFindDiamonds(this, 1.33));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)this));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
    }

    protected void entityInit() {
        super.entityInit();
        this.setTameSkin(1);
        this.dataWatcher.addObject(23, (Object)-1);
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.familiar.name");
    }

    public void setItemIDToFind(int itemID) {
        this.dataWatcher.updateObject(23, (Object)itemID);
    }

    public int getItemIDToFind() {
        return this.dataWatcher.getWatchableObjectInt(23);
    }

    public void writeEntityToNBT(NBTTagCompound nbtTag) {
        super.writeEntityToNBT(nbtTag);
        nbtTag.setInteger("ItemToFind", this.getItemIDToFind());
        nbtTag.setInteger("Searches", this.searches);
    }

    public void readEntityFromNBT(NBTTagCompound nbtTag) {
        super.readEntityFromNBT(nbtTag);
        this.setItemIDToFind(nbtTag.getInteger("ItemToFind"));
        this.searches = nbtTag.getInteger("Searches");
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        super.getShadowSize();
        return 0.0f;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(40.0);
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 0.5f);
    }

    public boolean interact(EntityPlayer player) {
        if (this.isTamed() && TameableUtil.isOwner((EntityTameable)this, player) && !this.worldObj.isRemote) {
            ItemStack item = player.getCurrentEquippedItem();
            int itemToFind = this.hasOre(item);
            if (itemToFind != -1) {
                this.setItemIDToFind(itemToFind);
                ++this.searches;
                --item.stackSize;
                if (item.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
                double[] probs = new double[]{0.0, 0.6, 0.75, 0.85, 0.95};
                double chance = this.worldObj.rand.nextDouble();
                if (this.searches > 5 || this.searches > 1 && chance < probs[Math.max(this.searches - 1, 1)]) {
                    ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)this, 1.0, 1.0, 16);
                    this.setDead();
                } else {
                    SoundEffect.RANDOM_ORB.playAtPlayer(player.worldObj, player);
                }
            } else {
                this.aiSit.setSitting(!this.isSitting());
            }
        }
        return true;
    }

    public Block getBlockIDToFind() {
        int idToFind = this.getItemIDToFind();
        if (idToFind != -1) {
            return ORES[idToFind];
        }
        return null;
    }

    public void clearItemToFind() {
        this.setItemIDToFind(-1);
    }

    public int getDepthToFind() {
        int idToFind = this.getItemIDToFind();
        if (idToFind != -1) {
            return ORE_DEPTH[idToFind];
        }
        return 1;
    }

    private int hasOre(ItemStack item) {
        if (item == null) {
            return -1;
        }
        return Arrays.asList(ITEMS).indexOf(item.getItem());
    }

    protected String getLivingSound() {
        return "mob.pig.say";
    }

    protected String getHurtSound() {
        return "mob.pig.say";
    }

    protected String getDeathSound() {
        return "mob.pig.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.pig.step", 0.15f, 1.0f);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.entityDropItem(Witchery.Items.GENERIC.itemSpectralDust.createStack(), 0.0f);
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    public EntityOcelot createChild(EntityAgeable par1EntityAgeable) {
        return null;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        this.getEntityAttribute(SharedMonsterAttributes.followRange).applyModifier(new AttributeModifier("Random spawn bonus", this.rand.nextGaussian() * 0.05, 1));
        return data;
    }

    public void setAISitting(boolean b) {
        this.setSitting(true);
        this.aiSit.setSitting(true);
    }
}

