/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.entity.ai.EntityAIAttackCloseTargetOnCollide;
import com.emoniph.witchery.entity.ai.EntityAIDemonicBarginPlayer;
import com.emoniph.witchery.entity.ai.EntityAILookAtDemonicBarginPlayer;
import com.emoniph.witchery.util.Config;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityDemon
extends EntityGolem
implements IRangedAttackMob,
IMerchant {
    private int attackTimer;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int tryEscape = -1;

    public EntityDemon(World par1World) {
        super(par1World);
        this.setSize(1.0f, 2.9f);
        this.isImmuneToFire = true;
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAttackCloseTargetOnCollide((EntityCreature)this, 1.0, true, 3.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIDemonicBarginPlayer(this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookAtDemonicBarginPlayer(this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true));
        this.experienceValue = 10;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.witchery.demon.name");
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        if (this.dimension != Config.instance().dimensionDreamID) {
            boolean flag;
            ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
            boolean bl = flag = itemstack != null && (itemstack.getItem() == Items.spawn_egg || itemstack.getItem() == Items.name_tag);
            if (!flag && this.isEntityAlive() && !this.isTrading() && !this.isChild()) {
                if (!this.worldObj.isRemote) {
                    this.setCustomer(par1EntityPlayer);
                    par1EntityPlayer.displayGUIMerchant((IMerchant)this, this.getCommandSenderName());
                }
                return true;
            }
            return super.interact(par1EntityPlayer);
        }
        return super.interact(par1EntityPlayer);
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void updateAITick() {
        super.updateAITick();
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        return super.attackEntityFrom(par1DamageSource, Math.min(par2, 15.0f));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(100.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    protected void collideWithEntity(Entity par1Entity) {
        super.collideWithEntity(par1Entity);
    }

    public void onLivingUpdate() {
        int k;
        int j;
        int i;
        Block l;
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.dimension == Config.instance().dimensionDreamID && this.worldObj.provider instanceof WorldProviderDreamWorld && !((WorldProviderDreamWorld)this.worldObj.provider).isDemonicNightmare()) {
            this.setDead();
        }
        if (this.tryEscape == 0) {
            this.tryEscape = -1;
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 3.0f, true);
        } else if (this.tryEscape > 0) {
            --this.tryEscape;
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > 2.500000277905201E-7 && this.rand.nextInt(5) == 0 && (l = this.worldObj.getBlock(i = MathHelper.floor_double((double)this.posX), j = MathHelper.floor_double((double)(this.posY - (double)0.2f - (double)this.yOffset)), k = MathHelper.floor_double((double)this.posZ))) != Blocks.air) {
            this.worldObj.spawnParticle("tilecrack_" + l + "_" + this.worldObj.getBlockMetadata(i, j, k), this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.boundingBox.minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
        }
    }

    public boolean canAttackClass(Class par1Class) {
        return super.canAttackClass(par1Class);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("PlayerCreated", this.isPlayerCreated());
        if (this.buyingList != null) {
            par1NBTTagCompound.setTag("Bargains", (NBTBase)this.buyingList.getRecipiesAsTags());
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setPlayerCreated(par1NBTTagCompound.getBoolean("PlayerCreated"));
        if (par1NBTTagCompound.hasKey("Bargains")) {
            NBTTagCompound nbttagcompound1 = par1NBTTagCompound.getCompoundTag("Bargains");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            par1Entity.motionY += (double)0.4f;
        }
        this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    protected String getLivingSound() {
        return "mob.blaze.breathe";
    }

    protected String getHurtSound() {
        return "mob.wither.hurt";
    }

    protected String getDeathSound() {
        return "mob.wither.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.irongolem.walk", 1.0f, 1.0f);
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (par1) {
            int j = this.rand.nextInt(2 + par2);
            for (int k = 0; k < j; ++k) {
                this.dropItem(Items.magma_cream, 1);
            }
        }
    }

    protected Item getDropItem() {
        return Items.magma_cream;
    }

    public boolean isPlayerCreated() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setPlayerCreated(boolean par1) {
        this.func_110163_bv();
        byte b0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
    }

    protected boolean canDespawn() {
        return true;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase targetEntity, float par2) {
        if (targetEntity.getHeldItem() == null || targetEntity.getHeldItem().getItem() != Witchery.Items.DEVILS_TONGUE_CHARM || this.worldObj.rand.nextDouble() < 0.05) {
            double d0 = targetEntity.posX - this.posX;
            double d1 = targetEntity.boundingBox.minY + (double)(targetEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d2 = targetEntity.posZ - this.posZ;
            float f1 = MathHelper.sqrt_float((float)par2) * 0.5f;
            EntityLargeFireball fireballEntity = new EntityLargeFireball(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1);
            double d8 = 1.0;
            Vec3 vec3 = this.getLook(1.0f);
            fireballEntity.posX = this.posX + vec3.xCoord * d8;
            fireballEntity.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
            fireballEntity.posZ = this.posZ + vec3.zCoord * d8;
            if (!this.worldObj.isRemote) {
                this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                this.worldObj.spawnEntityInWorld((Entity)fireballEntity);
            }
        }
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        this.addPotionEffect(new PotionEffect(Potion.jump.id, Integer.MAX_VALUE, 4));
        return super.onSpawnWithEgg(par1EntityLivingData);
    }

    public void setCustomer(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public EntityPlayer getCustomer() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void useRecipe(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.incrementToolUses();
        Item itemToBuy = par1MerchantRecipe.getItemToBuy().getItem();
        if (!(this.worldObj.isRemote || itemToBuy != Items.magma_cream && itemToBuy != Items.blaze_rod)) {
            this.playSound("mob.wither.shoot", this.getSoundVolume(), this.getSoundPitch());
            this.tryEscape = 50;
        } else {
            this.playSound("random.breath", this.getSoundVolume(), this.getSoundPitch());
        }
        if (this.getCustomer() != null && this.getCustomer().getHeldItem() != null && this.getCustomer().getHeldItem().getItem() == Witchery.Items.DEVILS_TONGUE_CHARM) {
            this.getCustomer().getHeldItem().damageItem(5, (EntityLivingBase)this.getCustomer());
            if (this.getCustomer().getHeldItem().stackSize <= 0) {
                this.getCustomer().destroyCurrentEquippedItem();
            }
        }
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
        if (!this.worldObj.isRemote && this.livingSoundTime > -this.getTalkInterval() + 20) {
            this.livingSoundTime = -this.getTalkInterval();
            if (par1ItemStack != null) {
                this.playSound("random.breath", this.getSoundVolume(), this.getSoundPitch());
            } else {
                this.playSound("mob.wither.idle", this.getSoundVolume(), this.getSoundPitch());
            }
        }
    }

    protected void attackEntity(Entity entity, float par2) {
        if (this.attackTime <= 0 && par2 < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(entity);
        }
        super.attackEntity(entity, par2);
    }

    public MerchantRecipeList getRecipes(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies(this.rand.nextInt(4) + 6);
        }
        if (this.getCustomer() != null && this.getCustomer().getHeldItem() != null && this.getCustomer().getHeldItem().getItem() == Witchery.Items.DEVILS_TONGUE_CHARM) {
            MerchantRecipeList list = new MerchantRecipeList();
            for (Object recipeObj : this.buyingList) {
                MerchantRecipe recipe = (MerchantRecipe)recipeObj;
                NBTTagCompound nbtTag = recipe.writeToTags();
                MerchantRecipe recipe2 = new MerchantRecipe(nbtTag);
                ItemStack cost = recipe2.getItemToBuy();
                cost.stackSize = Math.max(cost.stackSize - (cost.getItem() == Items.gold_ingot ? 5 : (cost.getItem() == Items.emerald ? 2 : (cost.getItem() == Items.diamond ? 0 : 1))), 1);
                list.add((Object)recipe2);
            }
            return list;
        }
        return this.buyingList;
    }

    private Item getCurrency() {
        double chance = this.rand.nextDouble();
        if (chance < 0.2) {
            return Items.blaze_rod;
        }
        if (chance < 0.4) {
            return Items.magma_cream;
        }
        if (chance < 0.5) {
            return Items.diamond;
        }
        if (chance < 0.75) {
            return Items.emerald;
        }
        return Items.gold_ingot;
    }

    private ItemStack getPrice(int basePriceInEmeralds) {
        Item currency = this.getCurrency();
        int multiplier = currency == Items.gold_ingot ? 1 : (currency == Items.emerald ? 3 : (currency == Items.diamond ? 5 : 4));
        int quantity = Math.max(1, basePriceInEmeralds / multiplier);
        return new ItemStack(currency, quantity);
    }

    private void addDefaultEquipmentAndRecipies(int par1) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        int STOCK_REDUCTION = -5;
        for (int i = 0; i < par1; ++i) {
            Enchantment enchantment = Enchantment.enchantmentsBookList[this.rand.nextInt(Enchantment.enchantmentsBookList.length)];
            int k = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)enchantment.getMinLevel(), (int)enchantment.getMaxLevel());
            ItemStack itemstack = Items.enchanted_book.getEnchantedItemStack(new EnchantmentData(enchantment, k));
            int j = 2 + this.rand.nextInt(5 + k * 10) + 3 * k;
            MerchantRecipe recipe = new MerchantRecipe(this.getPrice(j), itemstack);
            recipe.func_82783_a(-5);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.rand.nextDouble() < 0.25) {
            MerchantRecipe recipe = new MerchantRecipe(this.getPrice(this.rand.nextInt(3) + 8), Witchery.Items.GENERIC.itemSpectralDust.createStack(this.rand.nextInt(4) + 3));
            recipe.func_82783_a(-5);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.rand.nextDouble() < 0.25) {
            MerchantRecipe recipe = new MerchantRecipe(this.getPrice(this.rand.nextInt(3) + 8), Witchery.Items.GENERIC.itemDogTongue.createStack(this.rand.nextInt(4) + 4));
            recipe.func_82783_a(-5);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.rand.nextDouble() < 0.15) {
            MerchantRecipe recipe = new MerchantRecipe(this.getPrice(this.rand.nextInt(10) + 20), Witchery.Items.GENERIC.itemRedstoneSoup.createStack(1));
            recipe.func_82783_a(-5);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.rand.nextDouble() < 0.15) {
            MerchantRecipe recipe = new MerchantRecipe(new ItemStack(Items.diamond), new ItemStack(Items.ghast_tear, 2));
            recipe.func_82783_a(-5);
            merchantrecipelist.add((Object)recipe);
        }
        if (this.rand.nextDouble() < 0.15) {
            MerchantRecipe recipe = new MerchantRecipe(new ItemStack(Items.diamond), new ItemStack(Items.ender_pearl, 2));
            recipe.func_82783_a(-5);
            merchantrecipelist.add((Object)recipe);
        }
        Collections.shuffle(merchantrecipelist);
        Item currencyForHeart = this.getCurrency();
        MerchantRecipe heartRecipe = new MerchantRecipe(new ItemStack(currencyForHeart, currencyForHeart == Items.gold_ingot ? 30 : 3), Witchery.Items.GENERIC.itemDemonHeart.createStack(1));
        heartRecipe.func_82783_a(-5);
        merchantrecipelist.add(this.rand.nextInt(3), (Object)heartRecipe);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int j1 = 0; j1 < par1 && j1 < merchantrecipelist.size(); ++j1) {
            this.buyingList.add(merchantrecipelist.get(j1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setRecipes(MerchantRecipeList par1MerchantRecipeList) {
    }
}

