/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.entity;

import com.emoniph.witchery.ritual.rites.RiteProtectionCircleRepulsive;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.TimeUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityDarkMark
extends EntityLiving {
    private long ticksAlive = 0L;

    public EntityDarkMark(World world) {
        super(world);
        this.isImmuneToFire = true;
        this.setSize(2.0f, 2.0f);
        this.tasks.addTask(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
    }

    protected void entityInit() {
        super.entityInit();
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    protected float getSoundPitch() {
        return 1.0f;
    }

    public int getTalkInterval() {
        return 80;
    }

    protected String getLivingSound() {
        return "witchery:mob.torment.laugh";
    }

    protected String getHurtSound() {
        return null;
    }

    protected String getDeathSound() {
        return null;
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity par1Entity) {
    }

    protected void collideWithNearbyEntities() {
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.ticksAlive = Math.max((long)this.ticksExisted, ++this.ticksAlive);
        if (this.ticksAlive > (long)TimeUtil.minsToTicks(5)) {
            if (!this.worldObj.isRemote) {
                this.setDead();
            }
        } else if (this.worldObj.isRemote && TimeUtil.ticksElapsed(4, this.ticksAlive)) {
            double radius = 10.0;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(this.posX - 10.0), (double)1.0, (double)(this.posZ - 10.0), (double)(this.posX + 10.0), (double)255.0, (double)(this.posZ + 10.0));
            List list = this.worldObj.getEntitiesWithinAABB(EntityCreature.class, bounds);
            for (Entity entity : list) {
                if (!(Coord.distance(entity.posX, 1.0, entity.posZ, this.posX, 1.0, this.posZ) <= 10.0)) continue;
                RiteProtectionCircleRepulsive.push(this.worldObj, entity, this.posX, entity.posY, this.posZ);
            }
        }
    }

    public void onUpdate() {
        super.onUpdate();
        this.motionY = 0.0;
        if (this.worldObj.isRemote) {
            for (int i = 0; i < 5; ++i) {
                this.worldObj.spawnParticle(ParticleEffect.LARGE_SMOKE.toString(), this.posX - 1.4 + this.worldObj.rand.nextDouble() * 2.8, this.posY + this.worldObj.rand.nextDouble() * 2.0, this.posZ - 1.4 + this.worldObj.rand.nextDouble() * 2.8, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void dropFewItems(boolean par1, int par2) {
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        return false;
    }

    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        this.ticksAlive = nbtRoot.getLong("WITCTicksAlive");
    }

    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        nbtRoot.setLong("WITCTicksAlive", this.ticksAlive);
    }
}

