/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.dimension;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.dimension.WorldChunkManagerTorment;
import com.emoniph.witchery.entity.EntityLordOfTorment;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.item.ItemGeneral;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.ServerUtil;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ForgeModContainer;

public class WorldProviderTorment
extends WorldProvider {
    public static final String SPIRIT_WORLD_TORMENT_PLAYER_KEY = "WITCForceTorment";
    public static final String SPIRIT_WORLD_TORMENT_LEVEL_KEY = "WITCForceTormentLevel";
    public static final int TORMENT_NONE = 0;
    public static final int TORMENT_BEGIN = 1;
    public static final int TORMENT_BEGIN_WITH_BOSS = 2;
    public static final int TORMENT_END = 3;

    public String getDimensionName() {
        return "Torment";
    }

    public IChunkProvider createChunkGenerator() {
        return new WorldChunkManagerTorment(this.worldObj);
    }

    public boolean canRespawnHere() {
        return false;
    }

    public boolean isSurfaceWorld() {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean isBlockHighHumidity(int x, int y, int z) {
        return false;
    }

    public boolean isDaytime() {
        return false;
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(8, 14, 8);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return true;
    }

    public float calculateCelestialAngle(long par1, float par3) {
        return 1.0f;
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        int multiplier;
        float f1 = this.worldObj.getCelestialAngle(partialTicks);
        float f2 = MathHelper.cos((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int i = MathHelper.floor_double((double)cameraEntity.posX);
        int j = MathHelper.floor_double((double)cameraEntity.posY);
        int k = MathHelper.floor_double((double)cameraEntity.posZ);
        GameSettings settings = Minecraft.getMinecraft().gameSettings;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.fancyGraphics && settings.renderDistanceChunks >= 0 && settings.renderDistanceChunks < ranges.length) {
            distance = ranges[settings.renderDistanceChunks];
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                BiomeGenBase biome = this.worldObj.getBiomeGenForCoords(i + x, k + z);
                int colour = 0xFF0000;
                r += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b += colour & 0xFF;
                ++divider;
            }
        }
        int l = multiplier = (r / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b / divider & 0xFF;
        float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(l & 0xFF) / 255.0f;
        return Vec3.createVectorHelper((double)f4, (double)f5, (double)f6);
    }

    public static void setPlayerMustTorment(EntityPlayer player, int torment, int presetLevel) {
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        WorldProviderTorment.setPlayerMustTorment(nbtPlayer, torment, presetLevel);
    }

    public static void setPlayerMustTorment(NBTTagCompound nbtPlayer, int torment, int presetLevel) {
        nbtPlayer.setInteger(SPIRIT_WORLD_TORMENT_PLAYER_KEY, torment);
        if (presetLevel > -1) {
            nbtPlayer.setInteger(SPIRIT_WORLD_TORMENT_LEVEL_KEY, presetLevel);
        } else if (presetLevel == -2 && nbtPlayer.hasKey(SPIRIT_WORLD_TORMENT_LEVEL_KEY)) {
            nbtPlayer.removeTag(SPIRIT_WORLD_TORMENT_LEVEL_KEY);
        }
    }

    public static int getRandomTormentLevel(World world) {
        return world.rand.nextInt(6);
    }

    public static int getPlayerMustTorment(EntityPlayer player) {
        NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
        return WorldProviderTorment.getPlayerMustTorment(nbtPlayer);
    }

    public static int getPlayerMustTorment(NBTTagCompound nbtPlayer) {
        return nbtPlayer.getInteger(SPIRIT_WORLD_TORMENT_PLAYER_KEY);
    }

    public static void updatePlayerEffects(World world, EntityPlayer player, NBTTagCompound nbtPlayer, long time, long counter) {
        if (!world.isRemote) {
            boolean done = false;
            if (counter % 20L == 0L) {
                int mustTorment = WorldProviderTorment.getPlayerMustTorment(nbtPlayer);
                if (mustTorment == 1 || mustTorment == 2) {
                    int level = mustTorment == 2 ? nbtPlayer.getInteger(SPIRIT_WORLD_TORMENT_LEVEL_KEY) : WorldProviderTorment.getRandomTormentLevel(world);
                    WorldProviderTorment.setPlayerMustTorment(nbtPlayer, 0, -1);
                    if (player.isRiding()) {
                        player.mountEntity(null);
                    }
                    ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)player, 1.0, 2.0, 16);
                    int yPos = 12 + level * 15;
                    player.setPositionAndUpdate(8.0, (double)yPos, 8.0);
                    ItemGeneral cfr_ignored_0 = Witchery.Items.GENERIC;
                    ItemGeneral.travelToDimension(player, Config.instance().dimensionTormentID);
                    player.setPositionAndUpdate(8.0, (double)yPos, 8.0);
                    ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)player, 1.0, 2.0, 16);
                    WorldServer tormentWorld = ServerUtil.getWorld(Config.instance().dimensionTormentID);
                    int midX = 8;
                    int midZ = 8;
                    for (int x = midX - 1; x <= midX + 1; ++x) {
                        for (int z = midZ - 1; z <= midZ + 1; ++z) {
                            if (!tormentWorld.isAirBlock(x, yPos, z)) {
                                tormentWorld.setBlockToAir(x, yPos, z);
                            }
                            if (tormentWorld.isAirBlock(x, yPos + 1, z)) continue;
                            tormentWorld.setBlockToAir(x, yPos + 1, z);
                        }
                    }
                    if (mustTorment == 2) {
                        boolean found = false;
                        if (player.worldObj.provider.dimensionId == Config.instance().dimensionTormentID) {
                            for (Object obj : player.worldObj.loadedEntityList) {
                                if (!(obj instanceof EntityLordOfTorment)) continue;
                                EntityLordOfTorment lot = (EntityLordOfTorment)obj;
                                if (!(lot.posY >= (double)(yPos - 2)) || !(lot.posY <= (double)(yPos + 6 - 2))) continue;
                                found = true;
                                break;
                            }
                        }
                        if (!found && tormentWorld != null) {
                            EntityLordOfTorment lot = new EntityLordOfTorment((World)tormentWorld);
                            lot.setPositionAndRotation(9.0, yPos - 1, 36.0, 0.0f, 0.0f);
                            lot.func_110163_bv();
                            lot.setHealth(lot.getMaxHealth() * 0.5f);
                            tormentWorld.spawnEntityInWorld((Entity)lot);
                        }
                    }
                } else if (mustTorment == 3) {
                    WorldProviderTorment.setPlayerMustTorment(nbtPlayer, 0, -2);
                    if (player.isRiding()) {
                        player.mountEntity(null);
                    }
                    WorldServer overworld = MinecraftServer.getServer().worldServers[0];
                    ChunkCoordinates coords = player.getBedLocation(0);
                    int dimension = 0;
                    if (coords == null) {
                        coords = overworld.getSpawnPoint();
                    }
                    if (coords != null) {
                        int mod = 0;
                        int origY = coords.posY;
                        while (!WorldProviderTorment.isSafeBlock((World)overworld, coords.posX, coords.posY, coords.posZ) && coords.posY > 1 && coords.posY < 255) {
                            coords.posY = origY + mod;
                            if (origY - mod > 1) {
                                mod = -mod;
                            }
                            if (mod < 0) continue;
                            ++mod;
                        }
                        ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)player, 1.0, 2.0, 16);
                        ItemGeneral cfr_ignored_1 = Witchery.Items.GENERIC;
                        ItemGeneral.teleportToLocation(player.worldObj, coords.posX, coords.posY + 1, coords.posZ, dimension, (Entity)player, true);
                        ParticleEffect.PORTAL.send(SoundEffect.MOB_ENDERMEN_PORTAL, (Entity)player, 1.0, 2.0, 16);
                    }
                }
            }
        }
    }

    private static boolean isSafeBlock(World world, int posX, int posY, int posZ) {
        boolean base = BlockUtil.isSolid(world, posX, posY, posZ);
        boolean air1 = !BlockUtil.isSolid(world, posX, posY + 1, posZ);
        boolean air2 = !BlockUtil.isSolid(world, posX, posY + 2, posZ);
        boolean isSafe = base && air1 && air2;
        return isSafe;
    }
}

