/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.common;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.Shapeshift;
import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.network.PacketPlayerStyle;
import com.emoniph.witchery.util.Config;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ServerTickEvents {
    public static final ArrayList<ServerTickTask> TASKS = new ArrayList();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START && TASKS.size() > 0) {
            ArrayList<ServerTickTask> completedTasks = new ArrayList<ServerTickTask>();
            for (ServerTickTask task : TASKS) {
                if (!task.process()) continue;
                completedTasks.add(task);
            }
            for (ServerTickTask task : completedTasks) {
                TASKS.remove(task);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && !event.player.worldObj.isRemote) {
            ExtendedPlayer playerExt;
            if (event.phase == TickEvent.Phase.START) {
                Collection activeEffects = event.player.getActivePotionEffects();
                ExtendedPlayer playerExt2 = ExtendedPlayer.get(event.player);
                if (playerExt2 != null) {
                    playerExt2.updateWorship();
                    if (activeEffects.size() > 0) {
                        playerExt2.cacheIncurablePotionEffect(activeEffects);
                    }
                    playerExt2.checkSleep(true);
                }
            } else if (event.phase == TickEvent.Phase.END && (playerExt = ExtendedPlayer.get(event.player)) != null) {
                playerExt.restoreIncurablePotionEffects();
                playerExt.checkSleep(false);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        World world = event.player.worldObj;
        Shapeshift.INSTANCE.initCurrentShift(player);
        Infusion.syncPlayer(world, player);
        ExtendedPlayer.get(player).scheduleSync();
        Witchery.packetPipeline.sendToDimension(new PacketPlayerStyle(player), world.provider.dimensionId);
        if (player.dimension != Config.instance().dimensionDreamID && WorldProviderDreamWorld.getPlayerIsSpiritWalking(player) && !WorldProviderDreamWorld.getPlayerIsGhost(player)) {
            WorldProviderDreamWorld.setPlayerMustAwaken(player, true);
        } else if (player.dimension == Config.instance().dimensionDreamID && !WorldProviderDreamWorld.getPlayerIsSpiritWalking(player)) {
            WorldProviderDreamWorld.changeDimension(player, 0);
            WorldProviderDreamWorld.findTopAndSetPosition(player.worldObj, player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.worldObj.isRemote) {
            NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)event.player);
            if (nbtPlayer.hasKey("WITCPoSpawn")) {
                NBTTagList nbtRestoredEffectList = nbtPlayer.getTagList("WITCPoSpawn", 10);
                if (nbtRestoredEffectList.tagCount() > 0) {
                    for (int i = 0; i < nbtRestoredEffectList.tagCount(); ++i) {
                        PotionEffect restoredEffect = PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)nbtRestoredEffectList.getCompoundTagAt(i));
                        if (event.player.isPotionActive(restoredEffect.getPotionID())) continue;
                        event.player.addPotionEffect(restoredEffect);
                    }
                }
                nbtPlayer.removeTag("WITCPoSpawn");
            }
            EntityPlayer player = event.player;
            World world = event.player.worldObj;
            Shapeshift.INSTANCE.initCurrentShift(player);
            Infusion.syncPlayer(world, player);
            ExtendedPlayer.get(player).scheduleSync();
            Witchery.packetPipeline.sendToDimension(new PacketPlayerStyle(player), world.provider.dimensionId);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player;
        if (!event.player.worldObj.isRemote && (player = event.player) != null && player.worldObj != null && !player.worldObj.isRemote) {
            long nextUpdate = MinecraftServer.getSystemTimeMillis() + 1500L;
            ExtendedPlayer.get(player).scheduleSync();
            for (Object obj : player.worldObj.playerEntities) {
                EntityPlayer otherPlayer = (EntityPlayer)obj;
                NBTTagCompound nbtOtherPlayer = Infusion.getNBT((Entity)otherPlayer);
                if (otherPlayer == player) continue;
                nbtOtherPlayer.setLong("WITCResyncLook", nextUpdate);
            }
            NBTTagCompound nbtPlayer = Infusion.getNBT((Entity)player);
            Witchery.packetPipeline.sendToDimension(new PacketPlayerStyle(player), player.worldObj.provider.dimensionId);
            if (player.dimension != Config.instance().dimensionDreamID && WorldProviderDreamWorld.getPlayerIsSpiritWalking(player) && !WorldProviderDreamWorld.getPlayerIsGhost(player)) {
                WorldProviderDreamWorld.setPlayerMustAwaken(player, true);
            }
        }
    }

    public static abstract class ServerTickTask {
        protected final World world;

        public ServerTickTask(World world) {
            this.world = world;
        }

        public abstract boolean process();
    }
}

