/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.common;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockVoidBramble;
import com.emoniph.witchery.brewing.potions.PotionEnslaved;
import com.emoniph.witchery.brewing.potions.PotionParalysis;
import com.emoniph.witchery.brewing.potions.PotionResizing;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.ExtendedVillager;
import com.emoniph.witchery.common.Shapeshift;
import com.emoniph.witchery.dimension.WorldProviderDreamWorld;
import com.emoniph.witchery.entity.EntityDemon;
import com.emoniph.witchery.entity.EntityFollower;
import com.emoniph.witchery.entity.EntityGoblin;
import com.emoniph.witchery.entity.EntityHornedHuntsman;
import com.emoniph.witchery.entity.EntityItemWaystone;
import com.emoniph.witchery.entity.EntityMindrake;
import com.emoniph.witchery.entity.EntityOwl;
import com.emoniph.witchery.entity.EntitySummonedUndead;
import com.emoniph.witchery.entity.EntityToad;
import com.emoniph.witchery.entity.EntityVillageGuard;
import com.emoniph.witchery.entity.EntityVillagerWere;
import com.emoniph.witchery.entity.EntityWitchHunter;
import com.emoniph.witchery.entity.EntityWolfman;
import com.emoniph.witchery.entity.ai.EntityAIDigBlocks;
import com.emoniph.witchery.entity.ai.EntityAISleep;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.infusion.InfusedBrewEffect;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.item.ItemDeathsClothes;
import com.emoniph.witchery.item.ItemHunterClothes;
import com.emoniph.witchery.item.ItemMoonCharm;
import com.emoniph.witchery.item.ItemPoppet;
import com.emoniph.witchery.item.ItemVampireClothes;
import com.emoniph.witchery.network.PacketExtendedEntityRequestSyncToClient;
import com.emoniph.witchery.network.PacketHowl;
import com.emoniph.witchery.network.PacketParticles;
import com.emoniph.witchery.network.PacketPlayerStyle;
import com.emoniph.witchery.network.PacketSelectPlayerAbility;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.BoltDamageSource;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TameableUtil;
import com.emoniph.witchery.util.TargetPointUtil;
import com.emoniph.witchery.util.TimeUtil;
import com.emoniph.witchery.util.TransformCreature;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;

public class GenericEvents {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        boolean chatMasqueradeAllowed = Config.instance().allowChatMasquerading;
        ExtendedPlayer playerEx = ExtendedPlayer.get((EntityPlayer)event.player);
        if (playerEx != null && chatMasqueradeAllowed && playerEx.getCreatureType() == TransformCreature.PLAYER && playerEx.getOtherPlayerSkin() != null && !playerEx.getOtherPlayerSkin().isEmpty()) {
            ChatComponentTranslation comp;
            String disguise = playerEx.getOtherPlayerSkin();
            event.component = comp = new ChatComponentTranslation("chat.type.text", new Object[]{this.getPlayerChatName(event.player, disguise), ForgeHooks.newChatWithLinks((String)event.message)});
            if (!event.player.worldObj.isRemote) {
                for (Object otherPlayerObj : event.player.worldObj.playerEntities) {
                    EntityPlayer otherPlayer = (EntityPlayer)otherPlayerObj;
                    if (!otherPlayer.capabilities.isCreativeMode || !MinecraftServer.getServer().getConfigurationManager().func_152596_g(otherPlayer.getGameProfile())) continue;
                    ChatUtil.sendTranslated(EnumChatFormatting.GOLD, (ICommandSender)otherPlayer, "witchery.rite.mirrormirror.opchatreveal", disguise, event.player.getCommandSenderName());
                }
            }
        }
    }

    private IChatComponent getPlayerChatName(EntityPlayerMP player, String otherName) {
        ChatComponentText chatcomponenttext = new ChatComponentText(ScorePlayerTeam.formatPlayerName((Team)player.getTeam(), (String)otherName));
        chatcomponenttext.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + player.getCommandSenderName() + " "));
        return chatcomponenttext;
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)event.entity) == null) {
            ExtendedPlayer.register((EntityPlayer)event.entity);
        } else if (event.entity instanceof EntityVillager && ExtendedVillager.get((EntityVillager)event.entity) == null) {
            ExtendedVillager.register((EntityVillager)event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityZombie creature;
        if (event.entity instanceof EntityLivingBase) {
            NBTTagCompound nbtData = event.entity.getEntityData();
            nbtData.setFloat("WITCInitialWidth", event.entity.width);
            nbtData.setFloat("WITCInitialHeight", event.entity.height);
        }
        if (!event.entity.worldObj.isRemote && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ExtendedPlayer.loadProxyData(player);
            Shapeshift.INSTANCE.initCurrentShift(player);
            Infusion.syncPlayer(event.world, player);
            for (Object obj : event.world.playerEntities) {
                EntityPlayer otherPlayer = (EntityPlayer)obj;
                if (otherPlayer == player) continue;
                Witchery.packetPipeline.sendTo((IMessage)new PacketPlayerStyle(otherPlayer), player);
            }
            Witchery.packetPipeline.sendToDimension(new PacketPlayerStyle(player), event.world.provider.dimensionId);
            if (player.dimension != Config.instance().dimensionDreamID && WorldProviderDreamWorld.getPlayerIsSpiritWalking(player) && !WorldProviderDreamWorld.getPlayerIsGhost(player)) {
                WorldProviderDreamWorld.setPlayerMustAwaken(player, true);
            } else if (player.dimension == Config.instance().dimensionDreamID && !WorldProviderDreamWorld.getPlayerIsSpiritWalking(player)) {
                WorldProviderDreamWorld.changeDimension(player, 0);
                WorldProviderDreamWorld.findTopAndSetPosition(player.worldObj, player);
            }
        } else if (event.world.provider.dimensionId == Config.instance().dimensionDreamID && GenericEvents.isDisallowedEntity(event.entity)) {
            event.setCanceled(true);
        }
        if (event.entity instanceof EntityVillager && !(event.entity instanceof EntityVillagerWere) && !(event.entity instanceof EntityVillageGuard)) {
            EntityVillager villager = (EntityVillager)event.entity;
            villager.tasks.addTask(1, (EntityAIBase)new EntityAISleep(villager));
        } else if (event.entity instanceof EntityZombie) {
            creature = (EntityZombie)event.entity;
            creature.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)creature, EntityFollower.class, 0, false, false, new IEntitySelector(){

                public boolean isEntityApplicable(Entity entity) {
                    return entity instanceof EntityFollower && ((EntityFollower)entity).getFollowerType() == 0;
                }
            }));
        } else if (event.entity instanceof EntitySkeleton) {
            creature = (EntitySkeleton)event.entity;
            creature.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)creature, EntityFollower.class, 0, true, false, new IEntitySelector(){

                public boolean isEntityApplicable(Entity entity) {
                    return entity instanceof EntityFollower && ((EntityFollower)entity).getFollowerType() == 0;
                }
            }));
        }
        if (event.entity.worldObj.isRemote && event.entity instanceof EntityPlayer) {
            Witchery.packetPipeline.sendToServer(new PacketExtendedEntityRequestSyncToClient((EntityLivingBase)event.entity));
        }
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.Clone event) {
        NBTTagCompound oldPlayerNBT = new NBTTagCompound();
        ExtendedPlayer oldPlayerEx = ExtendedPlayer.get(event.original);
        oldPlayerEx.saveNBTData(oldPlayerNBT);
        ExtendedPlayer newPlayerEx = ExtendedPlayer.get(event.entityPlayer);
        newPlayerEx.loadNBTData(oldPlayerNBT);
        newPlayerEx.restorePlayerInventoryFrom(oldPlayerEx);
    }

    private static boolean isDisallowedEntity(Entity entity) {
        if (entity instanceof EntityLiving) {
            Class<?> cls = entity.getClass();
            String packageName = cls.getCanonicalName();
            if (packageName.startsWith("net.minecraft.entity") || packageName.startsWith("com.emoniph.witchery")) {
                return entity instanceof EntityEnderman;
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        int z;
        int y;
        int x;
        EntityPlayer player;
        ExtendedPlayer playerEx;
        World world = event.entityPlayer.worldObj;
        if (!world.isRemote && (playerEx = ExtendedPlayer.get(player = event.entityPlayer)).isVampire() && player.isPlayerFullyAsleep() && world.getBlock(x = MathHelper.floor_double((double)player.posX), y = MathHelper.floor_double((double)player.posY), z = MathHelper.floor_double((double)player.posZ)) == Witchery.Blocks.COFFIN) {
            EntityPlayer entityplayer;
            Iterator iterator = world.playerEntities.iterator();
            do {
                if (iterator.hasNext()) continue;
                long currentTime = world.getWorldTime() - 11000L;
                world.setWorldTime(currentTime);
                break;
            } while ((entityplayer = (EntityPlayer)iterator.next()).isPlayerFullyAsleep());
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        World world = event.entityPlayer.worldObj;
        EntityPlayer player = event.entityPlayer;
        if (CreatureUtil.isWerewolf((Entity)event.entityPlayer)) {
            if (!world.isRemote) {
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)event.entityPlayer, "witchery.nosleep.wolf", new Object[0]);
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
            }
        } else if (event.entityPlayer.isPotionActive(Witchery.Potions.RESIZING)) {
            if (!world.isRemote) {
                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)event.entityPlayer, "witchery.nosleep.resized", new Object[0]);
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
            }
        } else if (ExtendedPlayer.get(event.entityPlayer).isVampire() && world.getBlock(event.x, event.y, event.z) == Witchery.Blocks.COFFIN) {
            if (!event.entityPlayer.worldObj.isDaytime()) {
                if (!world.isRemote) {
                    ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)event.entityPlayer, "witchery.nosleep.dayonly", new Object[0]);
                    event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                }
            } else {
                if (!world.isRemote) {
                    if (player.isPlayerSleeping() || !player.isEntityAlive()) {
                        return;
                    }
                    if (!world.provider.isSurfaceWorld()) {
                        return;
                    }
                    if (!world.isDaytime()) {
                        event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                        return;
                    }
                    if (Math.abs(player.posX - (double)event.x) > 3.0 || Math.abs(player.posY - (double)event.y) > 2.0 || Math.abs(player.posZ - (double)event.z) > 3.0) {
                        event.result = EntityPlayer.EnumStatus.TOO_FAR_AWAY;
                        return;
                    }
                    double d0 = 8.0;
                    double d1 = 5.0;
                    List list = world.getEntitiesWithinAABB(EntityMob.class, AxisAlignedBB.getBoundingBox((double)((double)event.x - d0), (double)((double)event.y - d1), (double)((double)event.z - d0), (double)((double)event.x + d0), (double)((double)event.y + d1), (double)((double)event.z + d0)));
                    if (!list.isEmpty()) {
                        event.result = EntityPlayer.EnumStatus.NOT_SAFE;
                        return;
                    }
                }
                if (player.isRiding()) {
                    player.mountEntity((Entity)null);
                }
                PotionResizing.setEntitySize((Entity)player, 0.2f, 0.2f);
                player.yOffset = 0.2f;
                if (world.blockExists(event.x, event.y, event.z)) {
                    int l = world.getBlock(event.x, event.y, event.z).getBedDirection((IBlockAccess)world, event.x, event.y, event.z);
                    float f1 = 0.5f;
                    float f = 0.5f;
                    switch (l) {
                        case 0: {
                            f = 0.9f;
                            break;
                        }
                        case 1: {
                            f1 = 0.1f;
                            break;
                        }
                        case 2: {
                            f = 0.1f;
                            break;
                        }
                        case 3: {
                            f1 = 0.9f;
                        }
                    }
                    player.field_71079_bU = 0.0f;
                    player.field_71089_bV = 0.0f;
                    switch (l) {
                        case 0: {
                            player.field_71089_bV = -1.8f;
                            break;
                        }
                        case 1: {
                            player.field_71079_bU = 1.8f;
                            break;
                        }
                        case 2: {
                            player.field_71089_bV = 1.8f;
                            break;
                        }
                        case 3: {
                            player.field_71079_bU = -1.8f;
                        }
                    }
                    player.setPosition((double)((float)event.x + f1), (double)((float)event.y + 0.9375f), (double)((float)event.z + f));
                } else {
                    player.setPosition((double)((float)event.x + 0.5f), (double)((float)event.y + 0.9375f), (double)((float)event.z + 0.5f));
                }
                player.sleeping = true;
                player.sleepTimer = 0;
                player.playerLocation = new ChunkCoordinates(event.x, event.y, event.z);
                player.motionY = 0.0;
                player.motionZ = 0.0;
                player.motionX = 0.0;
                if (!world.isRemote) {
                    world.updateAllPlayersSleepingFlag();
                }
                event.result = EntityPlayer.EnumStatus.OK;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && event.entityLiving != null && !event.entityLiving.worldObj.isRemote) {
            EntityHorse horse;
            NBTTagCompound nbtHorse;
            if (event.entityLiving instanceof EntityLiving && EntityUtil.isNoDrops((EntityLivingBase)((EntityLiving)event.entityLiving))) {
                event.setCanceled(true);
                return;
            }
            if (event.entityLiving instanceof EntityHorse && (nbtHorse = (horse = (EntityHorse)event.entityLiving).getEntityData()) != null && nbtHorse.getBoolean("WITCIsBinky")) {
                event.drops.clear();
                event.drops.add(new EntityItem(horse.worldObj, horse.posX, horse.posY, horse.posZ, Witchery.Items.GENERIC.itemBinkyHead.createStack()));
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (!event.isCanceled() && !event.player.worldObj.isRemote && event.entityItem != null && event.entityItem.getEntityItem() != null) {
            if (event.entityItem.getEntityItem().getItem() == Witchery.Items.SEEDS_MINDRAKE) {
                event.entityItem.lifespan = TimeUtil.secsToTicks(3);
                NBTTagCompound nbtItem = event.entityItem.getEntityData();
                nbtItem.setString("WITCThrower", event.player.getCommandSenderName());
            } else if (Witchery.Items.GENERIC.itemWaystone.isMatch(event.entityItem.getEntityItem()) || Witchery.Items.GENERIC.itemWaystoneBound.isMatch(event.entityItem.getEntityItem()) || Witchery.Items.GENERIC.itemAttunedStone.isMatch(event.entityItem.getEntityItem()) || Witchery.Items.GENERIC.itemSubduedSpirit.isMatch(event.entityItem.getEntityItem()) || Witchery.Items.GENERIC.itemWaystonePlayerBound.isMatch(event.entityItem.getEntityItem())) {
                EntityUtil.spawnEntityInWorld(event.entity.worldObj, (Entity)new EntityItemWaystone(event.entityItem));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onItemExpireEvent(ItemExpireEvent event) {
        if (!event.isCanceled() && !event.entityItem.worldObj.isRemote && event.entityItem != null && event.entityItem.getEntityItem() != null && event.entityItem.getEntityItem().getItem() == Witchery.Items.SEEDS_MINDRAKE) {
            for (int i = 0; i < event.entityItem.getEntityItem().stackSize; ++i) {
                String thrower;
                EntityMindrake mindrake = new EntityMindrake(event.entityItem.worldObj);
                mindrake.setLocationAndAngles(event.entityItem.posX, event.entityItem.posY, event.entityItem.posZ, 0.0f, 0.0f);
                NBTTagCompound nbtItem = event.entityItem.getEntityData();
                if (nbtItem.hasKey("WITCThrower") && (thrower = nbtItem.getString("WITCThrower")) != null && !thrower.isEmpty()) {
                    mindrake.func_110163_bv();
                    mindrake.setTamed(true);
                    TameableUtil.setOwnerByUsername(mindrake, thrower);
                }
                ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_POP, (Entity)mindrake, 1.0, 1.0, 16);
                event.entityItem.worldObj.spawnEntityInWorld((Entity)mindrake);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerDrops(PlayerDropsEvent event) {
        if (!event.entityPlayer.worldObj.isRemote && !event.isCanceled() && ExtendedPlayer.get(event.entityPlayer).isVampire()) {
            int ticks = TimeUtil.minsToTicks(MathHelper.clamp_int((int)Config.instance().vampireDeathItemKeepAliveMins, (int)5, (int)30));
            for (EntityItem item : event.drops) {
                item.lifespan = ticks;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteract(EntityInteractEvent event) {
        ItemStack heldStack;
        PotionEffect effect = event.entityPlayer.getActivePotionEffect(Witchery.Potions.PARALYSED);
        if (effect != null && effect.getAmplifier() >= 4) {
            event.setCanceled(true);
            return;
        }
        ExtendedPlayer playerEx = ExtendedPlayer.get(event.entityPlayer);
        ExtendedPlayer.VampirePower power = playerEx.getSelectedVampirePower();
        if (power != ExtendedPlayer.VampirePower.NONE) {
            if (power == ExtendedPlayer.VampirePower.DRINK && event.target instanceof EntityLivingBase) {
                if (!event.entityPlayer.worldObj.isRemote) {
                    float RANGE;
                    float f = RANGE = ((EntityLivingBase)event.target).isPotionActive(Witchery.Potions.PARALYSED) ? 2.1f : 1.3f;
                    if (event.target.getDistanceSq(event.entityPlayer.posX, event.target.posY, event.entityPlayer.posZ) <= (double)(RANGE * RANGE)) {
                        EntityVillageGuard target;
                        int drinkAmount;
                        int n = drinkAmount = ItemVampireClothes.isDrinkBoostActive((EntityLivingBase)event.entityPlayer) ? 15 : 10;
                        if (CreatureUtil.isWerewolf(event.target, true)) {
                            event.entityPlayer.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)event.entityPlayer), 4.0f);
                            ParticleEffect.FLAME.send(SoundEffect.WITCHERY_RANDOM_DRINK, event.entityPlayer.worldObj, event.target.posX, event.target.posY + (double)event.target.height * 0.8, event.target.posZ, 0.5, 0.2, 16);
                        } else if (event.target instanceof EntityVillageGuard) {
                            target = (EntityVillageGuard)event.target;
                            playerEx.increaseBloodPower(target.takeBlood(playerEx.getCreatureType() == TransformCreature.NONE ? drinkAmount : 2, (EntityLivingBase)event.entityPlayer));
                            ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, event.entityPlayer.worldObj, target.posX, target.posY + (double)target.height * 0.8, target.posZ, 0.5, 0.2, 16);
                            this.checkForBloodDrinkingWitnesses(event.entityPlayer, (EntityLivingBase)target);
                        } else if (event.target instanceof EntityVillager) {
                            target = (EntityVillager)event.target;
                            ExtendedVillager villagerEx = ExtendedVillager.get((EntityVillager)target);
                            playerEx.increaseBloodPower(villagerEx.takeBlood(playerEx.getCreatureType() == TransformCreature.NONE ? drinkAmount : 2, (EntityLivingBase)event.entityPlayer));
                            ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, event.entityPlayer.worldObj, ((EntityVillager)target).posX, ((EntityVillager)target).posY + (double)((EntityVillager)target).height * 0.8, ((EntityVillager)target).posZ, 0.5, 0.2, 16);
                            this.checkForBloodDrinkingWitnesses(event.entityPlayer, (EntityLivingBase)target);
                            if (playerEx.getVampireLevel() == 2) {
                                if (Config.instance().allowVampireQuests && villagerEx.getBlood() >= 250 && villagerEx.getBlood() <= 280) {
                                    if (playerEx.getVampireQuestCounter() >= 5) {
                                        playerEx.increaseVampireLevel();
                                    } else {
                                        SoundEffect.NOTE_PLING.playOnlyTo(event.entityPlayer, 1.0f, 1.0f);
                                        playerEx.increaseVampireQuestCounter();
                                    }
                                } else if (villagerEx.getBlood() < 240) {
                                    playerEx.resetVampireQuestCounter();
                                }
                            } else if (playerEx.getVampireLevel() == 8 && playerEx.canIncreaseVampireLevel() && this.villagerIsInCage((EntityVillager)target)) {
                                if (villagerEx.getBlood() >= 250 && villagerEx.getBlood() <= 280) {
                                    if (playerEx.getVampireQuestCounter() >= 5) {
                                        playerEx.increaseVampireLevel();
                                    } else {
                                        SoundEffect.NOTE_PLING.playOnlyTo(event.entityPlayer, 1.0f, 1.0f);
                                        playerEx.increaseVampireQuestCounter();
                                    }
                                } else if (villagerEx.getBlood() < 240) {
                                    playerEx.resetVampireQuestCounter();
                                }
                            }
                        } else if (event.target instanceof EntityPlayer) {
                            target = (EntityPlayer)event.target;
                            playerEx.increaseBloodPower(ExtendedPlayer.get((EntityPlayer)target).takeHumanBlood(playerEx.getCreatureType() == TransformCreature.NONE ? drinkAmount : 2, (EntityLivingBase)event.entityPlayer));
                            ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, event.entityPlayer.worldObj, ((EntityPlayer)target).posX, ((EntityPlayer)target).posY + (double)((EntityPlayer)target).height * 0.8, ((EntityPlayer)target).posZ, 0.5, 0.2, 16);
                        } else if (event.target instanceof IAnimals) {
                            target = (EntityLivingBase)event.target;
                            target.attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.magic.getDamageType(), (Entity)event.entityPlayer), 1.0f);
                            playerEx.increaseBloodPower(2, (int)Math.ceil((float)playerEx.getMaxBloodPower() * 0.25f));
                            ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, event.entityPlayer.worldObj, ((EntityLivingBase)target).posX, ((EntityLivingBase)target).posY + (double)((EntityLivingBase)target).height * 0.8, ((EntityLivingBase)target).posZ, 0.5, 0.2, 16);
                        }
                    }
                    event.setCanceled(true);
                }
            } else if (power == ExtendedPlayer.VampirePower.MESMERIZE) {
                if (!event.entityPlayer.worldObj.isRemote) {
                    if (event.entityPlayer.isSneaking() && playerEx.getVampireLevel() >= 2) {
                        playerEx.toggleVampireVision();
                    } else if (playerEx.getCreatureType() == TransformCreature.NONE && playerEx.getVampireLevel() >= 2) {
                        if (event.target instanceof EntityVillager && !(event.target instanceof EntityVillagerWere) || event.target instanceof EntityPlayer || event.target instanceof EntityVillageGuard) {
                            EntityLivingBase victim = (EntityLivingBase)event.target;
                            if (!victim.isPotionActive(Witchery.Potions.PARALYSED)) {
                                if (playerEx.decreaseBloodPower(ExtendedPlayer.VampirePower.MESMERIZE.INITIAL_COST, true)) {
                                    victim.addPotionEffect(new PotionEffect(Witchery.Potions.PARALYSED.id, TimeUtil.secsToTicks(5 + playerEx.getVampireLevel() / 2 + Math.max(0, (playerEx.getVampireLevel() - 4) / 2) + (ItemVampireClothes.isMezmeriseBoostActive((EntityLivingBase)event.entityPlayer) ? 3 : 0)), playerEx.getVampireLevel() >= 8 ? 5 : 4));
                                    SoundEffect.WITCHERY_RANDOM_HYPNOSIS.playAtPlayer(event.entity.worldObj, event.entityPlayer, 0.5f, 1.0f);
                                } else {
                                    SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer, 1.0f, 0.5f);
                                }
                            } else {
                                SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer, 1.0f, 0.5f);
                            }
                        } else {
                            SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer, 1.0f, 0.5f);
                        }
                    } else {
                        SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer, 1.0f, 0.5f);
                    }
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.target != null && !event.target.worldObj.isRemote && event.target instanceof EntityLiving && PotionEnslaved.isMobEnslavedBy((EntityLiving)event.target, event.entityPlayer)) {
            EntityPlayer player = event.entityPlayer;
            EntityLiving creature = (EntityLiving)event.target;
            ItemStack heldObject = player.getHeldItem();
            if (Witchery.Items.GENERIC.itemGraveyardDust.isMatch(heldObject) && creature instanceof EntitySummonedUndead) {
                IAttributeInstance attribute;
                float maxHealth = creature.getMaxHealth() + 2.0f;
                if (maxHealth <= 50.0f && (attribute = creature.getEntityAttribute(SharedMonsterAttributes.maxHealth)) != null) {
                    attribute.setBaseValue((double)maxHealth);
                    creature.setHealth(maxHealth);
                    creature.func_110163_bv();
                    Witchery.packetPipeline.sendToAllAround(new PacketParticles(ParticleEffect.INSTANT_SPELL, SoundEffect.MOB_SILVERFISH_KILL, (Entity)creature, 0.5, 1.0), TargetPointUtil.from((Entity)creature, 16.0));
                    if (!player.capabilities.isCreativeMode) {
                        --heldObject.stackSize;
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                }
            } else if (heldObject != null && (creature instanceof EntityZombie || creature instanceof EntityPigZombie || creature instanceof EntitySkeleton)) {
                if (heldObject.getItem() instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)heldObject.getItem();
                    if (creature.getEquipmentInSlot(4 - armor.armorType) == null) {
                        creature.setCurrentItemOrArmor(4 - armor.armorType, heldObject.splitStack(1));
                        creature.func_110163_bv();
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                } else if (heldObject.getItem() instanceof ItemSword && creature.getEquipmentInSlot(0) == null) {
                    creature.setCurrentItemOrArmor(0, heldObject.splitStack(1));
                    creature.func_110163_bv();
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                    }
                }
            }
        }
        if (event.target != null && !event.target.worldObj.isRemote && event.target instanceof EntityVillager) {
            Village village;
            EntityVillager villager = (EntityVillager)event.target;
            ItemStack heldObject = event.entityPlayer.getHeldItem();
            if (!villager.isChild() && heldObject != null && heldObject.getItem() == Items.leather_chestplate && event.entityPlayer.isSneaking() && (village = villager.villageObj) != null) {
                int rep = village.getReputationForPlayer(event.entityPlayer.getCommandSenderName());
                if (rep >= 10) {
                    if (village.getNumVillagers() > 8) {
                        List list = event.entity.worldObj.getEntitiesWithinAABB(EntityVillageGuard.class, AxisAlignedBB.getBoundingBox((double)(village.getCenter().posX - village.getVillageRadius()), (double)(village.getCenter().posY - 4), (double)(village.getCenter().posZ - village.getVillageRadius()), (double)(village.getCenter().posX + village.getVillageRadius()), (double)(village.getCenter().posY + 4), (double)(village.getCenter().posZ + village.getVillageRadius())));
                        int numGuards = list.size();
                        if (numGuards < MathHelper.floor_double((double)((double)village.getNumVillagers() * 0.25))) {
                            int villagerNumTrades;
                            int n = villagerNumTrades = villager.buyingList == null ? 1 : villager.buyingList.size();
                            if (!CreatureUtil.isWerewolf(event.target, true) && event.target.worldObj.rand.nextInt(villagerNumTrades * 2 + 1) == 0) {
                                villager.playSound("mob.villager.yew", 1.0f, (villager.worldObj.rand.nextFloat() - villager.worldObj.rand.nextFloat()) * 0.2f + 1.0f);
                                ChatUtil.sendTranslated(EnumChatFormatting.GREEN, (ICommandSender)event.entityPlayer, "witchery.village.villageracceptsguardduty", new Object[0]);
                                EntityVillageGuard.createFrom(villager);
                            } else {
                                ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)event.entityPlayer, "witchery.village.villagerrefusesguardduty", new Object[0]);
                                villager.playSound("mob.villager.no", 1.0f, (villager.worldObj.rand.nextFloat() - villager.worldObj.rand.nextFloat()) * 0.2f + 1.0f);
                            }
                        } else {
                            ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)event.entityPlayer, "witchery.village.toomanyguards", new Object[0]);
                            SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer);
                        }
                    } else {
                        ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)event.entityPlayer, "witchery.village.villagetoosmall", new Object[0]);
                        SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer);
                    }
                } else {
                    ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)event.entityPlayer, "witchery.village.reptoolow", new Object[0]);
                    SoundEffect.NOTE_SNARE.playOnlyTo(event.entityPlayer);
                }
            }
        }
        if (!event.entity.worldObj.isRemote && event.target != null && event.target instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)event.target;
            if (playerEx.getWerewolfLevel() == 7 && playerEx.getWolfmanQuestState() == ExtendedPlayer.QuestState.STARTED && playerEx.getCreatureType() == TransformCreature.WOLF && !wolf.isTamed() && !wolf.isAngry()) {
                if (wolf.worldObj.rand.nextInt(3) == 0) {
                    wolf.setTamed(true);
                    wolf.setPathToEntity((PathEntity)null);
                    wolf.setAttackTarget((EntityLivingBase)null);
                    wolf.func_70907_r().setSitting(true);
                    wolf.setHealth(20.0f);
                    wolf.func_152115_b(event.entityPlayer.getUniqueID().toString());
                    this.playTameEffect((EntityTameable)wolf, true);
                    wolf.worldObj.setEntityState((Entity)wolf, (byte)7);
                    playerEx.increaseWolfmanQuestCounter();
                } else {
                    this.playTameEffect((EntityTameable)wolf, false);
                    wolf.worldObj.setEntityState((Entity)wolf, (byte)6);
                    if (wolf.worldObj.rand.nextInt(10) == 0) {
                        wolf.setAngry(true);
                        wolf.setAttackTarget((EntityLivingBase)event.entityPlayer);
                    }
                }
            }
        }
        if ((heldStack = event.entityPlayer.getHeldItem()) != null) {
            EntityPlayer victim;
            if (heldStack.getItem() == Witchery.Items.TAGLOCK_KIT) {
                Witchery.Items.TAGLOCK_KIT.onEntityInteract(event.entityPlayer.worldObj, event.entityPlayer, heldStack, event);
                if (event.isCanceled()) {
                    return;
                }
            }
            if (heldStack.getItem() == Witchery.Items.BLOOD_GOBLET) {
                Witchery.Items.BLOOD_GOBLET.onEntityInteract(event.entityPlayer.worldObj, event.entityPlayer, heldStack, event);
                if (event.isCanceled()) {
                    return;
                }
            }
            if (Witchery.Items.GENERIC.itemWoodenStake.isMatch(heldStack) && Config.instance().allowStakingVampires && event.target instanceof EntityPlayer && ExtendedPlayer.get(victim = (EntityPlayer)event.target).isVampire() && victim.sleeping) {
                ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_DRINK, victim.worldObj, event.target.posX, event.target.posY, event.target.posZ, event.target.width, event.target.height, 16);
                EntityUtil.instantDeath((EntityLivingBase)victim, (EntityLivingBase)event.entityPlayer);
                if (!event.entityPlayer.capabilities.isCreativeMode) {
                    --heldStack.stackSize;
                }
                event.setCanceled(true);
                return;
            }
        }
    }

    private boolean villagerIsInCage(EntityVillager target) {
        int ogZ;
        int ogY;
        int ogX = MathHelper.floor_double((double)target.posX);
        if (this.isCaged(target.worldObj, ogX, ogY = MathHelper.floor_double((double)target.posY), ogZ = MathHelper.floor_double((double)target.posZ))) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX + 1, ogY, ogZ)) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX, ogY, ogZ + 1)) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX - 1, ogY, ogZ)) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX, ogY, ogZ - 1)) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX + 1, ogY, ogZ + 1)) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX + 1, ogY, ogZ - 1)) {
            return true;
        }
        if (this.isCaged(target.worldObj, ogX - 1, ogY, ogZ + 1)) {
            return true;
        }
        return this.isCaged(target.worldObj, ogX - 1, ogY, ogZ - 1);
    }

    private boolean isCaged(World world, int x, int y, int z) {
        int count = 0;
        Block bars = Blocks.iron_bars;
        count += world.getBlock(x + 1, y, z) == bars ? 1 : 0;
        count += world.getBlock(x, y, z + 1) == bars ? 1 : 0;
        count += world.getBlock(x - 1, y, z) == bars ? 1 : 0;
        count += world.getBlock(x, y, z - 1) == bars ? 1 : 0;
        count += world.getBlock(x + 1, y, z + 1) == bars ? 1 : 0;
        count += world.getBlock(x - 1, y, z + 1) == bars ? 1 : 0;
        count += world.getBlock(x + 1, y, z - 1) == bars ? 1 : 0;
        count += world.getBlock(x - 1, y, z - 1) == bars ? 1 : 0;
        count += world.getBlock(x + 1, ++y, z) == bars ? 1 : 0;
        count += world.getBlock(x, y, z + 1) == bars ? 1 : 0;
        count += world.getBlock(x - 1, y, z) == bars ? 1 : 0;
        count += world.getBlock(x, y, z - 1) == bars ? 1 : 0;
        count += world.getBlock(x + 1, y, z + 1) == bars ? 1 : 0;
        count += world.getBlock(x - 1, y, z + 1) == bars ? 1 : 0;
        count += world.getBlock(x + 1, y, z - 1) == bars ? 1 : 0;
        if ((count += world.getBlock(x - 1, y, z - 1) == bars ? 1 : 0) < 15) {
            return false;
        }
        count = 0;
        count += !BlockUtil.isReplaceableBlock(world, x + 1, ++y, z) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x, y, z + 1) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x - 1, y, z) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x, y, z - 1) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x + 1, y, z + 1) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x - 1, y, z + 1) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x + 1, y, z - 1) ? 1 : 0;
        count += !BlockUtil.isReplaceableBlock(world, x - 1, y, z - 1) ? 1 : 0;
        return (count += !BlockUtil.isReplaceableBlock(world, x, y, z) ? 1 : 0) >= 9;
    }

    private void checkForBloodDrinkingWitnesses(EntityPlayer player, EntityLivingBase victim) {
        AxisAlignedBB bounds = victim.boundingBox.expand(16.0, 8.0, 16.0);
        List guards = victim.worldObj.getEntitiesWithinAABB(EntityVillageGuard.class, bounds);
        for (EntityVillageGuard guard : guards) {
            if (guard.isPotionActive(Witchery.Potions.PARALYSED) || !guard.getEntitySenses().canSee((Entity)victim)) continue;
            guard.setAttackTarget((EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        PotionEffect effect = event.entityPlayer.getActivePotionEffect(Witchery.Potions.PARALYSED);
        if (effect != null && effect.getAmplifier() >= 4) {
            event.setCanceled(true);
            return;
        }
        ExtendedPlayer playerEx = ExtendedPlayer.get(event.entityPlayer);
        if (playerEx.getSelectedVampirePower() != ExtendedPlayer.VampirePower.NONE) {
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                switch (playerEx.getSelectedVampirePower()) {
                    case MESMERIZE: 
                    case SPEED: 
                    case BAT: 
                    case ULTIMATE: {
                        Witchery.packetPipeline.sendToServer(new PacketSelectPlayerAbility(playerEx, true));
                        break;
                    }
                }
                event.setCanceled(true);
            }
        } else if (event.entityPlayer.worldObj.isRemote) {
            if ((event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && event.entityPlayer.rotationPitch == -90.0f && event.entityPlayer.isSneaking()) {
                Witchery.packetPipeline.sendToServer(new PacketHowl());
            }
        } else if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && !event.entityPlayer.capabilities.isCreativeMode) {
            Block block;
            if (playerEx.isVampire() && event.world.getBlock(event.x, event.y, event.z) == Witchery.Blocks.GARLIC_GARLAND) {
                event.entityPlayer.setFire(1);
                event.setCanceled(true);
            } else if (playerEx.getCreatureType() == TransformCreature.WOLF && playerEx.getWerewolfLevel() >= 3 && event.entityPlayer.isSneaking()) {
                Block block2 = event.world.getBlock(event.x, event.y, event.z);
                if (block2 == Blocks.grass || block2 == Blocks.sand || block2 == Blocks.dirt || block2 == Blocks.mycelium || block2 == Blocks.gravel) {
                    EntityAIDigBlocks.tryHarvestBlock(event.world, event.x, event.y, event.z, (EntityLivingBase)event.entityPlayer, event.entityPlayer);
                    event.setCanceled(true);
                }
            } else if (!(playerEx.getVampireLevel() < 6 || playerEx.getCreatureType() != TransformCreature.NONE || !event.entityPlayer.isSneaking() || event.entityPlayer.getHeldItem() != null && event.entityPlayer.getHeldItem().getItem().func_150897_b(Blocks.stone) || event.entityPlayer.getFoodStats().getFoodLevel() <= 0 || (block = event.world.getBlock(event.x, event.y, event.z)) != Blocks.stone && block != Blocks.netherrack && block != Blocks.cobblestone)) {
                EntityAIDigBlocks.tryHarvestBlock(event.world, event.x, event.y, event.z, (EntityLivingBase)event.entityPlayer, event.entityPlayer);
                event.entityPlayer.addExhaustion(10.0f);
                event.setCanceled(true);
            }
        }
    }

    private void playTameEffect(EntityTameable entity, boolean tamed) {
        String s = "heart";
        if (!tamed) {
            s = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = entity.worldObj.rand.nextGaussian() * 0.02;
            double d1 = entity.worldObj.rand.nextGaussian() * 0.02;
            double d2 = entity.worldObj.rand.nextGaussian() * 0.02;
            entity.worldObj.spawnParticle(s, entity.posX + (double)(entity.worldObj.rand.nextFloat() * entity.width * 2.0f) - (double)entity.width, entity.posY + 0.5 + (double)(entity.worldObj.rand.nextFloat() * entity.height), entity.posZ + (double)(entity.worldObj.rand.nextFloat() * entity.width * 2.0f) - (double)entity.width, d0, d1, d2);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.worldObj.isRemote && event.entity instanceof EntityPlayer) {
            int hunger;
            int prevHunger;
            EntityPlayer player = (EntityPlayer)event.entity;
            ExtendedPlayer playerEx = ExtendedPlayer.get(player);
            Shapeshift.INSTANCE.updatePlayerState(player, playerEx);
            playerEx.tick();
            if (playerEx.isVampire() && (prevHunger = player.getFoodStats().prevFoodLevel) < (hunger = player.getFoodStats().getFoodLevel())) {
                player.getFoodStats().addStats(-player.getFoodStats().getFoodLevel(), 0.0f);
            }
            if (event.entity.ticksExisted % 40 == 1) {
                if (playerEx.getWerewolfLevel() > 0) {
                    boolean isFullMoon = CreatureUtil.isFullMoon(player.worldObj);
                    switch (playerEx.getCreatureType()) {
                        case WOLF: 
                        case WOLFMAN: {
                            boolean isWolfman;
                            boolean bl = isWolfman = playerEx.getCreatureType() == TransformCreature.WOLFMAN;
                            if (!(isFullMoon || player.inventory.hasItem(Witchery.Items.MOON_CHARM) || ItemMoonCharm.isWolfsbaneActive(player, playerEx))) {
                                Shapeshift.INSTANCE.shiftTo(player, TransformCreature.NONE);
                                ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.5, 1.5, 16);
                                break;
                            }
                            GenericEvents.updateWerewolfEffects(player, isWolfman);
                            break;
                        }
                        case NONE: {
                            if (!isFullMoon || player.inventory.hasItem(Witchery.Items.MOON_CHARM) || ItemMoonCharm.isWolfsbaneActive(player, playerEx)) break;
                            Shapeshift.INSTANCE.shiftTo(player, TransformCreature.WOLF);
                            ParticleEffect.EXPLODE.send(SoundEffect.WITCHERY_MOB_WOLFMAN_HOWL, (Entity)player, 1.5, 1.5, 16);
                            GenericEvents.updateWerewolfEffects(player, false);
                            break;
                        }
                    }
                }
                if (playerEx.isVampire()) {
                    Village closestVillage;
                    if (player.isInWater()) {
                        player.setAir(300);
                    }
                    if (playerEx.getCreatureType() == TransformCreature.BAT && !playerEx.decreaseBloodPower(ExtendedPlayer.VampirePower.BAT.UPKEEP_COST, true)) {
                        Shapeshift.INSTANCE.shiftTo(player, TransformCreature.NONE);
                    }
                    if (playerEx.getVampireLevel() == 3 && !player.worldObj.isDaytime()) {
                        if (playerEx.getVampireQuestCounter() >= 300 || playerEx.getVampireQuestCounter() >= 10 && player.capabilities.isCreativeMode) {
                            if (playerEx.canIncreaseVampireLevel()) {
                                playerEx.increaseVampireLevel();
                            }
                        } else if (Config.instance().allowVampireQuests) {
                            playerEx.increaseVampireQuestCounter();
                        }
                    }
                    if (playerEx.getVampireLevel() == 7 && playerEx.canIncreaseVampireLevel() && (closestVillage = player.worldObj.villageCollectionObj.findNearestVillage(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), 32)) != null && playerEx.storeVampireQuestChunk(closestVillage.getCenter().posX >> 4, closestVillage.getCenter().posZ >> 4)) {
                        if (playerEx.getVampireQuestCounter() >= 3) {
                            playerEx.increaseVampireLevel();
                        } else {
                            playerEx.increaseVampireQuestCounter();
                            SoundEffect.NOTE_PLING.playOnlyTo(player, 1.0f, 1.0f);
                        }
                    }
                    if (playerEx.isVampireVisionActive()) {
                        player.addPotionEffect(new PotionEffect(Potion.nightVision.id, 400, 0, true));
                    }
                    if (player.isPotionActive(Potion.poison)) {
                        player.removePotionEffect(Potion.poison.id);
                    }
                    if (player.isBurning() && player.isPotionActive(Potion.fireResistance)) {
                        player.attackEntityFrom((DamageSource)EntityUtil.DamageSourceVampireFire.SOURCE, 2.0f);
                    }
                    while (player.getFoodStats().getFoodLevel() < 20 && playerEx.decreaseBloodPower(5, true)) {
                        player.getFoodStats().addStats(1, 4.0f);
                    }
                    if (playerEx.getBloodPower() == 0 && player.getFoodStats().getFoodLevel() == 0) {
                        player.addPotionEffect(new PotionEffect(Potion.weakness.id, TimeUtil.secsToTicks(10), 8, true));
                        player.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, TimeUtil.secsToTicks(10), 1, true));
                        player.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, TimeUtil.secsToTicks(10), 1, true));
                    }
                    if (CreatureUtil.isInSunlight((EntityLivingBase)player) && !player.capabilities.isCreativeMode) {
                        if (playerEx.getBloodPower() == 0 && player.ticksExisted > 400) {
                            EntityUtil.instantDeath((EntityLivingBase)player, null);
                        }
                        if (playerEx.getVampireLevel() >= 5) {
                            playerEx.decreaseBloodPower(60, false);
                            player.addPotionEffect(new PotionEffect(Potion.weakness.id, TimeUtil.secsToTicks(10), 3, false));
                            player.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, TimeUtil.secsToTicks(10), 0, true));
                            player.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, TimeUtil.secsToTicks(10), 0, true));
                        } else {
                            playerEx.setBloodPower(0);
                        }
                        if (playerEx.getBloodPower() == 0) {
                            player.setFire(5);
                        }
                    }
                } else {
                    playerEx.giveHumanBlood(2);
                }
            }
        }
    }

    public static void updateWerewolfEffects(EntityPlayer player, boolean isWolfman) {
        int slot;
        player.addPotionEffect(new PotionEffect(Potion.nightVision.id, 400, 0, true));
        if (player.isPotionActive(Potion.poison)) {
            player.removePotionEffect(Potion.poison.id);
        }
        int n = slot = isWolfman ? 0 : 1;
        while (slot <= 4) {
            ItemStack stack = player.getEquipmentInSlot(slot);
            if (stack != null && stack.getItem() != Witchery.Items.MOON_CHARM && (player.openContainer == null || player.openContainer.windowId == 0 || slot != 0)) {
                player.entityDropItem(stack, 1.0f);
                player.setCurrentItemOrArmor(slot, null);
            }
            ++slot;
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (!event.entity.worldObj.isRemote && event.entity instanceof EntityPlayer) {
            event.distance = Shapeshift.INSTANCE.updateFallState((EntityPlayer)event.entity, event.distance);
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (!event.world.isRemote && event.harvester != null && !event.isCanceled()) {
            ExtendedPlayer playerEx = ExtendedPlayer.get(event.harvester);
            Shapeshift.INSTANCE.processDigging(event, event.harvester, playerEx);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        block66: {
            block67: {
                boolean ignoreProtection;
                float healthAfterDamage;
                boolean wolfForm;
                ExtendedPlayer playerEx;
                EntityPlayer player;
                block68: {
                    PotionEffect effect;
                    List list;
                    ItemStack stack;
                    PotionEffect effect2;
                    EntityLivingBase living;
                    int currentLevel;
                    ItemStack hat;
                    if (event.entityLiving.worldObj.isRemote || event.isCanceled()) break block66;
                    this.checkForChargeDamage(event);
                    if (!(event.entityLiving instanceof EntityPlayer)) break block67;
                    player = (EntityPlayer)event.entityLiving;
                    float playerHealth = player.getHealth();
                    playerEx = ExtendedPlayer.get(player);
                    if (event.source == DamageSource.drown && playerEx.isVampire()) {
                        event.setCanceled(true);
                        return;
                    }
                    boolean bl = wolfForm = playerEx.getWerewolfLevel() > 0 && (playerEx.getCreatureType() == TransformCreature.WOLF || playerEx.getCreatureType() == TransformCreature.WOLFMAN);
                    if (wolfForm && event.source != DamageSource.outOfWorld && event.source != DamageSource.inWall && event.source != DamageSource.drown && event.source != DamageSource.fall) {
                        if (!event.source.isFireDamage()) {
                            float damageReduction = Shapeshift.INSTANCE.getResistance(player, playerEx);
                            event.ammount = Math.max(0.0f, event.ammount - damageReduction);
                        }
                        if (!CreatureUtil.isWerewolf(event.source.getSourceOfDamage())) {
                            event.ammount = !CreatureUtil.isSilverDamage(event.source) ? Math.max(Math.min(event.ammount, Shapeshift.INSTANCE.getDamageCap(player, playerEx)), 0.5f) : (event.ammount += 5.0f);
                        }
                        if (event.ammount <= 0.0f) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                    if (ItemDeathsClothes.isFullSetWorn((EntityLivingBase)player) && player.getHeldItem() != null && player.getHeldItem().getItem() == Witchery.Items.DEATH_HAND) {
                        event.ammount = Math.min(event.ammount, 7.0f);
                    }
                    healthAfterDamage = EntityUtil.getHealthAfterDamage(event, playerHealth, (EntityLivingBase)player);
                    if ((player.dimension == Config.instance().dimensionDreamID || WorldProviderDreamWorld.getPlayerIsGhost(player)) && healthAfterDamage <= 0.0f && !player.capabilities.isCreativeMode) {
                        event.setCanceled(true);
                        event.setResult(Event.Result.DENY);
                        WorldProviderDreamWorld.setPlayerMustAwaken(player, true);
                        return;
                    }
                    GenericEvents.dropItemsOnHit(player);
                    ignoreProtection = wolfForm || event.source instanceof BoltDamageSource && ((BoltDamageSource)event.source).isPoweredDraining;
                    boolean hasHunterSet = ItemHunterClothes.isFullSetWorn((EntityLivingBase)player, false);
                    if (hasHunterSet && event.source.isMagicDamage() && player.worldObj.rand.nextDouble() < 0.25) {
                        event.setCanceled(true);
                        return;
                    }
                    if ((event.source instanceof EntityDamageSource || event.source.isExplosion()) && !ignoreProtection && (hat = player.getEquipmentInSlot(4)) != null && hat.getItem() == Witchery.Items.BABAS_HAT && player.dimension != Config.instance().dimensionTormentID) {
                        int TELEPORT_COST = 5;
                        double TELEPORT_CHANCE = 0.25;
                        int TELEPORT_DISTANCE = 6;
                        if (player.worldObj.rand.nextDouble() < 0.25 && Infusion.aquireEnergy(player.worldObj, player, 5, true)) {
                            BlockVoidBramble.teleportRandomly(player.worldObj, MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ), (Entity)player, 6);
                            event.setCanceled(true);
                            return;
                        }
                    }
                    if (!(event.source instanceof EntityDamageSource)) break block68;
                    EntityDamageSource entitySource = (EntityDamageSource)event.source;
                    ItemStack belt = player.getEquipmentInSlot(2);
                    if (belt != null && belt.getItem() == Witchery.Items.BARK_BELT && !CreatureUtil.isWoodenDamage(event.source) && (currentLevel = Math.min(Witchery.Items.BARK_BELT.getChargeLevel(belt), Witchery.Items.BARK_BELT.getMaxChargeLevel((EntityLivingBase)player))) > 0) {
                        World world = player.worldObj;
                        Random rand = world.rand;
                        int cost = currentLevel > 1 && rand.nextDouble() < 0.25 ? 2 : 1;
                        Witchery.Items.BARK_BELT.setChargeLevel(belt, Math.max(currentLevel - cost, 0));
                        event.setCanceled(true);
                        for (int i = 0; i < cost; ++i) {
                            double dx = 1.0 * (double)(rand.nextInt(2) == 0 ? -1 : 1);
                            double dy = 1.0 * (double)(rand.nextInt(2) == 0 ? -1 : 1);
                            EntityItem item = new EntityItem(world, player.posX + dx, player.posY + 1.5, player.posZ + dy, new ItemStack(Items.stick));
                            item.delayBeforeCanPickup = 60;
                            item.lifespan = 60;
                            world.spawnEntityInWorld((Entity)item);
                        }
                        return;
                    }
                    double MOB_SPAWN_CHANCE = 0.25;
                    if (player.getHeldItem() != null && player.getHeldItem().getItem() == Witchery.Items.HUNTSMANS_SPEAR && player.isBlocking() && player.worldObj.rand.nextDouble() < 0.25 && entitySource.getEntity() != null && entitySource.getEntity() instanceof EntityLivingBase && (living = (EntityLivingBase)entitySource.getEntity()).isEntityAlive()) {
                        EntityWolf wolf = new EntityWolf(player.worldObj);
                        wolf.setLocationAndAngles(player.posX, player.posY, player.posZ, player.rotationPitch, player.rotationYawHead);
                        wolf.setAttackTarget(living);
                        wolf.setTarget((Entity)living);
                        wolf.setAngry(true);
                        wolf.addPotionEffect(new PotionEffect(Potion.wither.id, 12000, 1));
                        player.worldObj.spawnEntityInWorld((Entity)wolf);
                    }
                    boolean louseUsed = false;
                    int i = 0;
                    while (true) {
                        block69: {
                            ItemStack stack2;
                            block70: {
                                block72: {
                                    block71: {
                                        EntityPlayer entityPlayer = player;
                                        if (i >= entityPlayer.inventory.getHotbarSize()) break;
                                        stack2 = player.inventory.getStackInSlot(i);
                                        if (stack2 == null || stack2.getItem() != Witchery.Items.PARASYTIC_LOUSE || stack2.getItemDamage() <= 0) break block69;
                                        List list2 = Items.potionitem.getEffects(stack2.getItemDamage());
                                        if (list2 == null || list2.isEmpty()) break block70;
                                        effect2 = new PotionEffect((PotionEffect)list2.get(0));
                                        if (!GenericEvents.isPotionAggressive(effect2.getPotionID()) || event.source.getEntity() == null || !(event.source.getEntity() instanceof EntityLivingBase)) break block71;
                                        ((EntityLivingBase)event.source.getEntity()).addPotionEffect(effect2);
                                        break block72;
                                    }
                                    if (effect2.getPotionID() != Potion.regeneration.id) break block69;
                                    player.addPotionEffect(effect2);
                                }
                                player.attackEntityFrom(DamageSource.magic, 1.0f);
                                stack2.setItemDamage(0);
                                louseUsed = true;
                                break;
                            }
                            stack2.setItemDamage(0);
                        }
                        ++i;
                    }
                    if (!louseUsed && Witchery.Items.BITING_BELT.isBeltWorn(player) && (stack = player.inventory.armorItemInSlot(1)) != null && stack.hasTagCompound()) {
                        int potion;
                        boolean done = false;
                        if (stack.getTagCompound().hasKey("WITCPotion") && (list = Items.potionitem.getEffects(potion = stack.getTagCompound().getInteger("WITCPotion"))) != null && !list.isEmpty() && !player.isPotionActive((effect = new PotionEffect((PotionEffect)list.get(0))).getPotionID()) && effect.getPotionID() != Potion.regeneration.id) {
                            done = true;
                            if (GenericEvents.isPotionAggressive(effect.getPotionID()) && event.source.getEntity() != null && event.source.getEntity() instanceof EntityLivingBase) {
                                ((EntityLivingBase)event.source.getEntity()).addPotionEffect(effect);
                            } else {
                                player.addPotionEffect(effect);
                            }
                            player.attackEntityFrom(DamageSource.magic, 1.0f);
                            stack.getTagCompound().removeTag("WITCPotion");
                            if (stack.getTagCompound().hasNoTags()) {
                                stack.setTagCompound(null);
                            }
                        }
                        if (!done && stack.getTagCompound().hasKey("WITCPotion2") && (list = Items.potionitem.getEffects(potion = stack.getTagCompound().getInteger("WITCPotion2"))) != null && !list.isEmpty() && !player.isPotionActive((effect = new PotionEffect((PotionEffect)list.get(0))).getPotionID()) && effect.getPotionID() != Potion.regeneration.id) {
                            if (GenericEvents.isPotionAggressive(effect.getPotionID()) && event.source.getEntity() != null && event.source.getEntity() instanceof EntityLivingBase) {
                                ((EntityLivingBase)event.source.getEntity()).addPotionEffect(effect);
                            } else {
                                player.addPotionEffect(effect);
                            }
                            player.attackEntityFrom(DamageSource.magic, 1.0f);
                            stack.getTagCompound().removeTag("WITCPotion2");
                            if (stack.getTagCompound().hasNoTags()) {
                                stack.setTagCompound(null);
                            }
                        }
                    }
                    this.checkForRendArmor(event);
                    if (!ignoreProtection && !playerEx.isVampire()) {
                        ItemPoppet cfr_ignored_0 = Witchery.Items.POPPET;
                        ItemStack vampiricPoppetStack = ItemPoppet.findBoundPoppetInWorld(Witchery.Items.POPPET.vampiricPoppet, player, 66, true, false);
                        if (vampiricPoppetStack != null) {
                            EntityWitchHunter.blackMagicPerformed(player);
                            EntityLivingBase targetEntity = Witchery.Items.TAGLOCK_KIT.getBoundEntity(player.worldObj, (Entity)player, vampiricPoppetStack, 2);
                            if (targetEntity != null && !Witchery.Items.POPPET.voodooProtectionActivated(player, vampiricPoppetStack, targetEntity, true, false) && !ItemHunterClothes.isFullSetWorn(targetEntity, false)) {
                                if (targetEntity instanceof EntityPlayer) {
                                    targetEntity.attackEntityFrom(event.source, event.ammount);
                                    event.setCanceled(true);
                                } else if (targetEntity instanceof EntityLiving && targetEntity.isEntityAlive()) {
                                    targetEntity.attackEntityFrom(event.source, Math.min(event.ammount, 15.0f));
                                    if (!targetEntity.isEntityAlive()) {
                                        Witchery.Items.TAGLOCK_KIT.clearTaglock(vampiricPoppetStack, 2);
                                    }
                                    event.setCanceled(true);
                                }
                                return;
                            }
                        }
                    }
                    if (!louseUsed) {
                        i = 0;
                        while (true) {
                            EntityPlayer entityPlayer = player;
                            if (i >= entityPlayer.inventory.getHotbarSize()) break;
                            ItemStack stack3 = player.inventory.getStackInSlot(i);
                            if (stack3 != null && stack3.getItem() == Witchery.Items.PARASYTIC_LOUSE && stack3.getItemDamage() > 0) {
                                List list3 = Items.potionitem.getEffects(stack3.getItemDamage());
                                if (list3 != null && !list3.isEmpty()) {
                                    effect2 = new PotionEffect((PotionEffect)list3.get(0));
                                    if (effect2.getPotionID() == Potion.regeneration.id) {
                                        player.addPotionEffect(effect2);
                                    }
                                    player.attackEntityFrom(DamageSource.magic, 1.0f);
                                    stack3.setItemDamage(0);
                                    louseUsed = true;
                                    break;
                                }
                                stack3.setItemDamage(0);
                            }
                            ++i;
                        }
                    }
                    if (!louseUsed && Witchery.Items.BITING_BELT.isBeltWorn(player) && (stack = player.inventory.armorItemInSlot(1)) != null && stack.hasTagCompound()) {
                        int potion;
                        boolean done = false;
                        if (stack.getTagCompound().hasKey("WITCPotion") && (list = Items.potionitem.getEffects(potion = stack.getTagCompound().getInteger("WITCPotion"))) != null && !list.isEmpty() && !player.isPotionActive((effect = new PotionEffect((PotionEffect)list.get(0))).getPotionID()) && effect.getPotionID() == Potion.regeneration.id) {
                            done = true;
                            player.addPotionEffect(effect);
                            player.attackEntityFrom(DamageSource.magic, 1.0f);
                            stack.getTagCompound().removeTag("WITCPotion");
                            if (stack.getTagCompound().hasNoTags()) {
                                stack.setTagCompound(null);
                            }
                        }
                        if (!done && stack.getTagCompound().hasKey("WITCPotion2") && (list = Items.potionitem.getEffects(potion = stack.getTagCompound().getInteger("WITCPotion2"))) != null && !list.isEmpty() && !player.isPotionActive((effect = new PotionEffect((PotionEffect)list.get(0))).getPotionID()) && effect.getPotionID() == Potion.regeneration.id) {
                            player.addPotionEffect(effect);
                            player.attackEntityFrom(DamageSource.magic, 1.0f);
                            stack.getTagCompound().removeTag("WITCPotion2");
                            if (stack.getTagCompound().hasNoTags()) {
                                stack.setTagCompound(null);
                            }
                        }
                    }
                }
                if (healthAfterDamage <= 0.0f && !wolfForm && !playerEx.isVampire()) {
                    Log.instance().debug(String.format("player terminal damage", new Object[0]));
                    if (event.source.damageType.equals(DamageSource.fall.damageType) || event.source.damageType.equals(DamageSource.fallingBlock.damageType)) {
                        Witchery.Items.POPPET.cancelEventIfPoppetFound(player, Witchery.Items.POPPET.earthPoppet, event, false);
                    } else if (event.source.isFireDamage() || event.source.isExplosion()) {
                        Witchery.Items.POPPET.cancelEventIfPoppetFound(player, Witchery.Items.POPPET.firePoppet, event, true);
                        if (event.isCanceled()) {
                            player.addPotionEffect(new PotionEffect(Potion.fireResistance.id, 60, 0));
                        }
                    } else if (event.source.damageType.equals(DamageSource.drown.damageType)) {
                        Witchery.Items.POPPET.cancelEventIfPoppetFound(player, Witchery.Items.POPPET.waterPoppet, event, true);
                        if (event.isCanceled()) {
                            player.addPotionEffect(new PotionEffect(Potion.waterBreathing.id, 60, 0));
                        }
                    } else if (event.source.damageType.equals(DamageSource.starve.damageType)) {
                        Witchery.Items.POPPET.cancelEventIfPoppetFound(player, Witchery.Items.POPPET.foodPoppet, event, true);
                        if (event.isCanceled()) {
                            player.addPotionEffect(new PotionEffect(Potion.field_76443_y.id, 60, 0));
                        }
                    }
                    if (!event.isCanceled()) {
                        Witchery.Items.POPPET.cancelEventIfPoppetFound(player, Witchery.Items.POPPET.deathPoppet, event, true, ignoreProtection);
                        if (event.isCanceled()) {
                            if (player.isBurning() || event.source.isFireDamage() || event.source.isExplosion()) {
                                player.addPotionEffect(new PotionEffect(Potion.fireResistance.id, 120, 0));
                            } else if (event.source.damageType.equals(DamageSource.drown.damageType)) {
                                player.addPotionEffect(new PotionEffect(Potion.waterBreathing.id, 120, 0));
                            } else if (event.source.damageType.equals(DamageSource.starve.damageType)) {
                                player.addPotionEffect(new PotionEffect(Potion.field_76443_y.id, 120, 0));
                            }
                        }
                    }
                }
                if (!event.isCanceled() && healthAfterDamage <= 2.0f && event.source.damageType.equals(DamageSource.starve.damageType)) {
                    Witchery.Items.POPPET.cancelEventIfPoppetFound(player, Witchery.Items.POPPET.foodPoppet, event, true);
                    if (event.isCanceled()) {
                        player.addPotionEffect(new PotionEffect(Potion.field_76443_y.id, 60, 0));
                    }
                }
                Familiar.handlePlayerHurt(event, player);
                this.checkForWolfInfection(event, healthAfterDamage);
                Witchery.Items.POPPET.checkForArmorProtection(player);
                break block66;
            }
            if (event.entityLiving instanceof EntityGoblin && event.source == DamageSource.fall) {
                event.setCanceled(true);
                return;
            }
            if (event.entityLiving instanceof EntityVillager && event.source != null && event.source.getEntity() != null && (event.source.getEntity() instanceof EntityVillageGuard || event.source.getEntity() instanceof EntityWitchHunter)) {
                event.setCanceled(true);
                return;
            }
            if (Config.instance().isReduceZombeVillagerDamageActive() && event.entityLiving instanceof EntityVillager && event.source.getEntity() != null && event.source.getEntity() instanceof EntityZombie) {
                event.ammount = 0.5f;
            }
            this.checkForRendArmor(event);
            this.checkForWolfInfection(event, EntityUtil.getHealthAfterDamage(event, event.entityLiving.getHealth(), event.entityLiving));
        }
    }

    public void checkForRendArmor(LivingHurtEvent event) {
        if (event.source.damageType.equals("player") && event.source.getEntity() != null && event.source.getEntity() instanceof EntityPlayer) {
            EntityPlayer attackingPlayer = (EntityPlayer)event.source.getEntity();
            ExtendedPlayer playerEx = ExtendedPlayer.get(attackingPlayer);
            Shapeshift.INSTANCE.rendArmor(event.entityLiving, attackingPlayer, playerEx);
        }
    }

    public void checkForWolfInfection(LivingHurtEvent event, float health) {
        if (!event.isCanceled()) {
            if (event.source.damageType.equals("player") && event.source.getSourceOfDamage() != null && event.source.getSourceOfDamage() instanceof EntityPlayer) {
                EntityPlayer attackingPlayer = (EntityPlayer)event.source.getEntity();
                ExtendedPlayer playerEx = ExtendedPlayer.get(attackingPlayer);
                Shapeshift.INSTANCE.processWolfInfection(event.entityLiving, attackingPlayer, playerEx, health);
            } else if (event.source.damageType.equals("mob") && event.source.getSourceOfDamage() instanceof EntityWolfman) {
                Shapeshift.INSTANCE.processWolfInfection(event.entityLiving, (EntityWolfman)event.source.getSourceOfDamage(), health);
            }
        }
    }

    public void checkForChargeDamage(LivingHurtEvent event) {
        if (event.source.damageType.equals("player") && event.source.getEntity() != null && event.source.getEntity() instanceof EntityPlayer) {
            EntityPlayer attackingPlayer = (EntityPlayer)event.source.getEntity();
            ExtendedPlayer playerEx = ExtendedPlayer.get(attackingPlayer);
            Shapeshift.INSTANCE.updateChargeDamage(event, attackingPlayer, playerEx);
        }
    }

    private static boolean isPotionAggressive(int potionID) {
        return potionID == Potion.digSlowdown.id || potionID == Potion.moveSlowdown.id || potionID == Potion.poison.id || potionID == Potion.wither.id || potionID == Potion.weakness.id || potionID == Potion.hunger.id;
    }

    private static void dropItemsOnHit(EntityPlayer player) {
        for (int i = 0; i < player.inventory.mainInventory.length; ++i) {
            ItemStack stack = player.inventory.mainInventory[i];
            if (!Witchery.Items.GENERIC.itemBatBall.isMatch(stack)) continue;
            player.dropPlayerItemWithRandomChoice(stack, true);
            player.inventory.mainInventory[i] = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entityLiving.worldObj.isRemote && !event.isCanceled()) {
            EntityPlayer player;
            ExtendedPlayer playerEx;
            if (event.entityLiving instanceof EntityPlayer && (playerEx = ExtendedPlayer.get(player = (EntityPlayer)event.entityLiving)).isVampire()) {
                event.setCanceled(true);
                player.setHealth(1.0f);
                return;
            }
        } else if (!(event.entityLiving.worldObj.isRemote || event.isCancelable() && event.isCanceled())) {
            Entity entitySource;
            EntityPlayer player;
            ExtendedPlayer playerEx;
            if (event.entityLiving instanceof EntityPlayer && (playerEx = ExtendedPlayer.get(player = (EntityPlayer)event.entityLiving)).isVampire()) {
                if (player.getHealth() > 0.0f) {
                    event.setCanceled(true);
                    return;
                }
                if (!CreatureUtil.checkForVampireDeath((EntityLivingBase)player, event.source)) {
                    event.setCanceled(true);
                    return;
                }
            }
            this.dropExtraItemsFromNBT(event);
            Entity attacker = event.source.getEntity();
            if (attacker != null && attacker instanceof EntityPlayer) {
                EntityPlayer player2 = (EntityPlayer)attacker;
                ExtendedPlayer playerEx2 = ExtendedPlayer.get(player2);
                if (event.entity instanceof EntityHornedHuntsman && playerEx2.getWolfmanQuestState() == ExtendedPlayer.QuestState.STARTED) {
                    playerEx2.setWolfmanQuestState(ExtendedPlayer.QuestState.COMPLETE);
                }
                if (playerEx2.hasVampireBook()) {
                    boolean dropPage;
                    boolean bl = dropPage = event.entityLiving instanceof IBossDisplayData || (event.entityLiving instanceof EntityPigZombie || event.entityLiving instanceof EntityEnderman) && player2.worldObj.rand.nextDouble() < 0.09 || PotionParalysis.isVillager((Entity)event.entityLiving) && player2.worldObj.rand.nextDouble() < 0.1 || event.entityLiving.isEntityUndead() && player2.worldObj.rand.nextDouble() < 0.02;
                    if (dropPage) {
                        EntityItem entityItem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY + 1.0, event.entityLiving.posZ, Witchery.Items.GENERIC.itemVampireBookPage.createStack());
                        event.entityLiving.worldObj.spawnEntityInWorld((Entity)entityItem);
                    }
                }
            }
            if ((entitySource = event.source.getSourceOfDamage()) != null && entitySource instanceof EntityPlayer) {
                boolean allowDrops;
                EntityPlayer player3 = (EntityPlayer)entitySource;
                ExtendedPlayer playerEx3 = ExtendedPlayer.get(player3);
                boolean hasArthana = player3.inventory.getCurrentItem() != null && player3.inventory.getCurrentItem().getItem() == Witchery.Items.ARTHANA;
                boolean hasCaneSword = player3.inventory.getCurrentItem() != null && player3.inventory.getCurrentItem().getItem() == Witchery.Items.CANE_SWORD && Witchery.Items.CANE_SWORD.isDrawn((EntityLivingBase)player3) && playerEx3.isVampire();
                ItemStack itemstack = null;
                Shapeshift.INSTANCE.processCreatureKilled(event, player3, playerEx3);
                if (playerEx3.getWerewolfLevel() == 5 && Shapeshift.INSTANCE.isWolfAnimalForm(playerEx3) && playerEx3.getWolfmanQuestState() == ExtendedPlayer.QuestState.STARTED) {
                    if (event.entity instanceof IMob && !player3.onGround) {
                        playerEx3.increaseWolfmanQuestCounter();
                    }
                } else if (playerEx3.getWerewolfLevel() == 8 && playerEx3.getCreatureType() == TransformCreature.WOLFMAN && playerEx3.getWolfmanQuestState() == ExtendedPlayer.QuestState.STARTED) {
                    if (event.entity instanceof EntityPigZombie) {
                        playerEx3.increaseWolfmanQuestCounter();
                    }
                } else if (playerEx3.getWerewolfLevel() == 9 && Shapeshift.INSTANCE.isWolfAnimalForm(playerEx3) && playerEx3.getWolfmanQuestState() == ExtendedPlayer.QuestState.STARTED && (event.entity instanceof EntityVillager || event.entity instanceof EntityPlayer)) {
                    playerEx3.increaseWolfmanQuestCounter();
                }
                if (playerEx3.getVampireLevel() == 5 && playerEx3.canIncreaseVampireLevel() && event.entity instanceof EntityBlaze) {
                    if (playerEx3.getVampireQuestCounter() >= 19) {
                        playerEx3.increaseVampireLevel();
                    } else {
                        playerEx3.increaseVampireQuestCounter();
                    }
                }
                int baseLooting = EnchantmentHelper.getLootingModifier((EntityLivingBase)player3);
                double lootingFactor = 1.0 + (double)baseLooting;
                double halfLooting = 1.0 + (double)(baseLooting / 2);
                if (InfusedBrewEffect.getActiveBrew(player3) == InfusedBrewEffect.Grave) {
                    float maxHealth = player3.getMaxHealth();
                    if (event.entityLiving instanceof EntityPlayer) {
                        player3.getFoodStats().addStats(20, 0.9f);
                        player3.heal(maxHealth * 0.6f);
                    } else if (event.entityLiving instanceof EntityVillager) {
                        player3.getFoodStats().addStats(20, 0.9f);
                        player3.heal(maxHealth * 0.4f);
                    } else if (event.entityLiving instanceof EntityAnimal) {
                        player3.getFoodStats().addStats(8, 0.8f);
                        player3.heal(maxHealth * 0.1f);
                    }
                }
                Witchery.Items.BLOOD_GOBLET.handleCreatureDeath(player3.worldObj, player3, event.entityLiving);
                boolean bl = allowDrops = !EntityUtil.isNoDrops(event.entityLiving);
                if (allowDrops) {
                    if (event.entityLiving instanceof EntityVillager) {
                        ExtendedVillager villagerEx = ExtendedVillager.get((EntityVillager)event.entityLiving);
                        playerEx3.fillBloodReserve(villagerEx.getBlood());
                    } else if (event.entityLiving instanceof EntityVillageGuard) {
                        EntityVillageGuard guard = (EntityVillageGuard)event.entityLiving;
                        playerEx3.fillBloodReserve(guard.getBlood());
                    } else if (event.entityLiving instanceof EntityPlayer) {
                        ExtendedPlayer targetEx = ExtendedPlayer.get((EntityPlayer)event.entityLiving);
                        playerEx3.fillBloodReserve(targetEx.getHumanBlood());
                    } else if (event.entityLiving instanceof EntitySkeleton) {
                        EntitySkeleton skeleton = (EntitySkeleton)event.entityLiving;
                        if (hasArthana && skeleton.getSkeletonType() == 0 && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.05 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(Items.skull, 1, 0);
                        } else if (hasArthana && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.04 * lootingFactor, 1.0)) {
                            itemstack = Witchery.Items.GENERIC.itemSpectralDust.createStack();
                        }
                    } else if (event.entityLiving instanceof EntityZombie) {
                        if (hasArthana && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.02 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(Items.skull, 1, 2);
                        } else if (hasArthana && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.03 * lootingFactor, 1.0)) {
                            itemstack = Witchery.Items.GENERIC.itemSpectralDust.createStack();
                        }
                    } else if (event.entityLiving instanceof EntityCreeper) {
                        if (hasArthana && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.01 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(Items.skull, 1, 4);
                        } else {
                            double d = event.entityLiving.worldObj.rand.nextDouble();
                            double d2 = hasArthana ? 0.08 : 0.02;
                            if (d <= Math.min(d2 * lootingFactor, 1.0)) {
                                itemstack = Witchery.Items.GENERIC.itemCreeperHeart.createStack();
                            }
                        }
                    } else if (event.entityLiving instanceof EntityDemon) {
                        if (hasArthana && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.33 * halfLooting, 1.0)) {
                            itemstack = Witchery.Items.GENERIC.itemDemonHeart.createStack();
                        }
                    } else if (event.entityLiving instanceof EntityPlayer) {
                        if (hasArthana && event.entityLiving.worldObj.rand.nextDouble() <= Math.min(0.1 * halfLooting, 1.0)) {
                            EntityPlayer victim = (EntityPlayer)event.entityLiving;
                            itemstack = new ItemStack(Items.skull, 1, 3);
                            NBTTagCompound tag = itemstack.getTagCompound();
                            if (tag == null) {
                                tag = new NBTTagCompound();
                                itemstack.setTagCompound(tag);
                            }
                            tag.setString("SkullOwner", victim.getCommandSenderName());
                        }
                    } else if (event.entityLiving instanceof EntityBat) {
                        double d = player3.worldObj.rand.nextDouble();
                        double d3 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                        if (d <= d3) {
                            itemstack = Witchery.Items.GENERIC.itemBatWool.createStack();
                        }
                    } else if (event.entityLiving instanceof EntityWolf) {
                        double d = player3.worldObj.rand.nextDouble();
                        double d4 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                        if (d <= d4) {
                            itemstack = Witchery.Items.GENERIC.itemDogTongue.createStack();
                        }
                        if (player3.worldObj.rand.nextInt(12) <= Math.min(baseLooting, 3)) {
                            event.entityLiving.entityDropItem(new ItemStack(Witchery.Blocks.WOLFHEAD, 1, 0), 0.0f);
                        }
                    } else if (event.entityLiving instanceof EntityOwl) {
                        if (!((EntityOwl)event.entityLiving).isTemp()) {
                            double d = player3.worldObj.rand.nextDouble();
                            double d5 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.5) : 0.2;
                            if (d <= d5) {
                                itemstack = Witchery.Items.GENERIC.itemOwletsWing.createStack();
                            }
                        }
                    } else if (event.entityLiving instanceof EntitySheep) {
                        if (CreatureUtil.isWerewolf(entitySource, false) && !((EntitySheep)event.entityLiving).isChild() && event.entityLiving.worldObj.rand.nextInt(4) != 0) {
                            itemstack = Witchery.Items.GENERIC.itemMuttonRaw.createStack();
                        }
                    } else if (event.entityLiving instanceof EntityToad) {
                        if (!((EntityToad)event.entityLiving).isTemp()) {
                            double d = player3.worldObj.rand.nextDouble();
                            double d6 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.5) : 0.2;
                            if (d <= d6) {
                                itemstack = Witchery.Items.GENERIC.itemToeOfFrog.createStack();
                            }
                        }
                    } else {
                        try {
                            String name;
                            Class<?> theClass = event.entityLiving.getClass();
                            if (theClass != null && (name = theClass.getSimpleName()) != null && !name.isEmpty()) {
                                String upperName = name.toUpperCase(Locale.ROOT);
                                if (upperName.contains("WOLF") || name.contains("Dog") || name.contains("Fox")) {
                                    double d = player3.worldObj.rand.nextDouble();
                                    double d7 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                                    if (d <= d7) {
                                        itemstack = Witchery.Items.GENERIC.itemDogTongue.createStack();
                                    }
                                    if ((upperName.contains("WOLF") || name.contains("Dog")) && player3.worldObj.rand.nextInt(12) <= Math.min(baseLooting, 3)) {
                                        event.entityLiving.entityDropItem(new ItemStack(Witchery.Blocks.WOLFHEAD, 1, 0), 0.0f);
                                    }
                                } else if (upperName.contains("FIREBAT") || name.contains("Bat")) {
                                    double d = player3.worldObj.rand.nextDouble();
                                    double d8 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                                    if (d <= d8) {
                                        itemstack = Witchery.Items.GENERIC.itemBatWool.createStack();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.instance().debug(String.format("Exception occurred while determining dead creature type: %s", e.toString()));
                        }
                    }
                }
                if (itemstack != null) {
                    EntityItem entityItem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY + 1.0, event.entityLiving.posZ, itemstack);
                    event.entityLiving.worldObj.spawnEntityInWorld((Entity)entityItem);
                }
            }
        }
    }

    private void dropExtraItemsFromNBT(LivingDeathEvent event) {
        NBTTagCompound nbtEntityData;
        if (!event.entityLiving.worldObj.isRemote && (nbtEntityData = event.entityLiving.getEntityData()).hasKey("WITCExtraDrops")) {
            NBTTagList nbtExtraDrops = nbtEntityData.getTagList("WITCExtraDrops", 10);
            for (int i = 0; i < nbtExtraDrops.tagCount(); ++i) {
                NBTTagCompound nbtTag = nbtExtraDrops.getCompoundTagAt(i);
                ItemStack extraStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtTag);
                if (extraStack == null) continue;
                EntityItem entityItem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY + 1.0, event.entityLiving.posZ, extraStack);
                event.entityLiving.worldObj.spawnEntityInWorld((Entity)entityItem);
            }
        }
    }
}

