/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.client.renderer;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockPoppetShelf;
import com.emoniph.witchery.client.model.ModelPoppetChest;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPoppetChest
extends TileEntitySpecialRenderer {
    final ModelPoppetChest model = new ModelPoppetChest();
    private RenderItem renderItems = new RenderItem(){

        public byte getMiniItemCountForItemStack(ItemStack stack) {
            return 1;
        }

        public byte getMiniBlockCountForItemStack(ItemStack stack) {
            return 1;
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    private static final ResourceLocation TEXTURE_URL = new ResourceLocation("witchery", "textures/blocks/poppetShelf.png");

    public RenderPoppetChest() {
        this.renderItems.setRenderManager(RenderManager.instance);
    }

    public void renderTileEntityAt(TileEntity tileEntity, double d, double d1, double d2, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        BlockPoppetShelf.TileEntityPoppetShelf tileEntityYour = (BlockPoppetShelf.TileEntityPoppetShelf)tileEntity;
        this.renderPoppetChest(tileEntityYour, tileEntity.getWorldObj(), tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord, Witchery.Blocks.POPPET_SHELF);
        GL11.glPopMatrix();
    }

    public void renderPoppetChest(BlockPoppetShelf.TileEntityPoppetShelf te, World world, int x, int y, int z, Block block) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.bindTexture(TEXTURE_URL);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        if (world != null) {
            ItemStack newStack = null;
            float rotational = (float)Minecraft.getSystemTime() / 3000.0f * 300.0f;
            EntityItem ei = new EntityItem(world);
            ei.hoverStart = 0.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)170.0f, (float)170.0f);
            GL11.glTranslatef((float)0.0f, (float)0.6f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            float zShift = 0.0f;
            float yShift = 0.0f;
            float xShift = 0.0f;
            zShift = 0.5f;
            boolean fancy = Witchery.proxy.getGraphicsLevel();
            for (int i = 0; i < te.getSizeInventory() && i <= 46; ++i) {
                xShift += 0.5f;
                if (i == 3 || i == 6 || i == 9) {
                    zShift += 0.5f;
                    xShift = 0.5f;
                }
                if (te.getStackInSlot(i) == null || te.getStackInSlot(i).getItem() != Witchery.Items.POPPET) continue;
                newStack = te.getStackInSlot(i).copy();
                newStack.stackSize = 1;
                ei.setEntityItemStack(newStack);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)xShift, (float)yShift, (float)zShift);
                if (fancy) {
                    GL11.glRotatef((float)(rotational / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glPushMatrix();
                this.renderItems.doRender(ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

